/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.kernel.scanner.AbstractScanner;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NeedleEye;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Option;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.quartz.CronExpression;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedService.class}, property={"service.description=Timed media archiver Service"})
public class TimedMediaArchiver
extends AbstractScanner
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(TimedMediaArchiver.class);
    public static final String PARAM_KEY_STORE_ID = "store-id";
    public static final String PARAM_KEY_MAX_AGE = "max-age";
    public static final String JOB_GROUP = "oc-asset-manager-timed-media-archiver-group";
    public static final String JOB_NAME = "oc-asset-manager-timed-media-archive-job";
    public static final String SCANNER_NAME = "Timed media archive offloader";
    public static final String TRIGGER_GROUP = "oc-asset-manager-timed-media-archiver-trigger-group";
    public static final String TRIGGER_NAME = "oc-asset-manager-timed-media-archiver-trigger";
    private AssetManager assetManager;
    private WorkflowService workflowService;
    private String storeId;
    private long ageModifier;

    public TimedMediaArchiver() {
        try {
            this.quartz = new StdSchedulerFactory().getScheduler();
            this.quartz.start();
            JobDetail job = new JobDetail(this.getJobName(), this.getJobGroup(), Runner.class);
            job.setDurability(false);
            job.setVolatility(true);
            job.getJobDataMap().put((Object)"parent", (Object)this);
            this.quartz.addJob(job, true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.unschedule();
        if (properties != null) {
            logger.debug("Updating configuration...");
            boolean enabled = BooleanUtils.toBoolean((String)((String)properties.get("enabled")));
            this.setEnabled(enabled);
            logger.info("Timed media offload enabled: " + enabled);
            if (!this.isEnabled()) {
                return;
            }
            String cronExpression = (String)properties.get("cron-expression");
            if (StringUtils.isBlank((CharSequence)cronExpression) || !CronExpression.isValidExpression((String)cronExpression)) {
                throw new ConfigurationException("cron-expression", "Cron expression must be valid");
            }
            this.setCronExpression(cronExpression);
            logger.debug("Timed media offload cron expression: '" + cronExpression + "'");
            this.storeId = (String)properties.get(PARAM_KEY_STORE_ID);
            if (StringUtils.isBlank((CharSequence)this.storeId)) {
                throw new ConfigurationException(PARAM_KEY_STORE_ID, "Store type is missing");
            }
            logger.debug("Remote media store type: " + this.storeId);
            try {
                this.ageModifier = Long.parseLong((String)properties.get(PARAM_KEY_MAX_AGE));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(PARAM_KEY_MAX_AGE, "Invalid max age");
            }
            if (this.ageModifier < 0L) {
                throw new ConfigurationException(PARAM_KEY_MAX_AGE, "Max age must be greater than zero");
            }
        }
        this.schedule();
    }

    public String getJobGroup() {
        return JOB_GROUP;
    }

    public String getJobName() {
        return JOB_NAME;
    }

    public String getTriggerGroupName() {
        return TRIGGER_GROUP;
    }

    public String getTriggerName() {
        return TRIGGER_NAME;
    }

    public void scan() {
        Date maxAge = Calendar.getInstance().getTime();
        maxAge.setTime(maxAge.getTime() - TimeUnit.HOURS.toMillis(this.ageModifier));
        if (this.assetManager.getAssetStore(this.storeId).isEmpty()) {
            throw new RuntimeException("Store " + this.storeId + " is not available to the asset manager");
        }
        try {
            this.assetManager.moveSnapshotsByDate(new Date(0L), maxAge, this.storeId);
        }
        catch (NotFoundException ignore) {
            logger.debug("No snapshots found that need to be moved");
        }
    }

    public String getScannerName() {
        return SCANNER_NAME;
    }

    @Reference
    public void setAssetManager(AssetManager am) {
        this.assetManager = am;
    }

    @Reference
    public void bindOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        super.bindOrganizationDirectoryService(organizationDirectoryService);
    }

    @Reference
    public void bindSecurityService(SecurityService securityService) {
        super.bindSecurityService(securityService);
    }

    @Reference
    public void bindServiceRegistry(ServiceRegistry serviceRegistry) {
        super.bindServiceRegistry(serviceRegistry);
    }

    public static class Runner
    extends AbstractScanner.TypedQuartzJob<AbstractScanner> {
        private static final NeedleEye eye = new NeedleEye();

        public Runner() {
            super(Option.some((Object)eye));
        }

        protected void execute(AbstractScanner parameters, JobExecutionContext ctx) {
            logger.debug("Starting " + parameters.getScannerName() + " job.");
            for (Organization org : parameters.getOrganizationDirectoryService().getOrganizations()) {
                parameters.getAdminContextFor(org.getId()).runInContext(() -> ((AbstractScanner)parameters).scan());
            }
            logger.debug("Finished " + parameters.getScannerName() + " job.");
        }
    }
}

