/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl;

import com.google.gson.Gson;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.AssetManagerException;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.RichAResult;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RequireUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AssetManagerJobProducer.class}, property={"service.description=Opencast Asset Manager Job Producer"})
public class AssetManagerJobProducer
extends AbstractJobProducer {
    private static final Logger logger = LoggerFactory.getLogger(AssetManagerJobProducer.class);
    public static final String JOB_TYPE = "org.opencastproject.assetmanager";
    public static final Float JOB_LOAD = Float.valueOf(0.1f);
    public static final Float NONTERMINAL_JOB_LOAD = Float.valueOf(0.1f);
    private static final String OK = "OK";
    private AssetManager tsam = null;
    private ServiceRegistry serviceRegistry = null;
    private SecurityService securityService = null;
    private UserDirectoryService userDirectoryService = null;
    private OrganizationDirectoryService organizationDirectoryService = null;

    public AssetManagerJobProducer() {
        super(JOB_TYPE);
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating assetmanager job service");
        super.activate(cc);
    }

    public boolean datastoreExists(String storeId) {
        Optional store = this.tsam.getAssetStore(storeId);
        return store.isPresent();
    }

    protected String process(Job job) throws ServiceRegistryException {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        String targetStore = (String)arguments.get(0);
        try {
            op = Operation.valueOf(operation);
            switch (op) {
                case MoveById: {
                    String id = (String)arguments.get(1);
                    return this.internalMoveById(id, targetStore);
                }
                case MoveByIdAndVersion: {
                    String id = (String)arguments.get(1);
                    VersionImpl version = VersionImpl.mk(Long.parseLong((String)arguments.get(2)));
                    return this.internalMoveByIdAndVersion(version, id, targetStore);
                }
                case MoveByDate: {
                    Date start = new Date(Long.parseLong((String)arguments.get(1)));
                    Date end = new Date(Long.parseLong((String)arguments.get(2)));
                    return this.internalMoveByDate(start, end, targetStore);
                }
                case MoveByIdAndDate: {
                    String id = (String)arguments.get(1);
                    Date start = new Date(Long.parseLong((String)arguments.get(2)));
                    Date end = new Date(Long.parseLong((String)arguments.get(3)));
                    return this.internalMoveByIdAndDate(id, start, end, targetStore);
                }
            }
            throw new IllegalArgumentException("Unknown operation '" + operation + "'");
        }
        catch (NotFoundException e) {
            throw new ServiceRegistryException("Error running job", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operation '" + op + "'", (Throwable)e);
        }
    }

    public Job moveByIdAndVersion(Version version, String mpId, String targetStorage) {
        RequireUtil.notNull((Object)version, (String)"version");
        RequireUtil.notEmpty((String)mpId, (String)"mpId");
        RequireUtil.notEmpty((String)targetStorage, (String)"targetStorage");
        LinkedList<String> args = new LinkedList<String>();
        args.add(targetStorage);
        args.add(mpId);
        args.add(version.toString());
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.MoveByIdAndVersion.toString(), args, null, true, JOB_LOAD);
        }
        catch (ServiceRegistryException e) {
            throw new AssetManagerException("Unable to create a job", (Throwable)e);
        }
    }

    protected String internalMoveByIdAndVersion(Version version, String mpId, String targetStorage) throws NotFoundException {
        this.tsam.moveSnapshotToStore(version, mpId, targetStorage);
        return OK;
    }

    public Job moveById(String mpId, String targetStorage) {
        RequireUtil.notEmpty((String)mpId, (String)"mpId");
        RequireUtil.notEmpty((String)targetStorage, (String)"targetStorage");
        LinkedList<String> args = new LinkedList<String>();
        args.add(targetStorage);
        args.add(mpId);
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.MoveById.toString(), args, null, true, NONTERMINAL_JOB_LOAD);
        }
        catch (ServiceRegistryException e) {
            throw new AssetManagerException("Unable to create a job", (Throwable)e);
        }
    }

    protected String internalMoveById(String mpId, String targetStorage) {
        RichAResult results = this.tsam.getSnapshotsByIdOrderedByVersion(mpId, true);
        MoveRecordInfo result = this.moveSnapshots(results, targetStorage);
        return result.toString();
    }

    public Job moveByDate(Date start, Date end, String targetStorage) {
        RequireUtil.notNull((Object)start, (String)"start");
        RequireUtil.notNull((Object)end, (String)"end");
        RequireUtil.notNull((Object)targetStorage, (String)"targetStorage");
        LinkedList<String> args = new LinkedList<String>();
        args.add(targetStorage);
        args.add(Long.toString(start.getTime()));
        args.add(Long.toString(end.getTime()));
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.MoveByDate.toString(), args, null, true, NONTERMINAL_JOB_LOAD);
        }
        catch (ServiceRegistryException e) {
            throw new AssetManagerException("Unable to create a job", (Throwable)e);
        }
    }

    protected String internalMoveByDate(Date start, Date end, String targetStorage) {
        RichAResult results = this.tsam.getSnapshotsByDateOrderedById(start, end);
        List<Job> subjobs = this.spawnSubjobs(results, start, end, targetStorage);
        return Integer.toString(subjobs.size());
    }

    public Job moveByIdAndDate(String mpId, Date start, Date end, String targetStorage) {
        RequireUtil.notNull((Object)mpId, (String)"mpId");
        RequireUtil.notNull((Object)start, (String)"start");
        RequireUtil.notNull((Object)end, (String)"end");
        RequireUtil.notNull((Object)targetStorage, (String)"targetStorage");
        LinkedList<String> args = new LinkedList<String>();
        args.add(targetStorage);
        args.add(mpId);
        args.add(Long.toString(start.getTime()));
        args.add(Long.toString(end.getTime()));
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.MoveByIdAndDate.toString(), args, null, true, NONTERMINAL_JOB_LOAD);
        }
        catch (ServiceRegistryException e) {
            throw new AssetManagerException("Unable to create a job", (Throwable)e);
        }
    }

    protected String internalMoveByIdAndDate(String mpId, Date start, Date end, String targetStorage) {
        RichAResult results = this.tsam.getSnapshotsByIdAndDateOrderedByVersion(mpId, start, end, true);
        MoveRecordInfo result = this.moveSnapshots(results, targetStorage);
        return result.toString();
    }

    private List<Job> spawnSubjobs(RichAResult records, final Date start, final Date end, final String targetStorage) {
        final LinkedList<Job> jobs = new LinkedList<Job>();
        final MoveRecordInfo recordInfo = new MoveRecordInfo();
        records.forEach((Consumer)new Consumer<ARecord>(){

            @Override
            public void accept(ARecord record) {
                Snapshot snap = (Snapshot)record.getSnapshot().get();
                String mediaPackageId = snap.getMediaPackage().getIdentifier().toString();
                if (recordInfo.isNewMpId(mediaPackageId)) {
                    jobs.add(AssetManagerJobProducer.this.moveByIdAndDate(mediaPackageId, start, end, targetStorage));
                }
            }
        });
        return jobs;
    }

    private MoveRecordInfo moveSnapshots(RichAResult records, final String targetStorage) {
        final MoveRecordInfo result = new MoveRecordInfo();
        records.forEach((Consumer)new Consumer<ARecord>(){

            @Override
            public void accept(ARecord record) {
                Snapshot snap = (Snapshot)record.getSnapshot().get();
                try {
                    logger.debug("moving Mediapackage {} Version {} from {} to {}", new Object[]{snap.getMediaPackage().getIdentifier().toString(), snap.getVersion().toString(), snap.getStorageId(), targetStorage});
                    AssetManagerJobProducer.this.internalMoveByIdAndVersion(snap.getVersion(), snap.getMediaPackage().getIdentifier().toString(), targetStorage);
                    result.addSuccess();
                }
                catch (NotFoundException e) {
                    result.addFailed();
                    logger.warn(e.getMessage());
                }
            }
        });
        return result;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    protected void setAssetManager(AssetManager assetManager) {
        this.tsam = assetManager;
    }

    @Reference
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    @Reference
    protected void setUserDirectoryService(UserDirectoryService uds) {
        this.userDirectoryService = uds;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    @Reference
    protected void setOrganizationDirectoryService(OrganizationDirectoryService os) {
        this.organizationDirectoryService = os;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    private class MoveRecordInfo {
        private final Gson gson = new Gson();
        private int success = 0;
        private int failed = 0;
        private String currentMpId = "";

        private MoveRecordInfo() {
        }

        public void addSuccess() {
            ++this.success;
        }

        public void addFailed() {
            ++this.failed;
        }

        public boolean isNewMpId(String mpId) {
            if (this.currentMpId.equals(mpId)) {
                return false;
            }
            this.currentMpId = mpId;
            return true;
        }

        public String toString() {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            if (this.success > 0) {
                result.put(AssetManagerJobProducer.OK, this.success);
            }
            if (this.failed > 0) {
                result.put("FAIL", this.failed);
            }
            return this.gson.toJson(result);
        }
    }

    public static enum Operation {
        MoveById,
        MoveByIdAndVersion,
        MoveByIdAndDate,
        MoveByDate,
        MoveRecords;

    }
}

