/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Fx;
import com.entwinemedia.fn.P1;
import com.entwinemedia.fn.P1Lazy;
import com.entwinemedia.fn.Pred;
import com.entwinemedia.fn.Prelude;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.fns.Booleans;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.Asset;
import org.opencastproject.assetmanager.api.AssetId;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.AssetManagerException;
import org.opencastproject.assetmanager.api.Availability;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.fn.Enrichments;
import org.opencastproject.assetmanager.api.query.ADeleteQuery;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.ASelectQuery;
import org.opencastproject.assetmanager.api.query.RichAResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.assetmanager.api.storage.AssetStore;
import org.opencastproject.assetmanager.api.storage.DeletionSelector;
import org.opencastproject.assetmanager.api.storage.RemoteAssetStore;
import org.opencastproject.assetmanager.api.storage.Source;
import org.opencastproject.assetmanager.api.storage.StoragePath;
import org.opencastproject.assetmanager.impl.ADeleteQueryDecorator;
import org.opencastproject.assetmanager.impl.AQueryBuilderDecorator;
import org.opencastproject.assetmanager.impl.AssetImpl;
import org.opencastproject.assetmanager.impl.HttpAssetProvider;
import org.opencastproject.assetmanager.impl.PartialMediaPackage;
import org.opencastproject.assetmanager.impl.RuntimeTypes;
import org.opencastproject.assetmanager.impl.SnapshotImpl;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.assetmanager.impl.persistence.AssetDtos;
import org.opencastproject.assetmanager.impl.persistence.Database;
import org.opencastproject.assetmanager.impl.persistence.SnapshotDto;
import org.opencastproject.assetmanager.impl.query.AQueryBuilderImpl;
import org.opencastproject.assetmanager.impl.query.AbstractADeleteQuery;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.authorization.xacml.manager.util.AccessInformationUtil;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventIndexUtils;
import org.opencastproject.elasticsearch.index.rebuild.AbstractIndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildException;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildService;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.message.broker.api.assetmanager.AssetManagerItem;
import org.opencastproject.message.broker.api.update.AssetManagerUpdateHandler;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.DefaultOrganization;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.Checksum;
import org.opencastproject.util.ChecksumType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.data.functions.Functions;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Opencast Asset Manager"}, immediate=true, service={AssetManager.class, IndexProducer.class})
public class AssetManagerImpl
extends AbstractIndexProducer
implements AssetManager,
AbstractADeleteQuery.DeleteEpisodeHandler {
    private static final Logger logger = LoggerFactory.getLogger(AssetManagerImpl.class);
    private static final int PAGE_SIZE = 1000;
    public static final String WRITE_ACTION = "write";
    public static final String READ_ACTION = "read";
    public static final String SECURITY_NAMESPACE = "org.opencastproject.assetmanager.security";
    private static final String MANIFEST_DEFAULT_NAME = "manifest";
    private CopyOnWriteArrayList<AssetManagerUpdateHandler> handlers = new CopyOnWriteArrayList();
    private SecurityService securityService;
    private AuthorizationService authorizationService;
    private OrganizationDirectoryService orgDir;
    private Workspace workspace;
    private AssetStore assetStore;
    private HttpAssetProvider httpAssetProvider;
    private String systemUserName;
    private Database db;
    private DBSessionFactory dbSessionFactory;
    private EntityManagerFactory emf;
    private AclServiceFactory aclServiceFactory;
    private ElasticsearchIndex index;
    private Map<String, List<EventCatalogUIAdapter>> extendedEventCatalogUIAdapters = new HashMap<String, List<EventCatalogUIAdapter>>();
    private boolean includeAPIRoles;
    private boolean includeCARoles;
    private boolean includeUIRoles;
    public static final Set<MediaPackageElement.Type> MOVABLE_TYPES = Sets.newHashSet((Object[])new MediaPackageElement.Type[]{MediaPackageElement.Type.Attachment, MediaPackageElement.Type.Catalog, MediaPackageElement.Type.Track});
    private final HashMap<String, RemoteAssetStore> remoteStores = new LinkedHashMap<String, RemoteAssetStore>();
    private final Predicate<Role> roleFilter = role -> {
        String name = role.getName();
        return !(!this.includeAPIRoles && name.startsWith("ROLE_API_") || !this.includeCARoles && name.startsWith("ROLE_CAPTURE_AGENT_") || !this.includeUIRoles && name.startsWith("ROLE_UI_"));
    };

    @Activate
    public synchronized void activate(ComponentContext cc) {
        logger.info("Activating AssetManager.");
        this.db = new Database(this.dbSessionFactory.createSession(this.emf));
        this.systemUserName = SecurityUtil.getSystemUserName((ComponentContext)cc);
        this.includeAPIRoles = BooleanUtils.toBoolean((String)Objects.toString(cc.getProperties().get("includeAPIRoles"), null));
        this.includeCARoles = BooleanUtils.toBoolean((String)Objects.toString(cc.getProperties().get("includeCARoles"), null));
        this.includeUIRoles = BooleanUtils.toBoolean((String)Objects.toString(cc.getProperties().get("includeUIRoles"), null));
    }

    @Reference(target="(osgi.unit.name=org.opencastproject.assetmanager.impl)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setOrgDir(OrganizationDirectoryService orgDir) {
        this.orgDir = orgDir;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setAssetStore(AssetStore assetStore) {
        this.assetStore = assetStore;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeEventHandler")
    public void addEventHandler(AssetManagerUpdateHandler handler) {
        this.handlers.add(handler);
    }

    public void removeEventHandler(AssetManagerUpdateHandler handler) {
        this.handlers.remove(handler);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeRemoteAssetStore")
    public synchronized void addRemoteAssetStore(RemoteAssetStore assetStore) {
        this.remoteStores.put(assetStore.getStoreType(), assetStore);
    }

    public void removeRemoteAssetStore(RemoteAssetStore store) {
        this.remoteStores.remove(store.getStoreType());
    }

    @Reference
    public void setHttpAssetProvider(HttpAssetProvider httpAssetProvider) {
        this.httpAssetProvider = httpAssetProvider;
    }

    @Reference
    public void setAclServiceFactory(AclServiceFactory aclServiceFactory) {
        this.aclServiceFactory = aclServiceFactory;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.index = index;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(common-metadata=false)")
    public synchronized void addCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        List list = this.extendedEventCatalogUIAdapters.computeIfAbsent(catalogUIAdapter.getOrganization(), k -> new ArrayList());
        list.add(catalogUIAdapter);
    }

    public synchronized void removeCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        if (this.extendedEventCatalogUIAdapters.containsKey(catalogUIAdapter.getOrganization())) {
            this.extendedEventCatalogUIAdapters.get(catalogUIAdapter.getOrganization()).remove(catalogUIAdapter);
        }
    }

    public Optional<MediaPackage> getMediaPackage(String mediaPackageId) {
        AQueryBuilder q = this.createQuery();
        AResult r = q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mediaPackageId).and(q.version().isLatest())).run();
        if (r.getSize() == 0L) {
            return Optional.empty();
        }
        return Optional.of(((Snapshot)((ARecord)r.getRecords().stream().findFirst().get()).getSnapshot().get()).getMediaPackage());
    }

    public Optional<Asset> getAsset(Version version, String mpId, String mpElementId) {
        if (this.isAuthorized(mpId, READ_ACTION)) {
            Optional assetStream;
            Optional<AssetStore> store;
            Optional<String> storageId;
            Optional<AssetDtos.Medium> asset = this.getDatabase().getAsset(RuntimeTypes.convert(version), mpId, mpElementId);
            if (asset.isPresent() && (storageId = this.getSnapshotStorageLocation(version, mpId)).isPresent() && (store = this.getAssetStore(storageId.get())).isPresent() && (assetStream = store.get().get(StoragePath.mk((String)asset.get().getOrganizationId(), (String)mpId, (Version)version, (String)mpElementId))).isPresent()) {
                Checksum checksum = null;
                try {
                    checksum = Checksum.fromString((String)asset.get().getAssetDto().getChecksum());
                }
                catch (NoSuchAlgorithmException e) {
                    logger.warn("Invalid checksum for asset {} of media package {}", new Object[]{mpElementId, mpId, e});
                }
                AssetImpl a = new AssetImpl(AssetId.mk((Version)version, (String)mpId, (String)mpElementId), (InputStream)assetStream.get(), asset.get().getAssetDto().getMimeType(), asset.get().getAssetDto().getSize(), asset.get().getStorageId(), asset.get().getAvailability(), checksum);
                return Optional.of(a);
            }
            return Optional.empty();
        }
        return (Optional)Prelude.chuck((Throwable)new UnauthorizedException(String.format("Not allowed to read assets of snapshot %s, version=%s", mpId, version)));
    }

    public Optional<AssetStore> getAssetStore(String storeId) {
        if (this.assetStore.getStoreType().equals(storeId)) {
            return Optional.of(this.assetStore);
        }
        if (this.remoteStores.containsKey(storeId)) {
            return Optional.of((AssetStore)this.remoteStores.get(storeId));
        }
        return Optional.empty();
    }

    public AssetStore getLocalAssetStore() {
        return this.assetStore;
    }

    public List<AssetStore> getRemoteAssetStores() {
        return new ArrayList<RemoteAssetStore>(this.remoteStores.values());
    }

    public boolean snapshotExists(String mediaPackageId) {
        return this.getDatabase().snapshotExists(mediaPackageId);
    }

    public boolean snapshotExists(String mediaPackageId, String organization) {
        return this.getDatabase().snapshotExists(mediaPackageId, organization);
    }

    public Snapshot takeSnapshot(MediaPackage mp) {
        return this.takeSnapshot(null, mp);
    }

    public Snapshot takeSnapshot(String owner, MediaPackage mp) {
        boolean firstSnapshot;
        String mediaPackageId = mp.getIdentifier().toString();
        boolean bl = firstSnapshot = !this.snapshotExists(mediaPackageId);
        if (firstSnapshot) {
            this.deleteProperties(mediaPackageId);
        }
        if (firstSnapshot || this.isAuthorized(mediaPackageId, WRITE_ACTION)) {
            Snapshot snapshot = owner == null ? this.takeSnapshotInternal(mp) : this.takeSnapshotInternal(owner, mp);
            AccessControlList acl = (AccessControlList)this.authorizationService.getActiveAcl(mp).getA();
            this.deleteProperties(mediaPackageId, SECURITY_NAMESPACE);
            for (AccessControlEntry ace : acl.getEntries()) {
                this.getDatabase().saveProperty(Property.mk((PropertyId)PropertyId.mk((String)mediaPackageId, (String)SECURITY_NAMESPACE, (String)this.mkPropertyName(ace.getRole(), ace.getAction())), (Value)Value.mk((Boolean)ace.isAllow())));
            }
            this.updateEventInIndex(snapshot);
            logger.info("Trigger update handlers for snapshot {}, version {}", (Object)snapshot.getMediaPackage().getIdentifier(), (Object)snapshot.getVersion());
            this.fireEventHandlers((AssetManagerItem)this.mkTakeSnapshotMessage(snapshot));
            return snapshot;
        }
        return (Snapshot)Prelude.chuck((Throwable)new UnauthorizedException("Not allowed to take snapshot of media package " + mediaPackageId));
    }

    private Snapshot takeSnapshotInternal(MediaPackage mediaPackage) {
        Optional<Snapshot> snapshot;
        String mediaPackageId = mediaPackage.getIdentifier().toString();
        AQueryBuilder queryBuilder = this.createQuery();
        AResult result = queryBuilder.select(new Target[]{queryBuilder.snapshot()}).where(queryBuilder.mediaPackageId(mediaPackageId).and(queryBuilder.version().isLatest())).run();
        Optional record = result.getRecords().stream().findFirst();
        if (record.isPresent() && (snapshot = Optional.of((Snapshot)((ARecord)record.get()).getSnapshot().get())).isPresent()) {
            return this.takeSnapshotInternal(snapshot.get().getOwner(), mediaPackage);
        }
        return this.takeSnapshotInternal("default", mediaPackage);
    }

    private Snapshot takeSnapshotInternal(final String owner, final MediaPackage mp) {
        return (Snapshot)AssetManagerImpl.handleException(new P1Lazy<Snapshot>(){

            public Snapshot get1() {
                try {
                    Snapshot archived = AssetManagerImpl.this.addInternal(owner, MediaPackageSupport.copy((MediaPackage)mp)).toSnapshot();
                    return AssetManagerImpl.this.getHttpAssetProvider().prepareForDelivery(archived);
                }
                catch (Exception e) {
                    return (Snapshot)Prelude.chuck((Throwable)e);
                }
            }
        });
    }

    private AssetManagerItem.TakeSnapshot mkTakeSnapshotMessage(Snapshot snapshot) {
        long version;
        MediaPackage mp = snapshot.getMediaPackage();
        try {
            version = Long.parseLong(snapshot.getVersion().toString());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("The current implementation of the index requires versions being of type 'long'.");
        }
        return AssetManagerItem.add((Workspace)this.workspace, (MediaPackage)mp, (AccessControlList)((AccessControlList)this.authorizationService.getActiveAcl(mp).getA()), (long)version, (Date)snapshot.getArchivalDate());
    }

    private void updateEventInIndex(Snapshot snapshot) {
        MediaPackage mp = snapshot.getMediaPackage();
        String eventId = mp.getIdentifier().toString();
        String organization = this.securityService.getOrganization().getId();
        User user = this.securityService.getUser();
        logger.debug("Updating event {} in the {} index.", (Object)eventId, (Object)this.index.getIndexName());
        Function<Optional, Optional> updateFunction = eventOpt -> {
            Event event = eventOpt.orElse(new Event(eventId, organization));
            AccessControlList acl = (AccessControlList)this.authorizationService.getActiveAcl(mp).getA();
            List acls = this.aclServiceFactory.serviceFor(this.securityService.getOrganization()).getAcls();
            for (ManagedAcl managedAcl : AccessInformationUtil.matchAcls((List)acls, (AccessControlList)acl)) {
                event.setManagedAcl(managedAcl.getName());
            }
            event.setAccessPolicy(AccessControlParser.toJsonSilent((AccessControlList)acl));
            event.setArchiveVersion(Long.valueOf(Long.parseLong(snapshot.getVersion().toString())));
            if (StringUtils.isBlank((CharSequence)event.getCreator())) {
                event.setCreator(this.securityService.getUser().getName());
            }
            EventIndexUtils.updateEvent((Event)event, (MediaPackage)mp);
            for (Catalog catalog : mp.getCatalogs(MediaPackageElements.EPISODE)) {
                try (InputStream in = this.workspace.read(catalog.getURI());){
                    EventIndexUtils.updateEvent((Event)event, (DublinCore)DublinCores.read((InputStream)in));
                }
                catch (IOException | NotFoundException e) {
                    throw new IllegalStateException(String.format("Unable to load common dublin core catalog for event '%s'", mp.getIdentifier()), e);
                }
            }
            event.resetExtendedMetadata();
            for (EventCatalogUIAdapter extendedCatalogUIAdapter : this.extendedEventCatalogUIAdapters.getOrDefault(organization, Collections.emptyList())) {
                for (Catalog catalog : mp.getCatalogs(extendedCatalogUIAdapter.getFlavor())) {
                    try (InputStream in = this.workspace.read(catalog.getURI());){
                        EventIndexUtils.updateEventExtendedMetadata((Event)event, (DublinCoreCatalog)DublinCores.read((InputStream)in), (MediaPackageElementFlavor)extendedCatalogUIAdapter.getFlavor());
                    }
                    catch (IOException | NotFoundException e) {
                        throw new IllegalStateException(String.format("Unable to load extended dublin core catalog '%s' for event '%s'", catalog.getFlavor(), mp.getIdentifier()), e);
                    }
                }
            }
            try {
                EventIndexUtils.updateSeriesName((Event)event, (String)organization, (User)user, (ElasticsearchIndex)this.index);
            }
            catch (SearchIndexException e) {
                logger.error("Error updating the series name of the event {} in the {} index.", new Object[]{eventId, this.index.getIndexName(), e});
            }
            return Optional.of(event);
        };
        try {
            this.index.addOrUpdateEvent(eventId, updateFunction, organization, user);
            logger.debug("Event {} updated in the {} index.", (Object)eventId, (Object)this.index.getIndexName());
        }
        catch (SearchIndexException e) {
            logger.error("Error updating the event {} in the {} index.", (Object)eventId, (Object)e);
        }
    }

    private void removeArchivedVersionFromIndex(String eventId) {
        String orgId = this.securityService.getOrganization().getId();
        User user = this.securityService.getUser();
        logger.debug("Received AssetManager delete episode message {}", (Object)eventId);
        Function<Optional, Optional> updateFunction = eventOpt -> {
            if (eventOpt.isEmpty()) {
                logger.warn("Event {} not found for deletion", (Object)eventId);
                return Optional.empty();
            }
            Event event = (Event)eventOpt.get();
            event.setArchiveVersion(null);
            return Optional.of(event);
        };
        try {
            this.index.addOrUpdateEvent(eventId, updateFunction, orgId, user);
            logger.debug("Event {} removed from the {} index", (Object)eventId, (Object)this.index.getIndexName());
        }
        catch (SearchIndexException e) {
            logger.error("Error deleting the event {} from the {} index.", (Object)eventId, (Object)e);
        }
    }

    public RichAResult getSnapshotsById(String mpId) {
        RequireUtil.requireNotBlank((String)mpId, (String)"mpId");
        AQueryBuilder q = this.createQuery();
        ASelectQuery query = this.baseQuery(q, mpId);
        return Enrichments.enrich((AResult)query.run());
    }

    public RichAResult getSnapshotsByIdOrderedByVersion(String mpId, boolean asc) {
        RequireUtil.requireNotBlank((String)mpId, (String)"mpId");
        AQueryBuilder q = this.createQuery();
        ASelectQuery query = this.baseQuery(q, mpId);
        query = asc ? query.orderBy(q.version().asc()) : query.orderBy(q.version().desc());
        return Enrichments.enrich((AResult)query.run());
    }

    public RichAResult getSnapshotsByIdAndVersion(String mpId, Version version) {
        RequireUtil.requireNotBlank((String)mpId, (String)"mpId");
        RequireUtil.notNull((Object)version, (String)"version");
        AQueryBuilder q = this.createQuery();
        ASelectQuery query = this.baseQuery(q, version, mpId);
        return Enrichments.enrich((AResult)query.run());
    }

    public RichAResult getSnapshotsByDate(Date start, Date end) {
        RequireUtil.notNull((Object)start, (String)"start");
        RequireUtil.notNull((Object)end, (String)"end");
        AQueryBuilder q = this.createQuery();
        ASelectQuery query = this.baseQuery(q).where(q.archived().ge((Object)start)).where(q.archived().le((Object)end));
        return Enrichments.enrich((AResult)query.run());
    }

    public RichAResult getSnapshotsByDateOrderedById(Date start, Date end) {
        RequireUtil.notNull((Object)start, (String)"start");
        RequireUtil.notNull((Object)end, (String)"end");
        AQueryBuilder q = this.createQuery();
        ASelectQuery query = this.baseQuery(q).where(q.archived().ge((Object)start)).where(q.archived().le((Object)end));
        return Enrichments.enrich((AResult)query.orderBy(q.mediapackageId().asc()).run());
    }

    public RichAResult getSnapshotsByIdAndDate(String mpId, Date start, Date end) {
        RequireUtil.requireNotBlank((String)mpId, (String)"mpId");
        RequireUtil.notNull((Object)start, (String)"start");
        RequireUtil.notNull((Object)end, (String)"end");
        AQueryBuilder q = this.createQuery();
        ASelectQuery query = this.baseQuery(q, mpId).where(q.archived().ge((Object)start)).where(q.archived().le((Object)end));
        return Enrichments.enrich((AResult)query.run());
    }

    public RichAResult getSnapshotsByIdAndDateOrderedByVersion(String mpId, Date start, Date end, boolean asc) {
        RequireUtil.requireNotBlank((String)mpId, (String)"mpId");
        RequireUtil.notNull((Object)start, (String)"start");
        RequireUtil.notNull((Object)end, (String)"end");
        AQueryBuilder q = this.createQuery();
        ASelectQuery query = this.baseQuery(q, mpId).where(q.archived().ge((Object)start)).where(q.archived().le((Object)end));
        query = asc ? query.orderBy(q.version().asc()) : query.orderBy(q.version().desc());
        return Enrichments.enrich((AResult)query.run());
    }

    public void moveSnapshotsById(String mpId, String targetStore) throws NotFoundException {
        RichAResult results = this.getSnapshotsById(mpId);
        if (results.getRecords().isEmpty()) {
            throw new NotFoundException("Mediapackage " + mpId + " not found!");
        }
        this.processOperations(results, targetStore);
    }

    public void moveSnapshotsByIdAndVersion(String mpId, Version version, String targetStore) throws NotFoundException {
        RichAResult results = this.getSnapshotsByIdAndVersion(mpId, version);
        if (results.getRecords().isEmpty()) {
            throw new NotFoundException("Mediapackage " + mpId + "@" + version.toString() + " not found!");
        }
        this.processOperations(results, targetStore);
    }

    public void moveSnapshotsByDate(Date start, Date end, String targetStore) throws NotFoundException {
        AQueryBuilder q = this.createQuery();
        ASelectQuery query = this.baseQuery(q).where(q.storage(targetStore).not()).where(q.archived().ge((Object)start)).where(q.archived().le((Object)end));
        RichAResult results = Enrichments.enrich((AResult)query.run());
        if (results.getRecords().isEmpty()) {
            throw new NotFoundException("No media packages found between " + start + " and " + end);
        }
        this.processOperations(results, targetStore);
    }

    public void moveSnapshotsByIdAndDate(String mpId, Date start, Date end, String targetStore) throws NotFoundException {
        RichAResult results = this.getSnapshotsByIdAndDate(mpId, start, end);
        if (results.getRecords().isEmpty()) {
            throw new NotFoundException("No media package with id " + mpId + " found between " + start + " and " + end);
        }
        this.processOperations(results, targetStore);
    }

    public void moveSnapshotToStore(Version version, String mpId, String storeId) throws NotFoundException {
        AQueryBuilder q = this.createQuery();
        RichAResult results = Enrichments.enrich((AResult)this.baseQuery(q, version, mpId).run());
        if (results.getRecords().isEmpty()) {
            throw new NotFoundException("Mediapackage " + mpId + "@" + version.toString() + " not found!");
        }
        this.processOperations(results, storeId);
    }

    private void processOperations(RichAResult results, String targetStoreId) {
        results.getRecords().forEach(record -> {
            Snapshot s = (Snapshot)record.getSnapshot().get();
            Optional<String> currentStoreId = this.getSnapshotStorageLocation(s);
            if (currentStoreId.isEmpty()) {
                logger.warn("IsNone store ID");
                return;
            }
            if (currentStoreId.get().equals(targetStoreId)) {
                return;
            }
            Optional<AssetStore> optCurrentStore = this.getAssetStore(currentStoreId.get());
            Optional<AssetStore> optTargetStore = this.getAssetStore(targetStoreId);
            if (optCurrentStore.isEmpty()) {
                logger.error("Unknown current store: " + currentStoreId.get());
                return;
            }
            AssetStore currentStore = optCurrentStore.get();
            if (optTargetStore.isEmpty()) {
                logger.error("Unknown target store: " + targetStoreId);
                return;
            }
            AssetStore targetStore = optTargetStore.get();
            String localAssetStoreType = this.getLocalAssetStore().getStoreType();
            if (localAssetStoreType.equals(currentStoreId.get()) || localAssetStoreType.equals(targetStoreId)) {
                logger.debug("Moving {} from {} to {}", new Object[]{s, currentStoreId, targetStoreId});
                try {
                    this.copyAssetsToStore(s, targetStore);
                    this.copyManifest(s, targetStore);
                }
                catch (Exception e) {
                    Functions.chuck((Throwable)e);
                }
                this.getDatabase().setStorageLocation(s, targetStoreId);
                currentStore.delete(DeletionSelector.delete((String)s.getOrganizationId(), (String)s.getMediaPackage().getIdentifier().toString(), (Version)s.getVersion()));
            } else {
                String intermediateStore = this.getLocalAssetStore().getStoreType();
                logger.debug("Moving {} from {} to {}, then to {}", new Object[]{s, currentStoreId, intermediateStore, targetStoreId});
                Version version = s.getVersion();
                String mpId = s.getMediaPackage().getIdentifier().toString();
                try {
                    this.moveSnapshotToStore(version, mpId, intermediateStore);
                    this.moveSnapshotToStore(version, mpId, targetStoreId);
                }
                catch (NotFoundException e) {
                    Functions.chuck((Throwable)e);
                }
            }
        });
    }

    public Optional<String> getSnapshotStorageLocation(Version version, String mpId) {
        RichAResult result = this.getSnapshotsByIdAndVersion(mpId, version);
        Iterator iterator = result.getSnapshots().iterator();
        if (iterator.hasNext()) {
            Snapshot snapshot = (Snapshot)iterator.next();
            return Optional.of(snapshot.getStorageId());
        }
        logger.error("Mediapackage " + mpId + "@" + version + " not found!");
        return Optional.empty();
    }

    public Optional<String> getSnapshotStorageLocation(Snapshot snap) {
        return this.getSnapshotStorageLocation(snap.getVersion(), snap.getMediaPackage().getIdentifier().toString());
    }

    public boolean setProperty(Property property) {
        String mpId = property.getId().getMediaPackageId();
        if (this.isAuthorized(mpId, WRITE_ACTION)) {
            return this.getDatabase().saveProperty(property);
        }
        return (Boolean)Prelude.chuck((Throwable)new UnauthorizedException("Not allowed to set property on episode " + mpId));
    }

    public List<Property> selectProperties(String mediaPackageId, String namespace) {
        if (this.isAuthorized(mediaPackageId, READ_ACTION)) {
            return this.getDatabase().selectProperties(mediaPackageId, namespace);
        }
        return (List)Prelude.chuck((Throwable)new UnauthorizedException(String.format("Not allowed to read properties of event %s", mediaPackageId)));
    }

    public int deleteProperties(String mediaPackageId) {
        return this.getDatabase().deleteProperties(mediaPackageId);
    }

    public int deleteProperties(String mediaPackageId, String namespace) {
        return this.getDatabase().deleteProperties(mediaPackageId, namespace);
    }

    public AQueryBuilder createQuery() {
        return new AQueryBuilderDecorator(this.createQueryWithoutSecurityCheck()){

            @Override
            public ASelectQuery select(Target ... target) {
                switch (AssetManagerImpl.this.isAdmin()) {
                    case GLOBAL: {
                        return super.select(target);
                    }
                    case ORGANIZATION: {
                        return super.select(target).where(AssetManagerImpl.this.restrictToUsersOrganization());
                    }
                }
                return super.select(target).where(AssetManagerImpl.this.mkAuthPredicate(AssetManagerImpl.READ_ACTION));
            }

            @Override
            public ADeleteQuery delete(String owner, Target target) {
                switch (AssetManagerImpl.this.isAdmin()) {
                    case GLOBAL: {
                        return super.delete(owner, target);
                    }
                    case ORGANIZATION: {
                        return super.delete(owner, target).where(AssetManagerImpl.this.restrictToUsersOrganization());
                    }
                }
                return super.delete(owner, target).where(AssetManagerImpl.this.mkAuthPredicate(AssetManagerImpl.WRITE_ACTION));
            }
        };
    }

    private AQueryBuilder createQueryWithoutSecurityCheck() {
        return new AQueryBuilderDecorator(new AQueryBuilderImpl(this)){

            @Override
            public ADeleteQuery delete(String owner, Target target) {
                return new ADeleteQueryWithMessaging(super.delete(owner, target));
            }
        };
    }

    public Optional<Version> toVersion(String version) {
        try {
            return Optional.of(VersionImpl.mk(Long.parseLong(version)));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public long countEvents(String organization) {
        return this.getDatabase().countEvents(organization);
    }

    @Override
    public void handleDeletedEpisode(String mpId) {
        logger.info("Firing event handlers for deleting event {}", (Object)mpId);
        this.fireEventHandlers(AssetManagerItem.deleteEpisode((String)mpId, (Date)new Date()));
        this.removeArchivedVersionFromIndex(mpId);
    }

    public IndexRebuildService.Service getService() {
        return IndexRebuildService.Service.AssetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repopulate() throws IndexRebuildException {
        Organization originalOrg = this.securityService.getOrganization();
        User originalUser = originalOrg != null ? this.securityService.getUser() : null;
        try {
            DefaultOrganization defaultOrg = new DefaultOrganization();
            User defaultSystemUser = SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)defaultOrg);
            this.securityService.setOrganization((Organization)defaultOrg);
            this.securityService.setUser(defaultSystemUser);
            int offset = 0;
            int total = (int)this.countEvents(null);
            AQueryBuilder q = this.createQuery();
            int current = 0;
            this.logIndexRebuildBegin(logger, total, "snapshot(s)");
            ArrayList<Event> updatedEventRange = new ArrayList<Event>();
            do {
                RichAResult r = Enrichments.enrich((AResult)q.select(new Target[]{q.snapshot()}).where(q.version().isLatest()).orderBy(q.mediapackageId().desc()).page(offset, 1000).run());
                offset += 1000;
                int n = 20;
                Map<String, List<Snapshot>> byOrg = r.getSnapshots().stream().collect(Collectors.groupingBy(Snapshot::getOrganizationId));
                for (String orgId : byOrg.keySet()) {
                    try {
                        Organization snapshotOrg = this.orgDir.getOrganization(orgId);
                        User snapshotSystemUser = SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)snapshotOrg);
                        this.securityService.setOrganization(snapshotOrg);
                        this.securityService.setUser(snapshotSystemUser);
                        for (Snapshot snapshot : byOrg.get(orgId)) {
                            try {
                                Optional<Event> updatedEventData = this.index.getEvent(snapshot.getMediaPackage().getIdentifier().toString(), orgId, snapshotSystemUser);
                                updatedEventData = this.getEventUpdateFunction(snapshot, orgId, snapshotSystemUser).apply(updatedEventData);
                                updatedEventRange.add(updatedEventData.get());
                                if (updatedEventRange.size() < n && ++current < total) continue;
                                this.index.bulkEventUpdate(updatedEventRange);
                                this.logIndexRebuildProgress(logger, total, current, n);
                                updatedEventRange.clear();
                            }
                            catch (Throwable t) {
                                this.logSkippingElement(logger, "event", snapshot.getMediaPackage().getIdentifier().toString(), snapshotOrg, t);
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.logIndexRebuildError(logger, t, originalOrg);
                        throw new IndexRebuildException(this.getService(), originalOrg, t);
                    }
                    finally {
                        this.securityService.setOrganization((Organization)defaultOrg);
                        this.securityService.setUser(defaultSystemUser);
                    }
                }
            } while (offset < total);
        }
        finally {
            this.securityService.setOrganization(originalOrg);
            this.securityService.setUser(originalUser);
        }
    }

    public void setAvailability(Version version, String mpId, Availability availability) {
        if (this.isAuthorized(mpId, WRITE_ACTION)) {
            this.getDatabase().setAvailability(RuntimeTypes.convert(version), mpId, availability);
        } else {
            Prelude.chuck((Throwable)new UnauthorizedException("Not allowed to set availability of episode " + mpId));
        }
    }

    public void setDatabase(Database database) {
        this.db = database;
    }

    public Database getDatabase() {
        return this.db;
    }

    public HttpAssetProvider getHttpAssetProvider() {
        return this.httpAssetProvider;
    }

    private org.opencastproject.assetmanager.api.query.Predicate mkAuthPredicate(String action) {
        AQueryBuilder q = this.createQueryWithoutSecurityCheck();
        return this.securityService.getUser().getRoles().stream().filter(this.roleFilter).map(role -> q.property((Value.ValueType)Value.BOOLEAN, SECURITY_NAMESPACE, this.mkPropertyName(role.getName(), action)).eq((Object)true)).reduce(org.opencastproject.assetmanager.api.query.Predicate::or).orElseGet(() -> q.always().not()).and(this.restrictToUsersOrganization());
    }

    private org.opencastproject.assetmanager.api.query.Predicate restrictToUsersOrganization() {
        return this.createQueryWithoutSecurityCheck().organizationId().eq((Object)this.securityService.getUser().getOrganization().getId());
    }

    private boolean isAuthorized(String mediaPackageId, String action) {
        switch (this.isAdmin()) {
            case GLOBAL: {
                logger.debug("Access granted since user is global admin");
                return true;
            }
            case ORGANIZATION: {
                logger.debug("User is organization admin. Checking organization. Checking organization ID of asset.");
                return this.snapshotExists(mediaPackageId, this.securityService.getOrganization().getId());
            }
        }
        logger.debug("Non admin user. Checking organization.");
        String org = this.securityService.getOrganization().getId();
        if (!this.snapshotExists(mediaPackageId, org)) {
            return false;
        }
        logger.debug("Non admin user. Checking ACL rules.");
        List roles = this.securityService.getUser().getRoles().parallelStream().filter(this.roleFilter).map(role -> this.mkPropertyName(role.getName(), action)).collect(Collectors.toList());
        return this.getDatabase().selectProperties(mediaPackageId, SECURITY_NAMESPACE).parallelStream().map(p -> p.getId().getName()).filter(p -> p.endsWith(action)).anyMatch(p -> roles.stream().anyMatch(r -> r.equals(p)));
    }

    private AdminRole isAdmin() {
        User user = this.securityService.getUser();
        if (user.hasRole("ROLE_ADMIN")) {
            return AdminRole.GLOBAL;
        }
        if (user.hasRole(this.securityService.getOrganization().getAdminRole()) || user.hasRole("ROLE_CAPTURE_AGENT")) {
            return AdminRole.ORGANIZATION;
        }
        return AdminRole.NONE;
    }

    private String mkPropertyName(String role, String action) {
        return role + " | " + action;
    }

    private ASelectQuery baseQuery(AQueryBuilder q) {
        RequireUtil.notNull((Object)q, (String)"q");
        return q.select(new Target[]{q.snapshot()});
    }

    private ASelectQuery baseQuery(AQueryBuilder q, String mpId) {
        RequireUtil.notNull((Object)q, (String)"q");
        ASelectQuery query = this.baseQuery(q);
        if (StringUtils.isNotEmpty((CharSequence)mpId)) {
            return query.where(q.mediaPackageId(mpId));
        }
        return query;
    }

    private ASelectQuery baseQuery(AQueryBuilder q, Version version, String mpId) {
        RequireUtil.notNull((Object)q, (String)"q");
        RequireUtil.requireNotBlank((String)mpId, (String)"mpId");
        ASelectQuery query = this.baseQuery(q, mpId);
        if (null != version) {
            return query.where(q.version().eq((Object)version));
        }
        return query;
    }

    private void copyAssetsToStore(Snapshot snap, AssetStore store) {
        String mpId = snap.getMediaPackage().getIdentifier().toString();
        String orgId = snap.getOrganizationId();
        Version version = snap.getVersion();
        String prettyMpId = mpId + "@v" + version;
        logger.debug("Moving assets for snapshot {} to store {}", (Object)prettyMpId, (Object)store.getStoreType());
        for (MediaPackageElement e : snap.getMediaPackage().getElements()) {
            if (!MOVABLE_TYPES.contains(e.getElementType())) {
                logger.debug("Skipping {} because type is {}", (Object)e.getIdentifier(), (Object)e.getElementType());
                continue;
            }
            logger.debug("Moving {} to store {}", (Object)e.getIdentifier(), (Object)store.getStoreType());
            StoragePath storagePath = StoragePath.mk((String)orgId, (String)mpId, (Version)version, (String)e.getIdentifier());
            if (store.contains(storagePath)) {
                logger.debug("Element {} (version {}) is already in store {} so skipping it", new Object[]{e.getIdentifier(), version, store.getStoreType()});
                continue;
            }
            Optional<StoragePath> existingAssetOpt = this.getDatabase().findAssetByChecksumAndStoreAndOrg(e.getChecksum().toString(), store.getStoreType(), orgId).map(dto -> StoragePath.mk((String)dto.getOrganizationId(), (String)dto.getMediaPackageId(), (Version)dto.getVersion(), (String)dto.getAssetDto().getMediaPackageElementId()));
            if (existingAssetOpt.isPresent()) {
                StoragePath existingAsset = existingAssetOpt.get();
                logger.debug("Content of asset {} with checksum {} already exists in {}", new Object[]{existingAsset.getMediaPackageElementId(), e.getChecksum(), store.getStoreType()});
                if (!store.copy(existingAsset, storagePath)) {
                    throw new AssetManagerException(String.format("An asset with checksum %s has already been archived but trying to copy or link asset %s to it failed", e.getChecksum(), existingAsset));
                }
            } else {
                Optional size = e.getSize() > 0L ? Optional.of(e.getSize()) : Optional.empty();
                store.put(storagePath, Source.mk((URI)e.getURI(), size, Optional.ofNullable(e.getMimeType())));
            }
            this.getDatabase().setAssetStorageLocation(VersionImpl.mk(version), mpId, e.getIdentifier(), store.getStoreType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyManifest(Snapshot snap, AssetStore targetStore) throws IOException, NotFoundException {
        String mpId = snap.getMediaPackage().getIdentifier().toString();
        String orgId = snap.getOrganizationId();
        Version version = snap.getVersion();
        AssetStore currentStore = this.getAssetStore(snap.getStorageId()).get();
        Optional<String> manifestOpt = this.findManifestBaseName(snap, MANIFEST_DEFAULT_NAME, currentStore);
        if (manifestOpt.isEmpty()) {
            return;
        }
        String manifestBaseName = manifestOpt.get();
        StoragePath pathToManifest = new StoragePath(orgId, mpId, version, manifestBaseName);
        if (!targetStore.contains(pathToManifest)) {
            InputStream inputStream = null;
            String manifestFileName = null;
            try {
                Optional inputStreamOpt = currentStore.get(pathToManifest);
                if (inputStreamOpt.isEmpty()) {
                    throw new NotFoundException(String.format("Unexpected error. Manifest %s not found in current asset store", manifestBaseName));
                }
                inputStream = (InputStream)inputStreamOpt.get();
                manifestFileName = UUID.randomUUID() + ".xml";
                URI manifestTmpUri = this.workspace.putInCollection("archive", manifestFileName, inputStream);
                targetStore.put(pathToManifest, Source.mk((URI)manifestTmpUri, Optional.empty(), Optional.of(MimeTypes.XML)));
            }
            catch (Throwable throwable) {
                block13: {
                    IOUtils.closeQuietly(inputStream);
                    try {
                        this.workspace.deleteFromCollection("archive", manifestFileName);
                    }
                    catch (NotFoundException notFoundException) {
                    }
                    catch (IOException e) {
                        if (!e.getMessage().contains(manifestFileName)) break block13;
                        logger.warn("The manifest file {} didn't get deleted from the archive collection: {}", (Object)manifestBaseName, (Object)e);
                    }
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            try {
                this.workspace.deleteFromCollection("archive", manifestFileName);
            }
            catch (NotFoundException manifestTmpUri) {
            }
            catch (IOException e) {
                if (e.getMessage().contains(manifestFileName)) {
                    logger.warn("The manifest file {} didn't get deleted from the archive collection: {}", (Object)manifestBaseName, (Object)e);
                }
            }
        }
    }

    Optional<String> findManifestBaseName(Snapshot snap, String manifestName, AssetStore store) {
        StoragePath path = new StoragePath(snap.getOrganizationId(), snap.getMediaPackage().getIdentifier().toString(), snap.getVersion(), manifestName);
        if (!store.contains(path)) {
            if (MANIFEST_DEFAULT_NAME.equals(manifestName)) {
                return Optional.empty();
            }
            return Optional.of(manifestName.substring(0, manifestName.length() - 1));
        }
        return this.findManifestBaseName(snap, manifestName + "_", store);
    }

    void calcChecksumsForMediaPackageElements(PartialMediaPackage pmp) {
        Fx<MediaPackageElement> addChecksum = new Fx<MediaPackageElement>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply(MediaPackageElement mpe) {
                File file = null;
                try {
                    logger.trace("Calculate checksum for {}", (Object)mpe.getURI());
                    file = AssetManagerImpl.this.workspace.get(mpe.getURI(), true);
                    mpe.setChecksum(Checksum.create((ChecksumType)ChecksumType.DEFAULT_TYPE, (File)file));
                    if (file == null) return;
                }
                catch (IOException | NotFoundException e) {
                    try {
                        throw new AssetManagerException(String.format("Cannot calculate checksum for media package element %s", mpe.getURI()), e);
                    }
                    catch (Throwable throwable) {
                        if (file == null) throw throwable;
                        FileUtils.deleteQuietly(file);
                        throw throwable;
                    }
                }
                FileUtils.deleteQuietly((File)file);
                return;
            }
        };
        pmp.getElements().filter(MediaPackageSupport.Filters.hasNoChecksum.toFn()).each((Fx)addChecksum).run();
    }

    private SnapshotDto addInternal(String owner, MediaPackage mp) throws Exception {
        SnapshotDto snapshotDto;
        Date now = new Date();
        final String mpId = mp.getIdentifier().toString();
        final VersionImpl version = this.getDatabase().claimVersion(mpId);
        logger.info("Creating new version {} of media package {}", (Object)version, (Object)mp);
        PartialMediaPackage pmp = AssetManagerImpl.assetsOnly(mp);
        this.calcChecksumsForMediaPackageElements(pmp);
        this.storeAssets(pmp, version);
        try {
            Fn<MediaPackageElement, URI> uriCreator = new Fn<MediaPackageElement, URI>(){

                public URI apply(MediaPackageElement mpe) {
                    try {
                        String fileName = (String)MediaPackageSupport.getFileName((MediaPackageElement)mpe).getOr((Object)"unknown");
                        return new URI("urn", "matterhorn:" + mpId + ":" + version + ":" + mpe.getIdentifier() + ":" + fileName, null);
                    }
                    catch (URISyntaxException e) {
                        throw new AssetManagerException((Throwable)e);
                    }
                }
            };
            for (MediaPackageElement mpe : pmp.getElements()) {
                mpe.setURI((URI)uriCreator.apply((Object)mpe));
            }
            String currentOrgId = this.securityService.getOrganization().getId();
            snapshotDto = this.getDatabase().saveSnapshot(currentOrgId, pmp, now, version, Availability.ONLINE, this.getLocalAssetStore().getStoreType(), owner);
        }
        catch (AssetManagerException e) {
            logger.error("Could not take snapshot {}: {}", (Object)mpId, (Object)e);
            throw new AssetManagerException((Throwable)e);
        }
        this.storeManifest(pmp, version);
        return snapshotDto;
    }

    private void storeAssets(PartialMediaPackage pmp, Version version) {
        String mpId = pmp.getMediaPackage().getIdentifier().toString();
        String orgId = this.securityService.getOrganization().getId();
        for (MediaPackageElement e : pmp.getElements()) {
            logger.debug("Archiving {} {} {}", new Object[]{e.getFlavor(), e.getMimeType(), e.getURI()});
            StoragePath storagePath = StoragePath.mk((String)orgId, (String)mpId, (Version)version, (String)e.getIdentifier());
            Optional<StoragePath> existingAssetOpt = this.getDatabase().findAssetByChecksumAndStoreAndOrg(e.getChecksum().toString(), this.getLocalAssetStore().getStoreType(), orgId).map(dto -> StoragePath.mk((String)dto.getOrganizationId(), (String)dto.getMediaPackageId(), (Version)dto.getVersion(), (String)dto.getAssetDto().getMediaPackageElementId()));
            if (existingAssetOpt.isPresent()) {
                StoragePath existingAsset = existingAssetOpt.get();
                logger.debug("Content of asset {} with checksum {} has been archived before", (Object)existingAsset.getMediaPackageElementId(), (Object)e.getChecksum());
                if (this.getLocalAssetStore().copy(existingAsset, storagePath)) continue;
                throw new AssetManagerException(String.format("An asset with checksum %s has already been archived but trying to copy or link asset %s to it failed", e.getChecksum(), existingAsset));
            }
            Optional size = e.getSize() > 0L ? Optional.of(e.getSize()) : Optional.empty();
            this.getLocalAssetStore().put(storagePath, Source.mk((URI)e.getURI(), size, Optional.ofNullable(e.getMimeType())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeManifest(PartialMediaPackage pmp, Version version) throws Exception {
        String mpId = pmp.getMediaPackage().getIdentifier().toString();
        String orgId = this.securityService.getOrganization().getId();
        logger.debug("Archiving manifest of media package {} version {}", (Object)mpId, (Object)version);
        String manifestFileName = String.format("manifest_%s_%s.xml", pmp.getMediaPackage().getIdentifier(), version);
        URI manifestTmpUri = this.workspace.putInCollection("archive", manifestFileName, IOUtils.toInputStream((String)MediaPackageParser.getAsXml((MediaPackage)pmp.getMediaPackage()), (String)"UTF-8"));
        try {
            this.getLocalAssetStore().put(StoragePath.mk((String)orgId, (String)mpId, (Version)version, (String)this.manifestAssetId(pmp, MANIFEST_DEFAULT_NAME)), Source.mk((URI)manifestTmpUri, Optional.empty(), Optional.of(MimeTypes.XML)));
        }
        finally {
            this.workspace.deleteFromCollection("archive", manifestFileName);
        }
    }

    private String manifestAssetId(PartialMediaPackage pmp, String seedId) {
        if (Stream.$(pmp.getElements()).map(MediaPackageSupport.getMediaPackageElementId.toFn()).exists((Fn)Booleans.eq((Object)seedId))) {
            return this.manifestAssetId(pmp, seedId + "_");
        }
        return seedId;
    }

    static <A> A handleException(P1<A> p) throws AssetManagerException {
        try {
            return (A)p.get1();
        }
        catch (Exception e) {
            logger.error("An error occurred", (Throwable)e);
            throw AssetManagerImpl.unwrapExceptionUntil(AssetManagerException.class, e).orElse(new AssetManagerException((Throwable)e));
        }
    }

    static <A extends Throwable> Optional<A> unwrapExceptionUntil(Class<A> type, Throwable e) {
        if (e == null) {
            return Optional.empty();
        }
        if (type.isAssignableFrom(e.getClass())) {
            return Optional.of(e);
        }
        return AssetManagerImpl.unwrapExceptionUntil(type, e.getCause());
    }

    static PartialMediaPackage assetsOnly(MediaPackage mp) {
        Pred isAsset = Pred.mk((Fn)MediaPackageSupport.Filters.isNotPublication.toFn());
        return PartialMediaPackage.mk(mp, (Pred<MediaPackageElement>)isAsset);
    }

    public static Optional<String> getFileNameFromUrn(MediaPackageElement mpe) {
        Fn<URI, String> toString = new Fn<URI, String>(){

            public String apply(URI uri) {
                return uri.toString();
            }
        };
        Optional<URI> uri = Optional.ofNullable(mpe.getURI());
        if (uri.isPresent() && "urn".equals(uri.get().getScheme())) {
            String[] tmp = uri.get().toString().split(":");
            if (tmp.length < 1) {
                return Optional.empty();
            }
            return Optional.of(tmp[tmp.length - 1]);
        }
        return Optional.empty();
    }

    public static Snapshot rewriteUris(Snapshot snapshot, Fn<MediaPackageElement, URI> uriCreator) {
        MediaPackage mpCopy = MediaPackageSupport.copy((MediaPackage)snapshot.getMediaPackage());
        for (MediaPackageElement mpe : AssetManagerImpl.assetsOnly(mpCopy).getElements()) {
            mpe.setURI((URI)uriCreator.apply((Object)mpe));
        }
        return new SnapshotImpl(snapshot.getVersion(), snapshot.getOrganizationId(), snapshot.getArchivalDate(), snapshot.getAvailability(), snapshot.getStorageId(), snapshot.getOwner(), mpCopy);
    }

    public void fireEventHandlers(AssetManagerItem item) {
        while (this.handlers.size() != 2) {
            logger.warn("Expecting 2 handlers, but {} are registered.  Waiting 10s then retrying...", (Object)this.handlers.size());
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (AssetManagerUpdateHandler handler : this.handlers) {
            handler.execute(item);
        }
    }

    private Function<Optional<Event>, Optional<Event>> getEventUpdateFunction(Snapshot snapshot, String orgId, User user) {
        return eventOpt -> {
            MediaPackage mp = snapshot.getMediaPackage();
            String eventId = mp.getIdentifier().toString();
            Event event = eventOpt.orElse(new Event(eventId, orgId));
            AccessControlList acl = (AccessControlList)this.authorizationService.getActiveAcl(mp).getA();
            List acls = this.aclServiceFactory.serviceFor(this.securityService.getOrganization()).getAcls();
            for (ManagedAcl managedAcl : AccessInformationUtil.matchAcls((List)acls, (AccessControlList)acl)) {
                event.setManagedAcl(managedAcl.getName());
            }
            event.setAccessPolicy(AccessControlParser.toJsonSilent((AccessControlList)acl));
            event.setArchiveVersion(Long.valueOf(Long.parseLong(snapshot.getVersion().toString())));
            if (StringUtils.isBlank((CharSequence)event.getCreator())) {
                event.setCreator(this.securityService.getUser().getName());
            }
            EventIndexUtils.updateEvent((Event)event, (MediaPackage)mp);
            for (Catalog catalog : mp.getCatalogs(MediaPackageElements.EPISODE)) {
                try (InputStream in = this.workspace.read(catalog.getURI());){
                    EventIndexUtils.updateEvent((Event)event, (DublinCore)DublinCores.read((InputStream)in));
                }
                catch (IOException | NotFoundException e) {
                    throw new IllegalStateException(String.format("Unable to load dublin core catalog for event '%s'", mp.getIdentifier()), e);
                }
            }
            try {
                EventIndexUtils.updateSeriesName((Event)event, (String)orgId, (User)user, (ElasticsearchIndex)this.index);
            }
            catch (SearchIndexException e) {
                logger.error("Error updating the series name of the event {} in the {} index.", new Object[]{eventId, this.index.getIndexName(), e});
            }
            return Optional.of(event);
        };
    }

    private final class ADeleteQueryWithMessaging
    extends ADeleteQueryDecorator {
        ADeleteQueryWithMessaging(ADeleteQuery delegate) {
            super(delegate);
        }

        @Override
        public long run() {
            return RuntimeTypes.convert(this.delegate).run(AssetManagerImpl.this);
        }

        @Override
        protected ADeleteQueryDecorator mkDecorator(ADeleteQuery delegate) {
            return new ADeleteQueryWithMessaging(delegate);
        }
    }

    static enum AdminRole {
        GLOBAL,
        ORGANIZATION,
        NONE;

    }
}

