/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.query;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.fn.ARecords;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;

public final class RichAResult
implements AResult {
    private final AResult result;

    public RichAResult(AResult result) {
        this.result = result;
    }

    public List<Property> getProperties() {
        return ARecords.getProperties(this.result.getRecords());
    }

    public int countProperties() {
        return this.getProperties().size();
    }

    public List<Snapshot> getSnapshots() {
        return this.result.getRecords().stream().map(record -> record.getSnapshot()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public int countSnapshots() {
        return this.getSnapshots().size();
    }

    public List<Version> getVersions() {
        return this.getSnapshots().stream().map(snapshot -> snapshot.getVersion()).collect(Collectors.toList());
    }

    @Override
    public Iterator<ARecord> iterator() {
        return this.result.iterator();
    }

    @Override
    public LinkedHashSet<ARecord> getRecords() {
        return this.result.getRecords();
    }

    @Override
    public long getSize() {
        return this.result.getSize();
    }

    @Override
    public String getQuery() {
        return this.result.getQuery();
    }

    @Override
    public long getTotalSize() {
        return this.result.getTotalSize();
    }

    @Override
    public long getLimit() {
        return this.result.getLimit();
    }

    @Override
    public long getOffset() {
        return this.result.getOffset();
    }

    @Override
    public long getSearchTime() {
        return this.result.getSearchTime();
    }
}

