/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.query;

import java.util.Date;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.Predicate;
import org.opencastproject.assetmanager.api.query.PropertyField;
import org.opencastproject.assetmanager.api.query.Target;

public abstract class PropertySchema {
    protected final AQueryBuilder q;
    protected final String namespace;

    public PropertySchema(AQueryBuilder q, String namespace) {
        this.q = q;
        this.namespace = namespace;
    }

    public String namespace() {
        return this.namespace;
    }

    public Predicate hasPropertiesOfNamespace() {
        return this.q.hasPropertiesOf(this.namespace);
    }

    public Target allProperties() {
        return this.q.propertiesOf(this.namespace);
    }

    protected <A> PropertyField<A> prop(Value.ValueType<A> ev, String name) {
        return this.q.property(ev, this.namespace, name);
    }

    protected PropertyField<String> stringProp(String name) {
        return this.prop(Value.STRING, name);
    }

    protected PropertyField<Long> longProp(String name) {
        return this.prop(Value.LONG, name);
    }

    protected PropertyField<Boolean> booleanProp(String name) {
        return this.prop(Value.BOOLEAN, name);
    }

    protected PropertyField<Date> dateProp(String name) {
        return this.prop(Value.DATE, name);
    }

    protected PropertyField<Version> versionProp(String name) {
        return this.prop(Value.VERSION, name);
    }
}

