/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.fn;

import java.util.Date;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.PropertyField;
import org.opencastproject.mediapackage.MediaPackage;

public final class Properties {
    private Properties() {
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, String value) {
        return Properties.setProperty(am, mpId, namespace, propertyName, Value.mk(value));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, Date value) {
        return Properties.setProperty(am, mpId, namespace, propertyName, Value.mk(value));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, Long value) {
        return Properties.setProperty(am, mpId, namespace, propertyName, Value.mk(value));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, boolean value) {
        return Properties.setProperty(am, mpId, namespace, propertyName, Value.mk(value));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, Value value) {
        return am.setProperty(Property.mk(PropertyId.mk(mpId, namespace, propertyName), value));
    }

    public static long removeProperties(AssetManager am, String owner, String orgId, String mpId, String namespace) {
        AQueryBuilder q = am.createQuery();
        return q.delete(owner, q.propertiesOf(namespace)).where(q.organizationId(orgId).and(q.mediaPackageId(mpId))).run();
    }

    public static <A> Property mkProperty(PropertyField<A> f, MediaPackage mp, A value) {
        return f.mk(mp.getIdentifier().toString(), value);
    }

    public static <A> Property mkProperty(PropertyField<A> f, Snapshot e, A value) {
        return f.mk(e.getMediaPackage().getIdentifier().toString(), value);
    }

    public static Property mkProperty(String mpId, String namespace, String name, Value value) {
        return Property.mk(PropertyId.mk(mpId, namespace, name), value);
    }
}

