/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.opencastproject.assetmanager.api.Asset;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.RichAResult;
import org.opencastproject.assetmanager.api.storage.AssetStore;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;

public interface AssetManager {
    public static final String DEFAULT_OWNER = "default";

    public Optional<MediaPackage> getMediaPackage(String var1);

    public Optional<Asset> getAsset(Version var1, String var2, String var3);

    public Optional<AssetStore> getAssetStore(String var1);

    public List<AssetStore> getRemoteAssetStores();

    public AssetStore getLocalAssetStore();

    public boolean snapshotExists(String var1);

    public boolean snapshotExists(String var1, String var2);

    public RichAResult getSnapshotsById(String var1);

    public RichAResult getSnapshotsByIdOrderedByVersion(String var1, boolean var2);

    public RichAResult getSnapshotsByIdAndVersion(String var1, Version var2);

    public RichAResult getSnapshotsByDate(Date var1, Date var2);

    public RichAResult getSnapshotsByDateOrderedById(Date var1, Date var2);

    public RichAResult getSnapshotsByIdAndDate(String var1, Date var2, Date var3);

    public RichAResult getSnapshotsByIdAndDateOrderedByVersion(String var1, Date var2, Date var3, boolean var4);

    public Snapshot takeSnapshot(String var1, MediaPackage var2);

    public Snapshot takeSnapshot(MediaPackage var1);

    public void moveSnapshotToStore(Version var1, String var2, String var3) throws NotFoundException;

    public void moveSnapshotsById(String var1, String var2) throws NotFoundException;

    public void moveSnapshotsByIdAndVersion(String var1, Version var2, String var3) throws NotFoundException;

    public void moveSnapshotsByDate(Date var1, Date var2, String var3) throws NotFoundException;

    public void moveSnapshotsByIdAndDate(String var1, Date var2, Date var3, String var4) throws NotFoundException;

    public boolean setProperty(Property var1);

    public List<Property> selectProperties(String var1, String var2);

    public int deleteProperties(String var1);

    public int deleteProperties(String var1, String var2);

    public AQueryBuilder createQuery();

    public Optional<Version> toVersion(String var1);

    public long countEvents(String var1);

    public void triggerIndexUpdate(String var1) throws NotFoundException, UnauthorizedException;
}

