/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.storage;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.opencastproject.assetmanager.api.Version;

@ParametersAreNonnullByDefault
@Immutable
public final class StoragePath
implements Serializable {
    private static final long serialVersionUID = -5646543990835098350L;
    private final String mediaPackageId;
    private final String mediaPackageElementId;
    private final String organizationId;
    private final Version version;

    public StoragePath(String organizationId, String mediaPackageId, Version version, String mediaPackageElementId) {
        this.mediaPackageId = mediaPackageId;
        this.mediaPackageElementId = mediaPackageElementId;
        this.organizationId = organizationId;
        this.version = version;
    }

    public static StoragePath mk(String organizationId, String mediaPackageId, Version version, String mediaPackageElementId) {
        return new StoragePath(organizationId, mediaPackageId, version, mediaPackageElementId);
    }

    public String getMediaPackageId() {
        return this.mediaPackageId;
    }

    public String getMediaPackageElementId() {
        return this.mediaPackageElementId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof StoragePath && this.eqFields((StoragePath)that);
    }

    private boolean eqFields(StoragePath that) {
        return Objects.equals(this.mediaPackageId, that.mediaPackageId) && Objects.equals(this.mediaPackageElementId, that.mediaPackageElementId) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.mediaPackageId, this.mediaPackageElementId, this.organizationId, this.version);
    }

    public String toString() {
        return "StoragePath(orgId=" + this.organizationId + ", mpId=" + this.mediaPackageId + ", version=" + this.version + ", mpeId=" + this.mediaPackageElementId + ")";
    }
}

