/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.storage;

import java.net.URI;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.opencastproject.util.MimeType;

@ParametersAreNonnullByDefault
public final class Source {
    private final URI uri;
    private final Optional<Long> size;
    private final Optional<MimeType> mimeType;

    public Source(URI uri, Optional<Long> size, Optional<MimeType> mimeType) {
        this.uri = uri;
        this.size = size;
        this.mimeType = mimeType;
    }

    public static Source mk(URI uri) {
        return new Source(uri, Optional.empty(), Optional.empty());
    }

    public static Source mk(URI uri, Long size) {
        return new Source(uri, Optional.of(size), Optional.empty());
    }

    public static Source mk(URI uri, Long size, MimeType mimeType) {
        return new Source(uri, Optional.of(size), Optional.of(mimeType));
    }

    public static Source mk(URI uri, Optional<Long> size, Optional<MimeType> mimeType) {
        return new Source(uri, size, mimeType);
    }

    public URI getUri() {
        return this.uri;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    public Optional<MimeType> getMimeType() {
        return this.mimeType;
    }
}

