/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.storage;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.opencastproject.assetmanager.api.Version;

@ParametersAreNonnullByDefault
@Immutable
public final class DeletionSelector
implements Serializable {
    private static final long serialVersionUID = 217139112650188934L;
    private final String mediaPackageId;
    private final String organizationId;
    private final Optional<Version> version;

    public DeletionSelector(String organizationId, String mediaPackageId, Optional<Version> version) {
        this.mediaPackageId = mediaPackageId;
        this.organizationId = organizationId;
        this.version = version;
    }

    public static DeletionSelector delete(String organizationId, String mediaPackageId, Version version) {
        return new DeletionSelector(organizationId, mediaPackageId, Optional.of(version));
    }

    public static DeletionSelector deleteAll(String organizationId, String mediaPackageId) {
        return new DeletionSelector(organizationId, mediaPackageId, Optional.empty());
    }

    public String getMediaPackageId() {
        return this.mediaPackageId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Optional<Version> getVersion() {
        return this.version;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DeletionSelector && this.eqFields((DeletionSelector)that);
    }

    private boolean eqFields(DeletionSelector that) {
        return Objects.equals(this.mediaPackageId, that.mediaPackageId) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.mediaPackageId, this.organizationId, this.version);
    }

    public String toString() {
        return String.format("DeletionSelector(org=%s,mp=%s,v=%s)", this.organizationId, this.mediaPackageId, this.version);
    }
}

