/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.fn;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.query.ARecord;

public final class ARecords {
    public static String getMediaPackageId(LinkedHashSet<ARecord> records) {
        return records.stream().map(r -> r.getMediaPackageId()).findFirst().get();
    }

    public static List<Property> getProperties(LinkedHashSet<ARecord> records) {
        return records.stream().map(r -> r.getProperties()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static boolean hasProperties(ARecord record) {
        return record.getProperties().isEmpty();
    }

    public static List<Snapshot> getSnapshot(LinkedHashSet<ARecord> records) {
        return records.stream().map(r -> r.getSnapshot()).filter(s -> s.isPresent()).map(s -> (Snapshot)s.get()).collect(Collectors.toList());
    }

    private ARecords() {
    }
}

