/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.opencastproject.util.RequireUtil;

@ParametersAreNonnullByDefault
@Immutable
public final class PropertyName
implements Serializable {
    private static final long serialVersionUID = -7542245565083273994L;
    private final String namespace;
    private final String name;

    public PropertyName(String namespace, String name) {
        this.namespace = RequireUtil.notEmpty((String)namespace, (String)"namespace");
        this.name = RequireUtil.notEmpty((String)name, (String)"name");
    }

    public static PropertyName mk(String namespace, String name) {
        return new PropertyName(namespace, name);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof PropertyName && this.eqFields((PropertyName)that);
    }

    private boolean eqFields(PropertyName that) {
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
    }

    public String toString() {
        return String.format("PropertyFqn(%s, %s)", this.namespace, this.name);
    }
}

