/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.opencastproject.assetmanager.api.PropertyName;
import org.opencastproject.util.RequireUtil;

@ParametersAreNonnullByDefault
@Immutable
public final class PropertyId
implements Serializable {
    private static final long serialVersionUID = -2614578081057869958L;
    private final String mpId;
    private final String namespace;
    private final String name;

    public PropertyId(String mpId, String namespace, String name) {
        this.mpId = RequireUtil.notEmpty((String)mpId, (String)"mpId");
        this.namespace = RequireUtil.notEmpty((String)namespace, (String)"namespace");
        this.name = RequireUtil.notEmpty((String)name, (String)"name");
    }

    public static PropertyId mk(String mpId, String namespace, String propertyName) {
        return new PropertyId(mpId, namespace, propertyName);
    }

    public static PropertyId mk(String mpId, PropertyName fqn) {
        return new PropertyId(mpId, fqn.getNamespace(), fqn.getName());
    }

    public String getMediaPackageId() {
        return this.mpId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public PropertyName getFqn() {
        return PropertyName.mk(this.namespace, this.name);
    }

    public int hashCode() {
        return Objects.hash(this.mpId, this.namespace, this.name);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof PropertyId && this.eqFields((PropertyId)that);
    }

    private boolean eqFields(PropertyId that) {
        return Objects.equals(this.mpId, that.mpId) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
    }

    public String toString() {
        return String.format("PropertyId(%s, %s, %s)", this.mpId, this.namespace, this.name);
    }
}

