/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.Value;

@ParametersAreNonnullByDefault
public class Property {
    private final PropertyId id;
    private final Value value;

    public Property(PropertyId id, Value value) {
        this.id = id;
        this.value = value;
    }

    public static Property mk(PropertyId id, Value value) {
        return new Property(id, value);
    }

    public PropertyId getId() {
        return this.id;
    }

    public Value getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Property && this.eqFields((Property)that);
    }

    private boolean eqFields(Property that) {
        return Objects.equals(this.id, that.id) && Objects.equals(this.value, that.value);
    }

    public String toString() {
        return String.format("Property(%s=%s)", this.id, this.value);
    }
}

