/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.annotation.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.annotation.api.Annotation;
import org.opencastproject.annotation.api.AnnotationList;
import org.opencastproject.annotation.api.AnnotationService;
import org.opencastproject.annotation.impl.AnnotationImpl;
import org.opencastproject.annotation.impl.AnnotationListImpl;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AnnotationService.class}, property={"service.description=Annotation Service"})
public class AnnotationServiceJpaImpl
implements AnnotationService {
    public static final String PERSISTENCE_UNIT = "org.opencastproject.annotation";
    protected EntityManagerFactory emf = null;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    protected SecurityService securityService;

    @Reference(target="(osgi.unit.name=org.opencastproject.annotation)")
    void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Activate
    public void activate() {
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Deactivate
    public void deactivate() {
        this.db.close();
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public Annotation addAnnotation(Annotation a) {
        a.setUserId(this.securityService.getUser().getUsername());
        return (Annotation)this.db.execTx(Queries.namedQuery.persist((Object)a));
    }

    public boolean removeAnnotation(Annotation a) {
        try {
            this.db.execTxChecked(em -> em.remove(em.merge((Object)a)));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Annotation changeAnnotation(Annotation a) throws NotFoundException {
        long id = a.getAnnotationId();
        return (Annotation)this.db.execTx(em -> {
            Query q = em.createNamedQuery("updateAnnotation");
            q.setParameter("value", (Object)a.getValue());
            q.setParameter("annotationId", (Object)id);
            int no = q.executeUpdate();
            AnnotationImpl b = null;
            if (no == 1) {
                b = (AnnotationImpl)em.find(AnnotationImpl.class, (Object)id);
            }
            return b;
        });
    }

    public Annotation getAnnotation(long id) throws NotFoundException {
        AnnotationImpl a = (AnnotationImpl)this.db.exec(Queries.namedQuery.findById(AnnotationImpl.class, (Object)id));
        if (a == null) {
            throw new NotFoundException("Annotation '" + id + "' not found");
        }
        return a;
    }

    public AnnotationList getAnnotations(int offset, int limit) {
        AnnotationListImpl result = new AnnotationListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery().apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            Query q = em.createNamedQuery("findAnnotations");
            q.setParameter("userId", (Object)this.securityService.getUser().getUsername());
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            List annotations = q.getResultList();
            for (Annotation a : annotations) {
                result.add(a);
            }
        });
        return result;
    }

    public AnnotationList getAnnotationsByTypeAndMediapackageId(String type, String mediapackageId, int offset, int limit) {
        AnnotationListImpl result = new AnnotationListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(type, mediapackageId).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            Query q = em.createNamedQuery("findAnnotationsByTypeAndMediapackageId");
            q.setParameter("userId", (Object)this.securityService.getUser().getUsername());
            q.setParameter("type", (Object)type);
            q.setParameter("mediapackageId", (Object)mediapackageId);
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            List annotations = q.getResultList();
            for (Annotation a : annotations) {
                result.add(a);
            }
        });
        return result;
    }

    public AnnotationList getAnnotationsByMediapackageId(String mediapackageId, int offset, int limit) {
        AnnotationListImpl result = new AnnotationListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalByMediapackageIDQuery(mediapackageId).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            Query q = em.createNamedQuery("findAnnotationsByMediapackageId");
            q.setParameter("userId", (Object)this.securityService.getUser().getUsername());
            q.setParameter("mediapackageId", (Object)mediapackageId);
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            List annotations = q.getResultList();
            for (Annotation a : annotations) {
                result.add(a);
            }
        });
        return result;
    }

    public AnnotationList getAnnotationsByTypeAndDay(String type, String day, int offset, int limit) {
        int year = Integer.parseInt(day.substring(0, 4));
        int month = Integer.parseInt(day.substring(4, 6)) - 1;
        int date = Integer.parseInt(day.substring(6, 8));
        GregorianCalendar calBegin = new GregorianCalendar();
        calBegin.set(year, month, date, 0, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.set(year, month, date, 23, 59);
        AnnotationListImpl result = new AnnotationListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(type, calBegin, calEnd).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            Query q = em.createNamedQuery("findAnnotationsByTypeAndIntervall");
            q.setParameter("userId", (Object)this.securityService.getUser().getUsername());
            q.setParameter("type", (Object)type);
            q.setParameter("begin", calBegin, TemporalType.TIMESTAMP);
            q.setParameter("end", calEnd, TemporalType.TIMESTAMP);
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            List annotations = q.getResultList();
            for (Annotation a : annotations) {
                result.add(a);
            }
        });
        return result;
    }

    public AnnotationList getAnnotationsByDay(String day, int offset, int limit) {
        AnnotationListImpl result = new AnnotationListImpl();
        int year = Integer.parseInt(day.substring(0, 4));
        int month = Integer.parseInt(day.substring(4, 6)) - 1;
        int date = Integer.parseInt(day.substring(6, 8));
        GregorianCalendar calBegin = new GregorianCalendar();
        calBegin.set(year, month, date, 0, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.set(year, month, date, 23, 59);
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(calBegin, calEnd).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            Query q = em.createNamedQuery("findAnnotationsByIntervall");
            q.setParameter("userId", (Object)this.securityService.getUser().getUsername());
            q.setParameter("begin", calBegin, TemporalType.TIMESTAMP);
            q.setParameter("end", calEnd, TemporalType.TIMESTAMP);
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            List annotations = q.getResultList();
            for (Annotation a : annotations) {
                result.add(a);
            }
        });
        return result;
    }

    public AnnotationList getAnnotationsByType(String type, int offset, int limit) {
        AnnotationListImpl result = new AnnotationListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(type).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            Query q = em.createNamedQuery("findAnnotationsByType");
            q.setParameter("userId", (Object)this.securityService.getUser().getUsername());
            q.setParameter("type", (Object)type);
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            List annotations = q.getResultList();
            for (Annotation a : annotations) {
                result.add(a);
            }
        });
        return result;
    }

    private Function<EntityManager, Integer> getTotalQuery() {
        return Queries.namedQuery.find("findTotal", Long.class, new Object[]{Pair.of((Object)"userId", (Object)this.securityService.getUser().getUsername())}).andThen(Long::intValue);
    }

    private Function<EntityManager, Integer> getTotalQuery(String type) {
        return Queries.namedQuery.find("findTotalByType", Long.class, new Object[]{Pair.of((Object)"userId", (Object)this.securityService.getUser().getUsername()), Pair.of((Object)"type", (Object)type)}).andThen(Long::intValue);
    }

    private Function<EntityManager, Integer> getTotalQuery(String type, String mediapackageId) {
        return Queries.namedQuery.find("findTotalByTypeAndMediapackageId", Long.class, new Object[]{Pair.of((Object)"userId", (Object)this.securityService.getUser().getUsername()), Pair.of((Object)"type", (Object)type), Pair.of((Object)"mediapackageId", (Object)mediapackageId)}).andThen(Long::intValue);
    }

    private Function<EntityManager, Integer> getTotalByMediapackageIDQuery(String mediapackageId) {
        return Queries.namedQuery.find("findTotalByMediapackageId", Long.class, new Object[]{Pair.of((Object)"userId", (Object)this.securityService.getUser().getUsername()), Pair.of((Object)"mediapackageId", (Object)mediapackageId)}).andThen(Long::intValue);
    }

    private Function<EntityManager, Integer> getTotalQuery(String type, Calendar calBegin, Calendar calEnd) {
        return Queries.namedQuery.find("findTotalByTypeAndIntervall", Long.class, new Object[]{Pair.of((Object)"userId", (Object)this.securityService.getUser().getUsername()), Pair.of((Object)"type", (Object)type), Pair.of((Object)"begin", (Object)calBegin), Pair.of((Object)"end", (Object)calEnd)}).andThen(Long::intValue);
    }

    private Function<EntityManager, Integer> getTotalQuery(Calendar calBegin, Calendar calEnd) {
        return Queries.namedQuery.find("findTotalByIntervall", Long.class, new Object[]{Pair.of((Object)"userId", (Object)this.securityService.getUser().getUsername()), Pair.of((Object)"begin", (Object)calBegin), Pair.of((Object)"end", (Object)calEnd)}).andThen(Long::intValue);
    }
}

