/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.analyzemediapackage;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Analyze Mediapackage Workflow Operation Handler", "workflow.operation=analyze-mediapackage"}, immediate=true, service={WorkflowOperationHandler.class})
public class AnalyzeMediapackageWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeMediapackageWorkflowOperationHandler.class);
    public static final String TAG_VARIABLES_PROPERTY = "set-tag-variables";
    public static final String PUBLICATION_VARIABLES_PROPERTY = "set-publication-variables";

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        boolean setTagVariables = BooleanUtils.toBoolean((String)workflowInstance.getCurrentOperation().getConfiguration(TAG_VARIABLES_PROPERTY));
        boolean setPublicationVariables = BooleanUtils.toBoolean((String)workflowInstance.getCurrentOperation().getConfiguration(PUBLICATION_VARIABLES_PROPERTY));
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        Collection<Object> elements = null;
        if (tagsAndFlavors.getSrcFlavors().isEmpty() && tagsAndFlavors.getSrcTags().isEmpty()) {
            elements = Arrays.asList(mediaPackage.getElements());
        } else {
            SimpleElementSelector mpeSelector = new SimpleElementSelector();
            for (MediaPackageElementFlavor flavor : tagsAndFlavors.getSrcFlavors()) {
                mpeSelector.addFlavor(flavor);
            }
            for (String tag : tagsAndFlavors.getSrcTags()) {
                mpeSelector.addTag(tag);
            }
            elements = mpeSelector.select(mediaPackage, false);
        }
        HashMap<CallSite, String> properties = new HashMap<CallSite, String>();
        for (MediaPackageElement mpe : elements) {
            if (MediaPackageElement.Type.Publication == mpe.getElementType()) continue;
            String flavorPrefix = mpe.getFlavor().getType() + "_" + mpe.getFlavor().getSubtype();
            properties.put((CallSite)((Object)(flavorPrefix + "_exists")), "true");
            properties.put((CallSite)((Object)(flavorPrefix + "_type")), mpe.getElementType().toString());
            if (!setTagVariables) continue;
            for (String tag : mpe.getTags()) {
                properties.put((CallSite)((Object)(flavorPrefix + "_hastag_" + tag)), "true");
            }
        }
        if (setPublicationVariables) {
            for (Publication publication : mediaPackage.getPublications()) {
                String channel = publication.getChannel().replaceAll("[^a-z0-9]", "_").toLowerCase();
                properties.put((CallSite)((Object)("publication_" + channel + "_exists")), "true");
            }
        }
        return this.createResult(mediaPackage, properties, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Analyze Mediapackage WOH activated.");
    }
}

