/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adopter.registration.dto;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import org.opencastproject.adopter.registration.dto.Adopter;

public class GeneralData {
    private static final Gson gson = new Gson();
    @SerializedName(value="adopter_key")
    private String adopterKey;
    @SerializedName(value="organisation_name")
    private final String organisationName;
    @SerializedName(value="department_name")
    private final String departmentName;
    @SerializedName(value="first_name")
    private final String firstName;
    @SerializedName(value="last_name")
    private final String lastName;
    private final String country;
    private final String city;
    @SerializedName(value="postal_code")
    private final String postalCode;
    private final String street;
    @SerializedName(value="street_no")
    private final String streetNo;
    private final String email;
    @SerializedName(value="contact_me")
    private final boolean allowContact;
    @SerializedName(value="system_type")
    private final String systemType;
    @SerializedName(value="send_errors")
    private final boolean allowErrorReports;
    @SerializedName(value="send_usage")
    private final boolean allowStatistics;

    public GeneralData(Adopter adopter) {
        this.adopterKey = adopter.getAdopterKey();
        this.organisationName = adopter.getOrganisationName();
        this.departmentName = adopter.getDepartmentName();
        this.firstName = adopter.getFirstName();
        this.lastName = adopter.getLastName();
        this.country = adopter.getCountry();
        this.city = adopter.getCity();
        this.postalCode = adopter.getPostalCode();
        this.street = adopter.getStreet();
        this.streetNo = adopter.getStreetNo();
        this.email = adopter.getEmail();
        this.allowContact = adopter.allowsContacting();
        this.systemType = adopter.systemType();
        this.allowErrorReports = adopter.allowsErrorReports();
        this.allowStatistics = adopter.allowsStatistics();
    }

    public String jsonify() {
        return gson.toJson((Object)this);
    }

    public String getAdopterKey() {
        return this.adopterKey;
    }

    public void setAdopterKey(String key) {
        this.adopterKey = key;
    }

    public String getOrganisationName() {
        return this.organisationName;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCity() {
        return this.city;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getStreet() {
        return this.street;
    }

    public String getStreetNo() {
        return this.streetNo;
    }

    public String getEmail() {
        return this.email;
    }

    public String getContactMe() {
        return Boolean.toString(this.allowContact);
    }

    public String getSystemType() {
        return this.systemType;
    }

    public String getErrorReports() {
        return Boolean.toString(this.allowErrorReports);
    }

    public String getStatisticss() {
        return Boolean.toString(this.allowStatistics);
    }
}

