/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adopter.registration;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.opencastproject.adopter.registration.AdopterRegistrationException;
import org.opencastproject.adopter.registration.AdopterRegistrationExtra;
import org.opencastproject.adopter.registration.AdopterRegistrationSender;
import org.opencastproject.adopter.registration.dto.Adopter;
import org.opencastproject.adopter.registration.dto.GeneralData;
import org.opencastproject.adopter.registration.dto.Host;
import org.opencastproject.adopter.registration.dto.StatisticData;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.search.api.SearchResultList;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.DefaultOrganization;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.HostRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.userdirectory.JpaUserAndRoleProvider;
import org.opencastproject.userdirectory.JpaUserReferenceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AdopterRegistrationServiceImpl.class}, property={"service.description=Adopter Statistics Registration Service"})
public class AdopterRegistrationServiceImpl
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(AdopterRegistrationServiceImpl.class);
    private static final String PROP_KEY_STATISTIC_SERVER_ADDRESS = "org.opencastproject.adopter.registration.server.url";
    private static final String DEFAULT_STATISTIC_SERVER_ADDRESS = "https://register.opencast.org";
    private static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    private static final Gson gson = new Gson();
    private ServiceRegistry serviceRegistry;
    private CaptureAgentStateService caStateService;
    private OrganizationDirectoryService organizationDirectoryService;
    private AssetManager assetManager;
    private SeriesService seriesService;
    private SearchService searchService;
    protected UserProvider userRefProvider;
    protected JpaUserAndRoleProvider userProvider;
    protected SecurityService securityService;
    protected EntityManagerFactory emf = null;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    private AdopterRegistrationSender sender;
    private Organization defaultOrganization;
    private User systemAdminUser;
    private String version;
    private Timer timer;

    @Reference(target="(osgi.unit.name=org.opencastproject.adopter.impl)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Activate
    public void activate(BundleContext ctx) {
        logger.info("Activating adopter registration service.");
        this.defaultOrganization = new DefaultOrganization();
        String systemAdminUserName = ctx.getProperty("org.opencastproject.security.digest.user");
        this.systemAdminUser = SecurityUtil.createSystemUser((String)systemAdminUserName, (Organization)this.defaultOrganization);
        Version ctxVersion = ctx.getBundle().getVersion();
        this.version = ctxVersion.toString();
        String serverBaseUrl = ctx.getProperty(PROP_KEY_STATISTIC_SERVER_ADDRESS);
        if (serverBaseUrl != null) {
            logger.error("\nAdopter registration information are sent to a server other than register.opencast.org.\nWe cannot take any responsibility for what is done with the data.");
        }
        this.db = this.dbSessionFactory.createSession(this.emf);
        this.sender = new AdopterRegistrationSender(Objects.toString(serverBaseUrl, DEFAULT_STATISTIC_SERVER_ADDRESS));
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 0L, 86400000L);
    }

    @Deactivate
    public void deactivate() {
        this.timer.cancel();
        this.db.close();
    }

    public void save(Adopter adopter) throws AdopterRegistrationException {
        try {
            this.db.execTx(em -> {
                Optional dbForm = (Optional)Queries.namedQuery.findOpt("Adopter.findAll", Adopter.class, new Object[0]).apply(em);
                if (dbForm.isEmpty()) {
                    adopter.setAdopterKey(UUID.randomUUID().toString());
                    adopter.setStatisticKey(UUID.randomUUID().toString());
                    adopter.setDateCreated(new Date());
                    adopter.setDateModified(new Date());
                    em.persist((Object)adopter);
                } else {
                    ((Adopter)dbForm.get()).merge(adopter);
                    em.merge((Object)((Adopter)dbForm.get()));
                }
            });
        }
        catch (Exception e) {
            logger.error("Couldn't update the adopter statistics registration adopter: {}", (Object)e.getMessage());
            throw new AdopterRegistrationException(e);
        }
    }

    public void markForDeletion() {
        Adopter a = this.get();
        if (null != a) {
            a.delete();
            this.save(a);
        }
    }

    public void delete() {
        try {
            this.db.execTx(Queries.namedQuery.delete("Adopter.deleteAll", new Object[0]));
        }
        catch (Exception e) {
            logger.error("Error occurred while deleting the adopter registration table. {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public Adopter get() throws AdopterRegistrationException {
        return ((Optional)this.db.exec(Queries.namedQuery.findOpt("Adopter.findAll", Adopter.class, new Object[0]))).orElse(null);
    }

    @Override
    public void run() {
        Adopter adopter;
        logger.info("Executing adopter statistic scheduler task.");
        try {
            adopter = this.get();
            if (null == adopter) {
                logger.info("Adopter not registered, aborting");
                return;
            }
        }
        catch (Exception e) {
            logger.error("Couldn't retrieve adopter registration data.", (Throwable)e);
            return;
        }
        if (adopter.shouldDelete()) {
            Adopter f = new Adopter();
            f.setAdopterKey(adopter.getAdopterKey());
            GeneralData gd = new GeneralData(f);
            gd.setAdopterKey(adopter.getAdopterKey());
            StatisticData sd = new StatisticData(adopter.getStatisticKey());
            try {
                this.sender.deleteStatistics(sd.jsonify());
                this.sender.deleteGeneralData(gd.jsonify());
                this.markForDeletion();
            }
            catch (IOException e) {
                logger.warn("Error occurred while deleting registration data, will retry", (Throwable)e);
            }
            return;
        }
        if (adopter.isRegistered() && adopter.getTermsVersionAgreed() == Adopter.TERMSOFUSEVERSION.APRIL_2022) {
            try {
                String generalDataAsJson = this.collectGeneralData(adopter);
                this.sender.sendGeneralData(generalDataAsJson);
                this.save(adopter);
            }
            catch (IOException e) {
                logger.warn("Error occurred while processing adopter general data.", (Throwable)e);
            }
            if (adopter.allowsStatistics()) {
                try {
                    StatisticData statisticData = this.collectStatisticData(adopter.getAdopterKey(), adopter.getStatisticKey());
                    this.sender.sendStatistics(statisticData.jsonify());
                    this.db.exec(em -> {
                        TypedQuery q = em.createNamedQuery("AdopterRegistrationExtra.findAll", AdopterRegistrationExtra.class);
                        q.getResultList().forEach(extra -> {
                            try {
                                Map<String, Object> data = Map.of("statistic_key", statisticData.getStatisticKey(), "data", gson.fromJson(extra.getData(), Map.class));
                                this.sender.sendExtraData(extra.getType(), gson.toJson(data));
                            }
                            catch (IOException e) {
                                logger.warn("Unable to send extra adopter data with type '{}'", (Object)extra.getType(), (Object)e);
                            }
                        });
                    });
                    this.save(adopter);
                }
                catch (IOException e) {
                    logger.warn("Unable to send adopter statistic data");
                }
                catch (Exception e) {
                    logger.error("Error occurred while processing adopter statistic data.", (Throwable)e);
                }
            }
        }
    }

    public String getRegistrationDataAsString() throws Exception {
        Adopter adopter = this.get();
        if (null == adopter) {
            adopter = new Adopter();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("general", new GeneralData(adopter));
        map.put("statistics", this.collectStatisticData(adopter.getAdopterKey(), adopter.getStatisticKey()));
        this.db.exec(em -> {
            TypedQuery q = em.createNamedQuery("AdopterRegistrationExtra.findAll", AdopterRegistrationExtra.class);
            q.getResultList().forEach(extra -> map.put(extra.getType(), gson.fromJson(extra.getData(), Map.class)));
        });
        return gson.toJson(map);
    }

    private String collectGeneralData(Adopter adopterRegistrationAdopter) {
        GeneralData generalData = new GeneralData(adopterRegistrationAdopter);
        return generalData.jsonify();
    }

    private StatisticData collectStatisticData(String adopterKey, String statisticKey) throws Exception {
        StatisticData statisticData = new StatisticData(statisticKey);
        statisticData.setAdopterKey(adopterKey);
        this.serviceRegistry.getHostRegistrations().forEach(host -> {
            Host h = new Host((HostRegistration)host);
            try {
                String services = this.serviceRegistry.getServiceRegistrationsByHost(host.getBaseUrl()).stream().map(sr -> sr.getServiceType()).collect(Collectors.joining(",\n"));
                h.setServices(services);
            }
            catch (ServiceRegistryException e) {
                logger.warn("Error gathering services for {}", (Object)host.getBaseUrl(), (Object)e);
            }
            statisticData.addHost(h);
        });
        statisticData.setJobCount(this.serviceRegistry.count(null, null));
        statisticData.setSeriesCount(this.seriesService.getSeriesCount());
        List orgs = this.organizationDirectoryService.getOrganizations();
        statisticData.setTenantCount(orgs.size());
        for (Organization org : orgs) {
            SecurityUtil.runAs((SecurityService)this.securityService, (Organization)org, (User)this.systemAdminUser, () -> {
                statisticData.setEventCount(statisticData.getEventCount() + this.assetManager.countEvents(org.getId()));
                long current = statisticData.getCACount();
                int orgCAs = this.caStateService.getKnownAgents().size();
                statisticData.setCACount(current + (long)orgCAs);
                SearchSourceBuilder q = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)SearchService.IndexEntryType.Episode)).must((QueryBuilder)QueryBuilders.termQuery((String)"org", (String)org.getId())).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")));
                SearchResultList results = this.searchService.search(q);
                long orgMilis = results.getHits().stream().map(result -> EncodingSchemeUtils.decodeDuration((String)Objects.toString(result.getDublinCore().getFirst(DublinCore.PROPERTY_EXTENT), "0"))).filter(Objects::nonNull).reduce(Long::sum).orElse(0L);
                statisticData.setTotalMinutes(statisticData.getTotalMinutes() + orgMilis / 1000L / 60L);
                long currentUsers = statisticData.getUserCount();
                statisticData.setUserCount(currentUsers + this.userProvider.countUsers() + this.userRefProvider.countUsers());
            });
        }
        statisticData.setVersion(this.version);
        return statisticData;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setCaptureAdminService(CaptureAgentStateService stateService) {
        this.caStateService = stateService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setUserRefProvider(JpaUserReferenceProvider userRefProvider) {
        this.userRefProvider = userRefProvider;
    }

    @Reference
    public void setUserAndRoleProvider(JpaUserAndRoleProvider userProvider) {
        this.userProvider = userProvider;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService orgDirServ) {
        this.organizationDirectoryService = orgDirServ;
    }
}

