/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adopter.registration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdopterRegistrationSender {
    private static final Logger logger = LoggerFactory.getLogger(AdopterRegistrationSender.class);
    private String baseUrl;
    private static final String GENERAL_DATA_URL_SUFFIX = "api/1.0/adopter";
    private static final String STATISTIC_URL_SUFFIX = "api/1.0/statistic";
    private static final String EXTRA_URL_INFIX = "api/1.0";

    public AdopterRegistrationSender(String statisticServerBaseUrl) {
        if (!((String)statisticServerBaseUrl).endsWith("/")) {
            statisticServerBaseUrl = (String)statisticServerBaseUrl + "/";
        }
        this.baseUrl = statisticServerBaseUrl;
    }

    public void sendGeneralData(String json) throws IOException {
        this.send(json, GENERAL_DATA_URL_SUFFIX);
    }

    public void deleteGeneralData(String json) throws IOException {
        this.send(json, GENERAL_DATA_URL_SUFFIX, "DELETE");
    }

    public void sendStatistics(String json) throws IOException {
        this.send(json, STATISTIC_URL_SUFFIX);
    }

    public void sendExtraData(String key, String json) throws IOException {
        this.send(json, "api/1.0/" + key);
    }

    public void deleteStatistics(String json) throws IOException {
        this.send(json, STATISTIC_URL_SUFFIX, "DELETE");
    }

    private void send(String json, String urlSuffix) throws IOException {
        this.send(json, urlSuffix, "GET");
    }

    private void send(String json, String urlSuffix, String method) throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();){
            String url = new URL(this.baseUrl + urlSuffix).toString();
            HttpDeleteWithEntity request = null;
            request = "DELETE".equals(method) ? new HttpDeleteWithEntity(url) : new HttpPost(url);
            request.addHeader("Content-Type", "application/json; utf-8");
            request.addHeader("Accept", "application/json");
            request.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
            CloseableHttpResponse resp = client.execute((HttpUriRequest)request);
            int httpStatus = resp.getStatusLine().getStatusCode();
            boolean errorOccurred = httpStatus < 200 || httpStatus > 299;
            InputStream responseStream = resp.getEntity().getContent();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(responseStream, StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                if (errorOccurred) {
                    String errorMessage = String.format("HttpStatus: %s, HttpResponse: %s", httpStatus, response);
                    throw new RuntimeException(errorMessage);
                }
            }
        }
    }

    static class HttpDeleteWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        HttpDeleteWithEntity(String uri) {
            this.setURI(URI.create(uri));
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

