/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adopter.registration;

import java.util.Date;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opencastproject.adopter.registration.IForm;
import org.opencastproject.security.api.Organization;
import org.opencastproject.util.EqualsUtil;

@Entity
@Access(value=AccessType.FIELD)
@Table(name="oc_adopter_registration")
@NamedQueries(value={@NamedQuery(name="Form.findAll", query="SELECT f FROM Form f"), @NamedQuery(name="Form.deleteAll", query="DELETE FROM Form f")})
public class Form
implements IForm {
    @Id
    @Column(name="adopter_key", length=64)
    private String adopterKey;
    @Column(name="statistic_key")
    private String statisticKey;
    @Column(name="organisation")
    private String organisationName;
    @Column(name="department")
    private String departmentName;
    @Column(name="first_name")
    private String firstName;
    @Column(name="last_name")
    private String lastName;
    @Column(name="email")
    private String email;
    @Column(name="country")
    private String country;
    @Column(name="postal_code")
    private String postalCode;
    @Column(name="city")
    private String city;
    @Column(name="street")
    private String street;
    @Column(name="street_no")
    private String streetNo;
    @Column(name="contact_me")
    private boolean contactMe;
    @Column(name="system_type")
    private String systemType;
    @Column(name="allows_statistics")
    private boolean allowsStatistics;
    @Column(name="allows_error_reports")
    private boolean allowsErrorReports;
    @Column(name="created", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreated;
    @Column(name="last_modified", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModified;
    @Column(name="agreed_to_policy")
    private boolean agreedToPolicy;
    @Column(name="registered")
    private boolean registered;
    @Column(name="terms_version_agreed")
    private TERMSOFUSEVERSION termsVersionAgreed = TERMSOFUSEVERSION.PRE_2022;
    @Column(name="delete_me")
    private boolean deleteMe = false;

    public static final TERMSOFUSEVERSION getLatestTermsOfUse() {
        return TERMSOFUSEVERSION.APRIL_2022;
    }

    public Form() {
    }

    public Form(String organisationName, String departmentName, String firstName, String lastName, String email, String country, String postalCode, String city, String street, String streetNo, boolean contactMe, String systemType, boolean allowsStatistics, boolean allowsErrorReports, boolean agreedToPolicy, boolean registered) {
        this.organisationName = organisationName;
        this.departmentName = departmentName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.country = country;
        this.postalCode = postalCode;
        this.city = city;
        this.street = street;
        this.streetNo = streetNo;
        this.contactMe = contactMe;
        this.systemType = systemType;
        this.allowsStatistics = allowsStatistics;
        this.allowsErrorReports = allowsErrorReports;
        this.agreedToPolicy = agreedToPolicy;
        if (this.agreedToPolicy) {
            this.termsVersionAgreed = Form.getLatestTermsOfUse();
        }
        this.registered = registered;
    }

    @Override
    public void merge(IForm form) {
        Form f = (Form)form;
        this.organisationName = f.organisationName;
        this.departmentName = f.departmentName;
        this.firstName = f.firstName;
        this.lastName = f.lastName;
        this.email = f.email;
        this.country = f.country;
        this.postalCode = f.postalCode;
        this.city = f.city;
        this.street = f.street;
        this.streetNo = f.streetNo;
        this.contactMe = f.contactMe;
        this.systemType = f.systemType;
        this.allowsStatistics = f.allowsStatistics;
        this.allowsErrorReports = f.allowsErrorReports;
        this.agreedToPolicy = f.agreedToPolicy;
        this.termsVersionAgreed = f.termsVersionAgreed;
        if (!this.registered) {
            this.registered = f.registered;
        }
        this.dateModified = new Date();
        this.deleteMe = f.deleteMe;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Organization)) {
            return false;
        }
        return ((Form)obj).adopterKey.equals(this.adopterKey);
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.adopterKey});
    }

    public String toString() {
        return this.adopterKey;
    }

    public String getAdopterKey() {
        return this.adopterKey;
    }

    public void setAdopterKey(String adopterKey) {
        this.adopterKey = adopterKey;
    }

    public String getStatisticKey() {
        return this.statisticKey;
    }

    public void setStatisticKey(String statisticKey) {
        this.statisticKey = statisticKey;
    }

    public String getOrganisationName() {
        return this.organisationName;
    }

    public void setOrganisationName(String organisationName) {
        this.organisationName = organisationName;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreetNo() {
        return this.streetNo;
    }

    public void setStreetNo(String streetNo) {
        this.streetNo = streetNo;
    }

    public boolean allowsContacting() {
        return this.contactMe;
    }

    public void setContactMe(boolean contactMe) {
        this.contactMe = contactMe;
    }

    public String systemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public boolean allowsStatistics() {
        return this.allowsStatistics;
    }

    public void setAllowsStatistics(boolean allowsStatistics) {
        this.allowsStatistics = allowsStatistics;
    }

    public boolean allowsErrorReports() {
        return this.allowsErrorReports;
    }

    public void setAllowsErrorReports(boolean allowsErrorReports) {
        this.allowsErrorReports = allowsErrorReports;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public boolean agreedToPolicy() {
        return this.agreedToPolicy;
    }

    public void setAgreedToPolicy(boolean agreedToPolicy) {
        this.agreedToPolicy = agreedToPolicy;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public TERMSOFUSEVERSION getTermsVersionAgreed() {
        return Objects.requireNonNullElse(this.termsVersionAgreed, TERMSOFUSEVERSION.PRE_2022);
    }

    public void delete() {
        this.deleteMe = true;
        this.organisationName = null;
        this.departmentName = null;
        this.firstName = null;
        this.lastName = null;
        this.email = null;
        this.country = null;
        this.postalCode = null;
        this.city = null;
        this.street = null;
        this.streetNo = null;
        this.contactMe = false;
        this.systemType = null;
        this.allowsStatistics = false;
        this.allowsErrorReports = false;
        this.dateModified = new Date();
        this.agreedToPolicy = false;
    }

    public boolean shouldDelete() {
        return this.deleteMe;
    }

    public static enum TERMSOFUSEVERSION {
        PRE_2022,
        APRIL_2022;

    }
}

