/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.usersettings;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.adminui.usersettings.UserSetting;
import org.opencastproject.adminui.usersettings.UserSettings;
import org.opencastproject.adminui.usersettings.persistence.UserSettingDto;
import org.opencastproject.adminui.usersettings.persistence.UserSettingsServiceException;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={UserSettingsService.class}, property={"service.description=Admin UI - Users Settings Service", "opencast.service.type=org.opencastproject.adminui.usersettings.UserSettingsService"})
public class UserSettingsService {
    public static final String PERSISTENCE_UNIT = "org.opencastproject.adminui";
    private static final Logger logger = LoggerFactory.getLogger(UserSettingsService.class);
    protected EntityManagerFactory emf;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    protected UserDirectoryService userDirectoryService;
    protected OrganizationDirectoryService organizationDirectoryService;
    protected SecurityService securityService;

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating persistence manager for user settings");
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Reference(target="(osgi.unit.name=org.opencastproject.adminui)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    public UserSettings findUserSettings(int limit, int offset) throws UserSettingsServiceException {
        try {
            UserSettings userSettings = (UserSettings)this.db.exec(this.getUserSettingsQuery(limit, offset));
            userSettings.setTotal((Integer)this.db.exec(this.getUserSettingsTotalQuery()));
            userSettings.setLimit(limit);
            userSettings.setOffset(offset);
            return userSettings;
        }
        catch (Exception e) {
            logger.error("Could not get user settings:", (Throwable)e);
            throw new UserSettingsServiceException(e);
        }
    }

    private Function<EntityManager, Integer> getUserSettingsTotalQuery() {
        String orgId = this.securityService.getOrganization().getId();
        String username = this.securityService.getUser().getUsername();
        return Queries.namedQuery.find("UserSettings.countByUserName", Number.class, new Object[]{Pair.of((Object)"username", (Object)username), Pair.of((Object)"org", (Object)orgId)}).andThen(Number::intValue);
    }

    private Function<EntityManager, UserSettings> getUserSettingsQuery(int limit, int offset) {
        return em -> {
            String orgId = this.securityService.getOrganization().getId();
            String username = this.securityService.getUser().getUsername();
            logger.debug("Getting user settings for '{}' in org '{}'", (Object)username, (Object)orgId);
            List result = em.createNamedQuery("UserSettings.findByUserName", UserSettingDto.class).setParameter("username", (Object)username).setParameter("org", (Object)orgId).setMaxResults(limit).setFirstResult(offset).getResultList();
            if (result.size() == 0) {
                logger.debug("Found no user settings.");
            }
            UserSettings userSettings = new UserSettings();
            for (UserSettingDto userSettingsDto : result) {
                UserSetting userSetting = userSettingsDto.toUserSetting();
                logger.debug("Found user setting id: {} key: {} value: {}", new Object[]{userSetting.getId(), userSetting.getKey(), userSetting.getValue()});
                userSettings.addUserSetting(userSetting);
            }
            return userSettings;
        };
    }

    public UserSetting addUserSetting(String key, String value) throws UserSettingsServiceException {
        String orgId = this.securityService.getOrganization().getId();
        String username = this.securityService.getUser().getUsername();
        Optional<UserSettingDto> userSettingOpt = ((List)this.db.exec(this.getUserSettingsByKeyQuery(key))).stream().filter(setting -> setting.getKey().equalsIgnoreCase(key)).findFirst();
        if (userSettingOpt.isPresent()) {
            try {
                return (UserSetting)this.db.execTx(em -> {
                    UserSettingDto userSettingDto = (UserSettingDto)userSettingOpt.get();
                    userSettingDto.setValue(value);
                    em.merge((Object)userSettingDto);
                    return userSettingDto.toUserSetting();
                });
            }
            catch (Exception e) {
                throw new UserSettingsServiceException(e);
            }
        }
        try {
            return (UserSetting)this.db.execTx(em -> {
                UserSettingDto userSettingDto = new UserSettingDto();
                userSettingDto.setKey(key);
                userSettingDto.setValue(value);
                userSettingDto.setUsername(username);
                userSettingDto.setOrganization(orgId);
                em.persist((Object)userSettingDto);
                return userSettingDto.toUserSetting();
            });
        }
        catch (Exception e) {
            throw new UserSettingsServiceException(e);
        }
    }

    private Function<EntityManager, List<UserSettingDto>> getUserSettingsByKeyQuery(String key) {
        String orgId = this.securityService.getOrganization().getId();
        String username = this.securityService.getUser().getUsername();
        logger.debug("Getting user settings for '{}' in org '{}'", (Object)username, (Object)orgId);
        return Queries.namedQuery.findAll("UserSettings.findByKey", UserSettingDto.class, new Object[]{Pair.of((Object)"key", (Object)key), Pair.of((Object)"username", (Object)username), Pair.of((Object)"org", (Object)orgId)});
    }

    public UserSetting updateUserSetting(String key, String value, String oldValue) throws UserSettingsServiceException {
        try {
            UserSettingDto userSettingDto = ((List)this.db.exec(this.getUserSettingsByKeyQuery(key))).stream().filter(setting -> setting.getKey().equalsIgnoreCase(key) && setting.getValue().equalsIgnoreCase(oldValue)).findFirst().orElseThrow(() -> new UserSettingsServiceException("Unable to find user setting with key " + key + " value " + value + " and old value " + oldValue));
            return this.updateUserSetting(userSettingDto.getId(), key, value);
        }
        catch (Exception e) {
            logger.error("Could not update user setting", (Throwable)e);
            throw new UserSettingsServiceException(e);
        }
    }

    public UserSetting updateUserSetting(long id, String key, String value) throws UserSettingsServiceException {
        String orgId = this.securityService.getOrganization().getId();
        String username = this.securityService.getUser().getUsername();
        logger.debug("Updating user setting id: {} key: {} value: {}", new Object[]{id, key, value});
        try {
            return (UserSetting)this.db.execTx(em -> {
                UserSettingDto userSettingDto = (UserSettingDto)em.find(UserSettingDto.class, (Object)id);
                userSettingDto.setKey(key);
                userSettingDto.setValue(value);
                em.persist((Object)userSettingDto);
                return userSettingDto.toUserSetting();
            });
        }
        catch (Exception e) {
            logger.error("Could not update user setting username '{}' org: '{}' id: '{}' key: '{}' value: '{}'", new Object[]{username, orgId, id, key, value, e});
            throw new UserSettingsServiceException(e);
        }
    }

    public void deleteUserSetting(long id) throws UserSettingsServiceException {
        try {
            this.db.execTx(em -> {
                UserSettingDto userSettingsDto = (UserSettingDto)em.find(UserSettingDto.class, (Object)id);
                em.remove((Object)userSettingsDto);
            });
        }
        catch (Exception e) {
            logger.error("Could not delete user setting '{}'", (Object)id, (Object)e);
            throw new UserSettingsServiceException(e);
        }
    }
}

