/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.util.Workflows;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/tasks")
@RestService(name="TasksService", title="UI Tasks", abstractText="Provides resources and operations related to the tasks", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={TasksEndpoint.class}, property={"service.description=Admin UI - Tasks facade Endpoint", "opencast.service.type=org.opencastproject.adminui.endpoint.TasksEndpoint", "opencast.service.path=/admin-ng/tasks"})
@JaxrsResource
public class TasksEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(TasksEndpoint.class);
    private WorkflowService workflowService;
    private AssetManager assetManager;
    private static final Fn<WorkflowInstance, Long> getWorkflowIds = new Fn<WorkflowInstance, Long>(){

        public Long apply(WorkflowInstance a) {
            return a.getId();
        }
    };

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Activate tasks endpoint");
    }

    @GET
    @Path(value="processing.json")
    @RestQuery(name="getProcessing", description="Returns all the data related to the processing tab in the new tasks modal as JSON", returnDescription="All the data related to the tasks processing tab as JSON", restParameters={@RestParameter(name="tags", isRequired=false, description="A comma separated list of tags to filter the workflow definitions", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Returns all the data related to the tasks processing tab as JSON")})
    public Response getProcessing(@QueryParam(value="tags") String tagsString) {
        List tags = RestUtil.splitCommaSeparatedParam((Option)Option.option((Object)tagsString)).value();
        ArrayList<JObject> actions = new ArrayList<JObject>();
        try {
            List workflowsDefinitions = this.workflowService.listAvailableWorkflowDefinitions();
            for (WorkflowDefinition wflDef : workflowsDefinitions) {
                if (!wflDef.containsTag((Collection)tags)) continue;
                actions.add(Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((String)wflDef.getId())), Jsons.f((String)"title", (JValue)Jsons.v((String)((String)Opt.nul((Object)wflDef.getTitle()).getOr((Object)"")))), Jsons.f((String)"description", (JValue)Jsons.v((String)((String)Opt.nul((Object)wflDef.getDescription()).getOr((Object)"")))), Jsons.f((String)"configuration_panel", (JValue)Jsons.v((String)((String)Opt.nul((Object)wflDef.getConfigurationPanel()).getOr((Object)"")))), Jsons.f((String)"configuration_panel_json", (JValue)Jsons.v((String)((String)Opt.nul((Object)wflDef.getConfigurationPanelJson()).getOr((Object)""))))}));
            }
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Unable to get available workflow definitions", (Throwable)e);
            return RestUtil.R.serverError();
        }
        return RestUtils.okJson((JValue)Jsons.arr(actions));
    }

    @POST
    @Path(value="/new")
    @RestQuery(name="createNewTask", description="Creates a new task by the given metadata as JSON", returnDescription="The task identifiers", restParameters={@RestParameter(name="metadata", isRequired=true, description="The metadata as JSON.<p>Example:<p><code><pre>{\n  \"workflow\":\"republish-metadata\",\n  \"configuration\":{\n    \"ID-dual-stream-demo\":{\"workflowVar\":\"true\"},\n    \"ID-about-opencast\":{\"workflowVar\":\"true\"}\n  }\n}</pre></code>", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=201, description="Task sucessfully added"), @RestResponse(responseCode=404, description="If the workflow definition is not found"), @RestResponse(responseCode=400, description="If the metadata is not set or couldn't be parsed")})
    public Response createNewTask(@FormParam(value="metadata") String metadata) throws NotFoundException {
        WorkflowDefinition wfd;
        Map metadataJson;
        if (StringUtils.isBlank((CharSequence)metadata)) {
            logger.warn("No metadata set");
            return RestUtil.R.badRequest((String)"No metadata set");
        }
        Gson gson = new Gson();
        try {
            metadataJson = (Map)gson.fromJson(metadata, Map.class);
        }
        catch (Exception e) {
            logger.warn("Unable to parse metadata {}", (Object)metadata);
            return RestUtil.R.badRequest((String)"Unable to parse metadata");
        }
        String workflowId = (String)metadataJson.get("workflow");
        if (StringUtils.isBlank((CharSequence)workflowId)) {
            return RestUtil.R.badRequest((String)"No workflow set");
        }
        Map configuration = (Map)metadataJson.get("configuration");
        if (configuration == null) {
            return RestUtil.R.badRequest((String)"No events set");
        }
        try {
            wfd = this.workflowService.getWorkflowDefinitionById(workflowId);
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Unable to get workflow definition {}", (Object)workflowId, (Object)e);
            return RestUtil.R.serverError();
        }
        Workflows workflows = new Workflows(this.assetManager, this.workflowService);
        ArrayList instances = new ArrayList();
        for (Map.Entry entry : configuration.entrySet()) {
            ConfiguredWorkflow workflow = ConfiguredWorkflow.workflow((WorkflowDefinition)wfd, (Map)((Map)entry.getValue()));
            Set<String> mpIds = Collections.singleton((String)entry.getKey());
            List partialResult = workflows.applyWorkflowToLatestVersion(mpIds, workflow);
            if (partialResult.size() != 1) {
                logger.warn("Couldn't start workflow for media package {}", entry.getKey());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            instances.addAll(partialResult);
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)gson.toJson((Object)Stream.$(instances).map(getWorkflowIds).toList())).build();
    }
}

