/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.data.Opt;
import com.google.gson.Gson;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.adminui.impl.ProviderQuery;
import org.opencastproject.adminui.impl.RawProviderQuery;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.StatisticsService;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.statistics.export.api.StatisticsExportService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.functions.Functions;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/statistics")
@RestService(name="statistics", title="statistics fa\u00e7ade service", abstractText="Provides statistics", notes={"This service provides statistics.<em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={StatisticsEndpoint.class}, property={"service.description=Admin UI - Statistics Endpoint", "opencast.service.type=org.opencastproject.adminui.StatisticsEndpoint", "opencast.service.path=/admin-ng/statistics"})
@JaxrsResource
public class StatisticsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsEndpoint.class);
    private static final String TIME_SERIES_PROVIDER_TYPE = "timeSeries";
    private static final String STATISTICS_ORGANIZATION_UI_ROLE = "ROLE_UI_STATISTICS_ORGANIZATION_VIEW";
    private SecurityService securityService;
    private IndexService indexService;
    private ElasticsearchIndex searchIndex;
    private StatisticsService statisticsService;
    private StatisticsExportService statisticsExportService;

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    public void setSearchIndex(ElasticsearchIndex searchIndex) {
        this.searchIndex = searchIndex;
    }

    @Reference
    public void setStatisticsService(StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    @Reference
    public void setStatisticsExportService(StatisticsExportService statisticsExportService) {
        this.statisticsExportService = statisticsExportService;
    }

    @GET
    @Path(value="providers.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getprovidersbyresourcetype", description="Returns the available statistics providers for an (optional) resource type", returnDescription="The available statistics providers as JSON", restParameters={@RestParameter(name="resourceType", description="The resource type: either 'episode', 'series' or 'organization'", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the providers for the given resource type as JSON, or all, if the resource type is missing", responseCode=200), @RestResponse(description="If the current user is not authorized to perform this action", responseCode=401)})
    public Response getProviders(@QueryParam(value="resourceType") String resourceTypeStr) {
        ResourceType resourceType;
        try {
            resourceType = resourceTypeStr == null ? null : Enum.valueOf(ResourceType.class, resourceTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return RestUtil.R.badRequest((String)"invalid value for 'resourceType'");
        }
        JSONArray result = new JSONArray();
        this.statisticsService.getProviders(resourceType).stream().map(this::providerToJson).forEach(arg_0 -> result.add(arg_0));
        return Response.ok((Object)result.toJSONString()).build();
    }

    private static String providerTypeString(StatisticsProvider provider) {
        if (provider instanceof TimeSeriesProvider) {
            return TIME_SERIES_PROVIDER_TYPE;
        }
        return "unknown";
    }

    private JSONObject providerToJson(StatisticsProvider provider) {
        JSONObject providerObj = new JSONObject();
        providerObj.put((Object)"providerId", (Object)provider.getId());
        providerObj.put((Object)"providerType", (Object)StatisticsEndpoint.providerTypeString(provider));
        providerObj.put((Object)"title", (Object)provider.getTitle());
        if (provider instanceof TimeSeriesProvider) {
            providerObj.put((Object)"dataResolutions", (Object)this.resolutionsToJson(((TimeSeriesProvider)provider).getDataResolutions()));
        }
        providerObj.put((Object)"description", (Object)provider.getDescription());
        return providerObj;
    }

    private JSONArray resolutionsToJson(Set<DataResolution> resolutions) {
        JSONArray result = new JSONArray();
        for (DataResolution dataResolution : resolutions) {
            result.add((Object)this.dataResolutionToJson(dataResolution));
        }
        return result;
    }

    private String dataResolutionToJson(DataResolution dataResolution) {
        return dataResolution.toString().toLowerCase();
    }

    @POST
    @Path(value="data.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getproviderdata", description="Returns the statistical data for a specific provider and a specific resource", returnDescription="The statistical data as JSON", restParameters={@RestParameter(name="data", isRequired=true, description="A list of statistical data requests, containing a provider id, from, to, the resource id and a resolution - all as JSON", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Returns the statistical data for the given resource type as JSON", responseCode=200), @RestResponse(description="If the current user is not authorized to perform this action", responseCode=401)})
    public Response getProviderData(@FormParam(value="data") String data) {
        RawProviderQuery[] dataJson;
        if (StringUtils.isBlank((CharSequence)data)) {
            return RestUtil.R.badRequest((String)"No data set");
        }
        Gson gson = new Gson();
        try {
            dataJson = (RawProviderQuery[])gson.fromJson(data, RawProviderQuery[].class);
        }
        catch (Exception e) {
            logger.warn("Unable to parse data {}", (Object)data);
            return RestUtil.R.badRequest((String)"Unable to parse data");
        }
        JSONArray result = new JSONArray();
        try {
            Arrays.stream(dataJson).map(ProviderQuery::new).flatMap(q -> this.statisticsService.getProvider(q.getProviderId()).map(Stream::of).orElseGet(Stream::empty).peek(p -> this.checkAccess(q.getResourceId(), p.getResourceType())).map(p -> this.timeSeriesToJson(p.getId(), this.statisticsService.getTimeSeriesData(p, q.getResourceId(), q.getFrom(), q.getTo(), q.getDataResolution(), ZoneId.systemDefault())))).forEach(arg_0 -> result.add(arg_0));
        }
        catch (IllegalArgumentException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        return Response.ok((Object)result.toJSONString()).build();
    }

    @GET
    @Path(value="export.csv")
    @Produces(value={"text/plain"})
    @RestQuery(name="getcsvdata", description="Returns the statistical data for a specific provider and a specific resource as CSV.", returnDescription="The statistical data as CSV", restParameters={@RestParameter(name="providerId", isRequired=true, description="The provider id", type=RestParameter.Type.TEXT), @RestParameter(name="resourceId", isRequired=true, description="The resource id", type=RestParameter.Type.TEXT), @RestParameter(name="from", isRequired=true, description="The from date in iso 8601 UTC notation", type=RestParameter.Type.TEXT), @RestParameter(name="to", isRequired=true, description="The to date in iso 8601 UTC notation", type=RestParameter.Type.TEXT), @RestParameter(name="dataResolution", isRequired=true, description="The data resolution. Valid values are 'HOURLY', 'DAILY', 'WEEKLY', 'MONTHLY', and 'YEARLY'", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Returns the statistical data for the given resource type as csv", responseCode=200), @RestResponse(description="If the current user is not authorized to perform this action", responseCode=401)})
    public Response getCSVData(@QueryParam(value="providerId") String providerId, @QueryParam(value="resourceId") String resourceId, @QueryParam(value="from") String fromStr, @QueryParam(value="to") String toStr, @QueryParam(value="dataResolution") String dataResolutionStr) {
        try {
            ProviderQuery q = new ProviderQuery(providerId, fromStr, toStr, dataResolutionStr, resourceId);
            StatisticsProvider p = (StatisticsProvider)this.statisticsService.getProvider(providerId).orElseThrow(() -> new IllegalArgumentException("Unknown provider: " + providerId));
            this.checkAccess(q.getResourceId(), p.getResourceType());
            String csv = this.statisticsExportService.getCSV(p, q.getResourceId(), q.getFrom(), q.getTo(), q.getDataResolution(), this.searchIndex, ZoneId.systemDefault());
            return Response.ok().entity((Object)csv).build();
        }
        catch (IllegalArgumentException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (SearchIndexException e) {
            return RestUtil.R.serverError();
        }
        catch (NotFoundException e) {
            return RestUtil.R.notFound((Object)resourceId);
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    private JSONObject timeSeriesToJson(String providerId, TimeSeries timeSeriesData) {
        JSONObject result = new JSONObject();
        result.put((Object)"providerId", (Object)providerId);
        result.put((Object)"providerType", (Object)TIME_SERIES_PROVIDER_TYPE);
        result.put((Object)"labels", (Object)timeSeriesData.getLabels());
        result.put((Object)"values", (Object)timeSeriesData.getValues());
        if (timeSeriesData.getTotal().isPresent()) {
            result.put((Object)"total", (Object)timeSeriesData.getTotal().getAsDouble());
        }
        return result;
    }

    private void checkAccess(String resourceId, ResourceType resourceType) {
        try {
            switch (resourceType) {
                case EPISODE: {
                    this.checkMediapackageAccess(resourceId);
                    break;
                }
                case SERIES: {
                    this.checkSeriesAccess(resourceId);
                    break;
                }
                case ORGANIZATION: {
                    this.checkOrganizationAccess(resourceId);
                    break;
                }
            }
        }
        catch (SearchIndexException | UnauthorizedException e) {
            Functions.chuck((Throwable)e);
        }
    }

    private void checkMediapackageAccess(String mpId) throws UnauthorizedException, SearchIndexException {
        Opt event = this.indexService.getEvent(mpId, this.searchIndex);
        if (event.isNone()) {
            throw new UnauthorizedException(this.securityService.getUser(), "read");
        }
    }

    private void checkSeriesAccess(String seriesId) throws UnauthorizedException, SearchIndexException {
        Optional series = this.searchIndex.getSeries(seriesId, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (series.isEmpty()) {
            throw new UnauthorizedException(this.securityService.getUser(), "read");
        }
    }

    private void checkOrganizationAccess(String orgId) throws UnauthorizedException {
        boolean userIsAuthorized;
        User currentUser = this.securityService.getUser();
        Organization currentOrg = this.securityService.getOrganization();
        String currentOrgAdminRole = currentOrg.getAdminRole();
        String currentOrgId = currentOrg.getId();
        boolean userIsInOrg = currentOrgId.equals(orgId);
        boolean userIsAdmin = currentUser.hasRole("ROLE_ADMIN") || currentUser.hasRole(currentOrgAdminRole) && userIsInOrg;
        boolean bl = userIsAuthorized = currentUser.hasRole(STATISTICS_ORGANIZATION_UI_ROLE) && userIsInOrg;
        if (!userIsAdmin && !userIsAuthorized) {
            throw new UnauthorizedException(currentUser, "read");
        }
    }
}

