/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.opencastproject.adminui.endpoint.EndpointUtil;
import org.opencastproject.index.service.resources.list.query.ServicesListQuery;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.serviceregistry.api.HostRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceState;
import org.opencastproject.serviceregistry.api.ServiceStatistics;
import org.opencastproject.util.SmartIterator;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/services")
@RestService(name="ServicesProxyService", title="UI Services", abstractText="This service provides the services data for the UI.", notes={"These Endpoints deliver informations about the services required for the UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={ServicesEndpoint.class}, property={"service.description=Admin UI - Services facade Endpoint", "opencast.service.type=org.opencastproject.adminui.endpoint.ServicesEndpoint", "opencast.service.path=/admin-ng/services"})
@JaxrsResource
public class ServicesEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ServicesEndpoint.class);
    private ServiceRegistry serviceRegistry;
    private static final String SERVICE_STATUS_TRANSLATION_PREFIX = "SYSTEMS.SERVICES.STATUS.";

    @GET
    @Path(value="services.json")
    @Produces(value={"application/json"})
    @RestQuery(description="Returns the list of services", name="services", restParameters={@RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The offset", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="filter", description="Filter results by name, host, actions, status or free text query", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="sort", description="The sort order.  May include any of the following: host, name, running, queued, completed,  meanRunTime, meanQueueTime, status. The sort suffix must be :asc for ascending sort order and :desc for descending.", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the list of services from Opencast", responseCode=200)}, returnDescription="The list of services")
    public Response getServices(@QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort) throws Exception {
        ArrayList sortCriteria;
        Option sortOpt = Option.option((Object)StringUtils.trimToNull((String)sort));
        ServicesListQuery query = new ServicesListQuery();
        EndpointUtil.addRequestFiltersToQuery(filter, (ResourceListQueryImpl)query);
        String fName = null;
        if (query.getName().isSome()) {
            fName = StringUtils.trimToNull((String)((String)query.getName().get()));
        }
        String fHostname = null;
        if (query.getHostname().isSome()) {
            fHostname = StringUtils.trimToNull((String)((String)query.getHostname().get()));
        }
        String fNodeName = null;
        if (query.getNodeName().isSome()) {
            fNodeName = StringUtils.trimToNull((String)((String)query.getNodeName().get()));
        }
        String fStatus = null;
        if (query.getStatus().isSome()) {
            fStatus = StringUtils.trimToNull((String)((String)query.getStatus().get()));
        }
        String fFreeText = null;
        if (query.getFreeText().isSome()) {
            fFreeText = StringUtils.trimToNull((String)((String)query.getFreeText().get()));
        }
        List servers = this.serviceRegistry.getHostRegistrations();
        ArrayList<Service> services = new ArrayList<Service>();
        for (ServiceStatistics stats : this.serviceRegistry.getServiceStatistics()) {
            Service service = new Service(this, stats, this.findServerByHost(stats.getServiceRegistration().getHost(), servers));
            if (fName != null && !StringUtils.equalsIgnoreCase((CharSequence)service.getName(), (CharSequence)fName) || fHostname != null && !StringUtils.equalsIgnoreCase((CharSequence)service.getHost(), (CharSequence)fHostname) || fNodeName != null && !StringUtils.equalsIgnoreCase((CharSequence)service.getNodeName(), (CharSequence)fNodeName) || fStatus != null && !StringUtils.equalsIgnoreCase((CharSequence)service.getStatus().toString(), (CharSequence)fStatus)) continue;
            if (query.getActions().isSome()) {
                ServiceState serviceState = service.getStatus();
                if ((Boolean)query.getActions().get() == false ? ServiceState.NORMAL != serviceState : ServiceState.NORMAL == serviceState) continue;
            }
            if (fFreeText != null && !StringUtils.containsIgnoreCase((CharSequence)service.getName(), (CharSequence)fFreeText) && !StringUtils.containsIgnoreCase((CharSequence)service.getHost(), (CharSequence)fFreeText) && !StringUtils.containsIgnoreCase((CharSequence)service.getNodeName(), (CharSequence)fFreeText) && !StringUtils.containsIgnoreCase((CharSequence)service.getStatus().toString(), (CharSequence)fFreeText)) continue;
            services.add(service);
        }
        int total = services.size();
        if (sortOpt.isSome() && !(sortCriteria = RestUtils.parseSortQueryParameter((String)((String)sortOpt.get()))).isEmpty()) {
            try {
                SortCriterion sortCriterion = (SortCriterion)sortCriteria.iterator().next();
                Collections.sort(services, new ServiceStatisticsComparator(this, sortCriterion.getFieldName(), sortCriterion.getOrder() == SortCriterion.Order.Ascending));
            }
            catch (Exception ex) {
                logger.warn("Failed to sort services collection.", (Throwable)ex);
            }
        }
        ArrayList<JValue> jsonList = new ArrayList<JValue>();
        for (Service s : new SmartIterator(limit, offset).applyLimitAndOffset(services)) {
            jsonList.add(s.toJSON());
        }
        return RestUtils.okJsonList(jsonList, (int)offset, (int)limit, (long)total);
    }

    @Activate
    public void activate() {
        logger.info("ServicesEndpoint is activated!");
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    private Optional<HostRegistration> findServerByHost(String hostname, List<HostRegistration> servers) {
        return servers.stream().filter(o -> o.getBaseUrl().equals(hostname)).findFirst();
    }

    class Service
    implements JSONAware {
        public static final String COMPLETED_NAME = "completed";
        public static final String HOST_NAME = "hostname";
        public static final String NODE_NAME = "nodeName";
        public static final String MEAN_QUEUE_TIME_NAME = "meanQueueTime";
        public static final String MEAN_RUN_TIME_NAME = "meanRunTime";
        public static final String NAME_NAME = "name";
        public static final String QUEUED_NAME = "queued";
        public static final String RUNNING_NAME = "running";
        public static final String STATUS_NAME = "status";
        public static final String ONLINE_NAME = "online";
        public static final String MAINTENANCE_NAME = "maintenance";
        private final ServiceStatistics serviceStatistics;
        private final Optional<HostRegistration> server;

        Service(ServicesEndpoint this$0, ServiceStatistics serviceStatistics, Optional<HostRegistration> server) {
            this.serviceStatistics = serviceStatistics;
            this.server = server;
        }

        public int getCompletedJobs() {
            return this.serviceStatistics.getFinishedJobs();
        }

        public String getHost() {
            return this.serviceStatistics.getServiceRegistration().getHost();
        }

        public String getNodeName() {
            return this.server.isPresent() ? this.server.get().getNodeName() : "";
        }

        public long getMeanQueueTime() {
            return TimeUnit.MILLISECONDS.toSeconds(this.serviceStatistics.getMeanQueueTime());
        }

        public long getMeanRunTime() {
            return TimeUnit.MILLISECONDS.toSeconds(this.serviceStatistics.getMeanRunTime());
        }

        public String getName() {
            return this.serviceStatistics.getServiceRegistration().getServiceType();
        }

        public int getQueuedJobs() {
            return this.serviceStatistics.getQueuedJobs();
        }

        public int getRunningJobs() {
            return this.serviceStatistics.getRunningJobs();
        }

        public ServiceState getStatus() {
            return this.serviceStatistics.getServiceRegistration().getServiceState();
        }

        public boolean getIsOnline() {
            return this.serviceStatistics.getServiceRegistration().isOnline();
        }

        public boolean getisMaintenance() {
            return this.serviceStatistics.getServiceRegistration().isInMaintenanceMode();
        }

        public Map<String, String> toMap() {
            HashMap<String, String> serviceMap = new HashMap<String, String>();
            serviceMap.put(COMPLETED_NAME, Integer.toString(this.getCompletedJobs()));
            serviceMap.put(HOST_NAME, this.getHost());
            serviceMap.put(NODE_NAME, this.getNodeName());
            serviceMap.put(MEAN_QUEUE_TIME_NAME, Long.toString(this.getMeanQueueTime()));
            serviceMap.put(MEAN_RUN_TIME_NAME, Long.toString(this.getMeanRunTime()));
            serviceMap.put(NAME_NAME, this.getName());
            serviceMap.put(QUEUED_NAME, Integer.toString(this.getQueuedJobs()));
            serviceMap.put(RUNNING_NAME, Integer.toString(this.getRunningJobs()));
            serviceMap.put(STATUS_NAME, this.getStatus().name());
            serviceMap.put(ONLINE_NAME, Boolean.toString(this.getIsOnline()));
            serviceMap.put(MAINTENANCE_NAME, Boolean.toString(this.getisMaintenance()));
            return serviceMap;
        }

        public String toJSONString() {
            return JSONObject.toJSONString(this.toMap());
        }

        public JValue toJSON() {
            return Jsons.obj((Field[])new Field[]{Jsons.f((String)COMPLETED_NAME, (JValue)Jsons.v((Number)this.getCompletedJobs())), Jsons.f((String)HOST_NAME, (JValue)Jsons.v((Object)this.getHost(), (JValue)Jsons.BLANK)), Jsons.f((String)NODE_NAME, (JValue)Jsons.v((Object)this.getNodeName(), (JValue)Jsons.BLANK)), Jsons.f((String)MEAN_QUEUE_TIME_NAME, (JValue)Jsons.v((Number)this.getMeanQueueTime())), Jsons.f((String)MEAN_RUN_TIME_NAME, (JValue)Jsons.v((Number)this.getMeanRunTime())), Jsons.f((String)NAME_NAME, (JValue)Jsons.v((Object)this.getName(), (JValue)Jsons.BLANK)), Jsons.f((String)QUEUED_NAME, (JValue)Jsons.v((Number)this.getQueuedJobs())), Jsons.f((String)RUNNING_NAME, (JValue)Jsons.v((Number)this.getRunningJobs())), Jsons.f((String)STATUS_NAME, (JValue)Jsons.v((Object)(ServicesEndpoint.SERVICE_STATUS_TRANSLATION_PREFIX + this.getStatus().name()), (JValue)Jsons.BLANK)), Jsons.f((String)ONLINE_NAME, (JValue)Jsons.v((Boolean)this.getIsOnline())), Jsons.f((String)MAINTENANCE_NAME, (JValue)Jsons.v((Boolean)this.getisMaintenance()))});
        }
    }

    class ServiceStatisticsComparator
    implements Comparator<Service> {
        private final String sortBy;
        private final boolean ascending;

        ServiceStatisticsComparator(ServicesEndpoint this$0, String sortBy, boolean ascending) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"completed", (CharSequence)sortBy)) {
                this.sortBy = "completed";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"hostname", (CharSequence)sortBy)) {
                this.sortBy = "hostname";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"nodeName", (CharSequence)sortBy)) {
                this.sortBy = "nodeName";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"meanQueueTime", (CharSequence)sortBy)) {
                this.sortBy = "meanQueueTime";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"meanRunTime", (CharSequence)sortBy)) {
                this.sortBy = "meanRunTime";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)sortBy)) {
                this.sortBy = "name";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"queued", (CharSequence)sortBy)) {
                this.sortBy = "queued";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"running", (CharSequence)sortBy)) {
                this.sortBy = "running";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"status", (CharSequence)sortBy)) {
                this.sortBy = "status";
            } else {
                throw new IllegalArgumentException(String.format("Can't sort services by %s.", sortBy));
            }
            this.ascending = ascending;
        }

        @Override
        public int compare(Service s1, Service s2) {
            int result = 0;
            switch (this.sortBy) {
                case "completed": {
                    result = s1.getCompletedJobs() - s2.getCompletedJobs();
                    break;
                }
                case "hostname": {
                    result = s1.getHost().compareToIgnoreCase(s2.getHost());
                    break;
                }
                case "nodeName": {
                    result = s1.getNodeName().compareToIgnoreCase(s2.getNodeName());
                    break;
                }
                case "meanQueueTime": {
                    result = (int)(s1.getMeanQueueTime() - s2.getMeanQueueTime());
                    break;
                }
                case "meanRunTime": {
                    result = (int)(s1.getMeanRunTime() - s2.getMeanRunTime());
                    break;
                }
                case "queued": {
                    result = s1.getQueuedJobs() - s2.getQueuedJobs();
                    break;
                }
                case "running": {
                    result = s1.getRunningJobs() - s2.getRunningJobs();
                    break;
                }
                case "status": {
                    result = s1.getStatus().compareTo((Enum)s2.getStatus());
                    break;
                }
                default: {
                    result = s1.getName().compareToIgnoreCase(s2.getName());
                }
            }
            return this.ascending ? result : 0 - result;
        }
    }
}

