/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.adminui.endpoint.EndpointUtil;
import org.opencastproject.adminui.impl.AdminUIConfiguration;
import org.opencastproject.adminui.tobira.TobiraException;
import org.opencastproject.adminui.tobira.TobiraService;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.authorization.xacml.manager.util.AccessInformationUtil;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.elasticsearch.index.objects.theme.IndexTheme;
import org.opencastproject.elasticsearch.index.objects.theme.ThemeSearchQuery;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.resources.list.query.SeriesListQuery;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataJson;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.rest.BulkOperationResult;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/series")
@RestService(name="SeriesProxyService", title="UI Series", abstractText="This service provides the series data for the UI.", notes={"This service offers the series CRUD Operations for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={SeriesEndpoint.class}, property={"service.description=Admin UI - SeriesEndpoint Endpoint", "opencast.service.type=org.opencastproject.adminui.SeriesEndpoint", "opencast.service.path=/admin-ng/series"})
@JaxrsResource
public class SeriesEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(SeriesEndpoint.class);
    private static final int CREATED_BY_UI_ORDER = 9;
    private static final int DEFAULT_LIMIT = 100;
    public static final String THEME_KEY = "theme";
    private Boolean deleteSeriesWithEventsAllowed = true;
    private Boolean onlySeriesWithWriteAccessSeriesTab = false;
    private Boolean onlySeriesWithWriteAccessEventsFilter = false;
    public static final String SERIES_HASEVENTS_DELETE_ALLOW_KEY = "series.hasEvents.delete.allow";
    public static final String SERIESTAB_ONLYSERIESWITHWRITEACCESS_KEY = "seriesTab.onlySeriesWithWriteAccess";
    public static final String EVENTSFILTER_ONLYSERIESWITHWRITEACCESS_KEY = "eventsFilter.onlySeriesWithWriteAccess";
    public static final Pattern TOBIRA_CONFIG = Pattern.compile("^tobira\\.(?<organization>.*)\\.(?<key>origin|trustedKey)$");
    private SeriesService seriesService;
    private SecurityService securityService;
    private AclServiceFactory aclServiceFactory;
    private IndexService indexService;
    private ListProvidersService listProvidersService;
    private ElasticsearchIndex searchIndex;
    private AdminUIConfiguration adminUIConfiguration;
    private UserDirectoryService userDirectoryService;
    private String serverUrl = "http://localhost:8080";

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.searchIndex = index;
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    public void setListProvidersService(ListProvidersService listProvidersService) {
        this.listProvidersService = listProvidersService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setAclServiceFactory(AclServiceFactory aclServiceFactory) {
        this.aclServiceFactory = aclServiceFactory;
    }

    private AclService getAclService() {
        return this.aclServiceFactory.serviceFor(this.securityService.getOrganization());
    }

    @Reference
    public void setAdminUIConfiguration(AdminUIConfiguration adminUIConfiguration) {
        this.adminUIConfiguration = adminUIConfiguration;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        if (cc != null) {
            String ccServerUrl = cc.getBundleContext().getProperty("org.opencastproject.server.url");
            logger.debug("Configured server url is {}", (Object)ccServerUrl);
            if (ccServerUrl != null) {
                this.serverUrl = ccServerUrl;
            }
            this.modified(properties);
        }
        logger.info("Activate series endpoint");
    }

    @Modified
    public void modified(Map<String, Object> properties) {
        if (properties == null) {
            logger.info("No configuration available, using defaults");
            return;
        }
        Object mapValue = properties.get(SERIES_HASEVENTS_DELETE_ALLOW_KEY);
        if (mapValue != null) {
            this.deleteSeriesWithEventsAllowed = BooleanUtils.toBoolean((String)mapValue.toString());
        }
        mapValue = properties.get(SERIESTAB_ONLYSERIESWITHWRITEACCESS_KEY);
        this.onlySeriesWithWriteAccessSeriesTab = BooleanUtils.toBoolean((String)Objects.toString(mapValue, "true"));
        mapValue = properties.get(EVENTSFILTER_ONLYSERIESWITHWRITEACCESS_KEY);
        this.onlySeriesWithWriteAccessEventsFilter = BooleanUtils.toBoolean((String)Objects.toString(mapValue, "true"));
        properties.forEach((key, value) -> {
            Matcher matches = TOBIRA_CONFIG.matcher((CharSequence)key);
            if (!matches.matches()) {
                return;
            }
            TobiraService tobira = TobiraService.getTobira(matches.group("organization"));
            switch (matches.group("key")) {
                case "origin": {
                    tobira.setOrigin((String)value);
                    break;
                }
                case "trustedKey": {
                    tobira.setTrustedKey((String)value);
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled Tobira config key");
                }
            }
        });
        logger.info("Configuration updated");
    }

    @GET
    @Path(value="{seriesId}/access.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getseriesaccessinformation", description="Get the access information of a series", returnDescription="The access information", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=400, description="The required form params were missing in the request."), @RestResponse(responseCode=404, description="If the series has not been found."), @RestResponse(responseCode=200, description="The access information ")})
    public Response getSeriesAccessInformation(@PathParam(value="seriesId") String seriesId) throws NotFoundException {
        if (StringUtils.isBlank((CharSequence)seriesId)) {
            return RestUtil.R.badRequest((String)"Path parameter series ID is missing");
        }
        boolean hasProcessingEvents = this.hasProcessingEvents(seriesId);
        JSONArray systemAclsJson = new JSONArray();
        List acls = this.getAclService().getAcls();
        for (ManagedAcl acl : acls) {
            systemAclsJson.add((Object)AccessInformationUtil.serializeManagedAcl((ManagedAcl)acl));
        }
        JSONObject seriesAccessJson = new JSONObject();
        try {
            AccessControlList seriesAccessControl = this.seriesService.getSeriesAccessControl(seriesId);
            Option currentAcl = AccessInformationUtil.matchAclsLenient((List)acls, (AccessControlList)seriesAccessControl, this.adminUIConfiguration.getMatchManagedAclRolePrefixes());
            seriesAccessJson.put((Object)"current_acl", (Object)(currentAcl.isSome() ? ((ManagedAcl)currentAcl.get()).getId() : 0L));
            seriesAccessJson.put((Object)"privileges", (Object)AccessInformationUtil.serializePrivilegesByRole((AccessControlList)seriesAccessControl));
            seriesAccessJson.put((Object)"acl", (Object)EndpointUtil.transformAccessControList(seriesAccessControl, this.userDirectoryService));
            seriesAccessJson.put((Object)"locked", (Object)hasProcessingEvents);
        }
        catch (SeriesException e) {
            logger.error("Unable to get ACL from series {}", (Object)seriesId, (Object)e);
            return RestUtil.R.serverError();
        }
        JSONObject jsonReturnObj = new JSONObject();
        jsonReturnObj.put((Object)"system_acls", (Object)systemAclsJson);
        jsonReturnObj.put((Object)"series_access", (Object)seriesAccessJson);
        return Response.ok((Object)jsonReturnObj.toString()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{seriesId}/metadata.json")
    @RestQuery(name="getseriesmetadata", description="Returns the series metadata as JSON", returnDescription="Returns the series metadata as JSON", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The series metadata as JSON."), @RestResponse(responseCode=404, description="The series has not been found"), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response getSeriesMetadata(@PathParam(value="seriesId") String series) throws UnauthorizedException, NotFoundException, SearchIndexException {
        Optional optSeries = this.searchIndex.getSeries(series, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (optSeries.isEmpty()) {
            return RestUtils.notFound((String)"Cannot find a series with id '%s'.", (Object[])new Object[]{series});
        }
        MetadataList metadataList = new MetadataList();
        List catalogUIAdapters = this.indexService.getSeriesCatalogUIAdapters();
        catalogUIAdapters.remove(this.indexService.getCommonSeriesCatalogUIAdapter());
        for (SeriesCatalogUIAdapter adapter : catalogUIAdapters) {
            Opt optSeriesMetadata = adapter.getFields(series);
            if (!optSeriesMetadata.isSome()) continue;
            metadataList.add(adapter.getFlavor().toString(), adapter.getUITitle(), (DublinCoreMetadataCollection)optSeriesMetadata.get());
        }
        metadataList.add(this.indexService.getCommonSeriesCatalogUIAdapter(), this.getSeriesMetadata((Series)optSeries.get()));
        return RestUtils.okJson((JValue)MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
    }

    private DublinCoreMetadataCollection getSeriesMetadata(Series series) {
        DublinCoreMetadataCollection metadata = this.indexService.getCommonSeriesCatalogUIAdapter().getRawFields();
        MetadataField title = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_TITLE.getLocalName());
        metadata.removeField(title);
        MetadataField newTitle = new MetadataField(title);
        newTitle.setValue((Object)series.getTitle());
        metadata.addField(newTitle);
        MetadataField subject = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_SUBJECT.getLocalName());
        metadata.removeField(subject);
        MetadataField newSubject = new MetadataField(subject);
        newSubject.setValue((Object)series.getSubject());
        metadata.addField(newSubject);
        MetadataField description = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_DESCRIPTION.getLocalName());
        metadata.removeField(description);
        MetadataField newDescription = new MetadataField(description);
        newDescription.setValue((Object)series.getDescription());
        metadata.addField(newDescription);
        MetadataField language = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_LANGUAGE.getLocalName());
        metadata.removeField(language);
        MetadataField newLanguage = new MetadataField(language);
        newLanguage.setValue((Object)series.getLanguage());
        metadata.addField(newLanguage);
        MetadataField rightsHolder = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_RIGHTS_HOLDER.getLocalName());
        metadata.removeField(rightsHolder);
        MetadataField newRightsHolder = new MetadataField(rightsHolder);
        newRightsHolder.setValue((Object)series.getRightsHolder());
        metadata.addField(newRightsHolder);
        MetadataField license = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_LICENSE.getLocalName());
        metadata.removeField(license);
        MetadataField newLicense = new MetadataField(license);
        newLicense.setValue((Object)series.getLicense());
        metadata.addField(newLicense);
        MetadataField organizers = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_CREATOR.getLocalName());
        metadata.removeField(organizers);
        MetadataField newOrganizers = new MetadataField(organizers);
        newOrganizers.setValue((Object)series.getOrganizers());
        metadata.addField(newOrganizers);
        MetadataField contributors = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_CONTRIBUTOR.getLocalName());
        metadata.removeField(contributors);
        MetadataField newContributors = new MetadataField(contributors);
        newContributors.setValue((Object)series.getContributors());
        metadata.addField(newContributors);
        MetadataField publishers = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_PUBLISHER.getLocalName());
        metadata.removeField(publishers);
        MetadataField newPublishers = new MetadataField(publishers);
        newPublishers.setValue((Object)series.getPublishers());
        metadata.addField(newPublishers);
        MetadataField createdBy = new MetadataField("createdBy", null, "EVENTS.SERIES.DETAILS.METADATA.CREATED_BY", true, false, null, null, MetadataField.Type.TEXT, null, null, Integer.valueOf(9), null, null, null, null);
        createdBy.setValue((Object)series.getCreator());
        metadata.addField(createdBy);
        MetadataField uid = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_IDENTIFIER.getLocalName());
        metadata.removeField(uid);
        MetadataField newUID = new MetadataField(uid);
        newUID.setValue((Object)series.getIdentifier());
        metadata.addField(newUID);
        return metadata;
    }

    @PUT
    @Path(value="{seriesId}/metadata")
    @RestQuery(name="updateseriesmetadata", description="Update the series metadata with the one given JSON", returnDescription="Returns OK if the metadata have been saved.", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="metadata", isRequired=true, type=RestParameter.Type.TEXT, description="The list of metadata to update")}, responses={@RestResponse(responseCode=200, description="The series metadata as JSON."), @RestResponse(responseCode=404, description="The series has not been found"), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response updateSeriesMetadata(@PathParam(value="seriesId") String seriesID, @FormParam(value="metadata") String metadataJSON) throws UnauthorizedException, NotFoundException, SearchIndexException {
        try {
            MetadataList metadataList = this.indexService.updateAllSeriesMetadata(seriesID, metadataJSON, this.searchIndex);
            return RestUtils.okJson((JValue)MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (IndexServiceException e) {
            return RestUtil.R.serverError();
        }
    }

    @GET
    @Path(value="new/metadata")
    @RestQuery(name="getNewMetadata", description="Returns all the data related to the metadata tab in the new series modal as JSON", returnDescription="All the data related to the series metadata tab as JSON", responses={@RestResponse(responseCode=200, description="Returns all the data related to the series metadata tab as JSON")})
    public Response getNewMetadata() {
        MetadataList metadataList = this.indexService.getMetadataListWithAllSeriesCatalogUIAdapters();
        DublinCoreMetadataCollection metadataByAdapter = metadataList.getMetadataByAdapter(this.indexService.getCommonSeriesCatalogUIAdapter());
        if (metadataByAdapter != null) {
            DublinCoreMetadataCollection collection = metadataByAdapter;
            this.safelyRemoveField(collection, "identifier");
            metadataList.add(this.indexService.getCommonSeriesCatalogUIAdapter(), collection);
        }
        return RestUtils.okJson((JValue)MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
    }

    private void safelyRemoveField(DublinCoreMetadataCollection collection, String fieldName) {
        MetadataField metadataField = (MetadataField)collection.getOutputFields().get(fieldName);
        if (metadataField != null) {
            collection.removeField(metadataField);
        }
    }

    @GET
    @Path(value="new/themes")
    @RestQuery(name="getNewThemes", description="Returns all the data related to the themes tab in the new series modal as JSON", returnDescription="All the data related to the series themes tab as JSON", responses={@RestResponse(responseCode=200, description="Returns all the data related to the series themes tab as JSON")})
    public Response getNewThemes() {
        ThemeSearchQuery query = new ThemeSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
        query.withLimit(Integer.MAX_VALUE);
        query.withOffset(0);
        query.sortByName(SortCriterion.Order.Ascending);
        SearchResult results = null;
        try {
            results = this.searchIndex.getByQuery(query);
        }
        catch (SearchIndexException e) {
            logger.error("The admin UI Search Index was not able to get the themes", (Throwable)e);
            return RestUtil.R.serverError();
        }
        JSONObject themesJson = new JSONObject();
        for (SearchResultItem item : results.getItems()) {
            JSONObject themeInfoJson = new JSONObject();
            IndexTheme theme = (IndexTheme)item.getSource();
            themeInfoJson.put((Object)"name", (Object)theme.getName());
            themeInfoJson.put((Object)"description", (Object)theme.getDescription());
            themesJson.put((Object)theme.getIdentifier(), (Object)themeInfoJson);
        }
        return Response.ok((Object)themesJson.toJSONString()).build();
    }

    private TobiraService getTobira() {
        return TobiraService.getTobira(this.securityService.getOrganization().getId());
    }

    @GET
    @Path(value="new/tobira/page")
    @Produces(value={"application/json"})
    @RestQuery(name="getTobiraPage", description="Returns data about the page tree of a connected Tobira instance for use in the series creation wizard", returnDescription="Information about a given page in Tobira, and its direct children", restParameters={@RestParameter(name="path", isRequired=true, type=RestParameter.Type.STRING, description="The path of the page you want information about")}, responses={@RestResponse(responseCode=200, description="Data about the given page in Tobira. Note that this does not mean the page exists!"), @RestResponse(responseCode=404, description="Nonexistent `path`"), @RestResponse(responseCode=400, description="missing `path`"), @RestResponse(responseCode=503, description="Tobira is not configured (correctly)")})
    public Response getTobiraPage(@QueryParam(value="path") String path) throws IOException, InterruptedException {
        if (path == null) {
            throw new WebApplicationException("`path` missing", Response.Status.BAD_REQUEST);
        }
        TobiraService tobira = this.getTobira();
        if (!tobira.ready()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Tobira is not configured (correctly)").build();
        }
        try {
            JSONObject page = (JSONObject)tobira.getPage(path).get((Object)"page");
            if (page == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return Response.ok((Object)page.toJSONString()).build();
        }
        catch (TobiraException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="new")
    @RestQuery(name="createNewSeries", description="Creates a new series by the given metadata as JSON", returnDescription="The created series id", restParameters={@RestParameter(name="metadata", isRequired=true, description="The metadata as JSON", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=201, description="Returns the created series id"), @RestResponse(responseCode=400, description="he request could not be fulfilled due to the incorrect syntax of the request"), @RestResponse(responseCode=401, description="If user doesn't have rights to create the series")})
    public Response createNewSeries(@FormParam(value="metadata") String metadata) throws UnauthorizedException {
        try {
            JSONObject metadataJson;
            try {
                metadataJson = (JSONObject)new JSONParser().parse(metadata);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse metadata " + metadata, e);
            }
            if (metadataJson == null) {
                throw new IllegalArgumentException("No metadata set to create series");
            }
            String seriesId = this.indexService.createSeries(metadataJson);
            boolean mounted = this.mountSeriesInTobira(seriesId, metadataJson);
            JSONObject responseObject = new JSONObject();
            responseObject.put((Object)"id", (Object)seriesId);
            responseObject.put((Object)"mounted", (Object)mounted);
            return Response.created((URI)URI.create(UrlSupport.concat((String[])new String[]{this.serverUrl, "admin-ng/series/", seriesId, "metadata.json"}))).entity((Object)responseObject.toString()).build();
        }
        catch (IllegalArgumentException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (IndexServiceException e) {
            return RestUtil.R.serverError();
        }
    }

    private boolean mountSeriesInTobira(String seriesId, JSONObject params) {
        TobiraService tobira = this.getTobira();
        if (!tobira.ready()) {
            return false;
        }
        Object tobiraParams = params.get((Object)"tobira");
        if (tobiraParams == null) {
            return false;
        }
        if (!(tobiraParams instanceof JSONObject)) {
            return false;
        }
        JSONObject tobiraParamsObject = (JSONObject)tobiraParams;
        JSONArray metadataCatalogs = (JSONArray)params.get((Object)"metadata");
        JSONObject firstCatalog = (JSONObject)metadataCatalogs.get(0);
        List metadataFields = (List)firstCatalog.get((Object)"fields");
        String title = metadataFields.stream().filter(field -> field.get((Object)"id").equals("title")).findAny().map(field -> field.get((Object)"value")).map(String.class::cast).get();
        JSONObject series = new JSONObject(Map.of("opencastId", seriesId, "title", title));
        tobiraParamsObject.put((Object)"series", (Object)series);
        try {
            tobira.mount((Map<String, Object>)tobiraParamsObject);
        }
        catch (TobiraException e) {
            return false;
        }
        return true;
    }

    @DELETE
    @Path(value="{seriesId}")
    @Produces(value={"application/json"})
    @RestQuery(name="deleteseries", description="Delete a series.", returnDescription="Ok if the series has been deleted.", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The id of the series to delete.", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The series has been deleted."), @RestResponse(responseCode=404, description="The series could not be found.")})
    public Response deleteSeries(@PathParam(value="seriesId") String id) throws NotFoundException {
        try {
            this.indexService.removeSeries(id);
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to delete the series '{}' due to", (Object)id, (Object)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="deleteSeries")
    @Produces(value={"application/json"})
    @RestQuery(name="deletemultipleseries", description="Deletes a json list of series by their given ids e.g. [\"Series-1\", \"Series-2\"]", returnDescription="A JSON object with arrays that show whether a series was deleted, was not found or there was an error deleting it.", responses={@RestResponse(description="Series have been deleted", responseCode=200), @RestResponse(description="The list of ids could not be parsed into a json list.", responseCode=400)})
    public Response deleteMultipleSeries(String seriesIdsContent) throws NotFoundException {
        JSONArray seriesIdsArray;
        if (StringUtils.isBlank((CharSequence)seriesIdsContent)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        JSONParser parser = new JSONParser();
        try {
            seriesIdsArray = (JSONArray)parser.parse(seriesIdsContent);
        }
        catch (ParseException e) {
            logger.error("Unable to parse '{}'", (Object)seriesIdsContent, (Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ClassCastException e) {
            logger.error("Unable to cast '{}' to a JSON array", (Object)seriesIdsContent, (Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        BulkOperationResult result = new BulkOperationResult();
        for (Object seriesId : seriesIdsArray) {
            try {
                this.indexService.removeSeries(seriesId.toString());
                result.addOk(seriesId.toString());
            }
            catch (NotFoundException e) {
                result.addNotFound(seriesId.toString());
            }
            catch (Exception e) {
                logger.error("Unable to remove the series '{}'", (Object)seriesId.toString(), (Object)e);
                result.addServerError(seriesId.toString());
            }
        }
        return Response.ok((Object)result.toJson()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="series.json")
    @RestQuery(name="listSeriesAsJson", description="Returns the series matching the query parameters", returnDescription="Returns the series search results as JSON", restParameters={@RestParameter(name="sortorganizer", isRequired=false, description="The sort type to apply to the series organizer or organizers either Ascending or Descending.", type=RestParameter.Type.STRING), @RestParameter(name="sort", description="The order instructions used to sort the query result. Must be in the form '<field name>:(ASC|DESC)'", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="filter", isRequired=false, description="The filter used for the query. They should be formated like that: 'filter1:value1,filter2,value2'", type=RestParameter.Type.STRING), @RestParameter(name="offset", isRequired=false, description="The page offset", type=RestParameter.Type.INTEGER, defaultValue="0"), @RestParameter(name="limit", isRequired=false, description="The limit to define the number of returned results (-1 for all)", type=RestParameter.Type.INTEGER, defaultValue="100")}, responses={@RestResponse(responseCode=200, description="The access control list."), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response getSeries(@QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) throws UnauthorizedException {
        try {
            logger.debug("Requested series list");
            SeriesSearchQuery query = new SeriesSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
            Option optSort = Option.option((Object)StringUtils.trimToNull((String)sort));
            if (offset != 0) {
                query.withOffset(offset);
            }
            query.withLimit(limit == 0 ? 100 : limit);
            Map filters = RestUtils.parseFilter((String)filter);
            for (Object name : filters.keySet()) {
                if ("managedAcl".equals(name)) {
                    query.withManagedAcl((String)filters.get(name));
                    continue;
                }
                if ("contributors".equals(name)) {
                    query.withContributor((String)filters.get(name));
                    continue;
                }
                if ("CreationDate".equals(name)) {
                    try {
                        Tuple fromAndToCreationRange = RestUtils.getFromAndToDateRange((String)((String)filters.get(name)));
                        query.withCreatedFrom((Date)fromAndToCreationRange.getA());
                        query.withCreatedTo((Date)fromAndToCreationRange.getB());
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        return RestUtil.R.badRequest((String)e.getMessage());
                    }
                }
                if ("Creator".equals(name)) {
                    query.withCreator((String)filters.get(name));
                    continue;
                }
                if ("textFilter".equals(name)) {
                    query.withText((String)filters.get(name));
                    continue;
                }
                if ("language".equals(name)) {
                    query.withLanguage((String)filters.get(name));
                    continue;
                }
                if ("license".equals(name)) {
                    query.withLicense((String)filters.get(name));
                    continue;
                }
                if ("organizers".equals(name)) {
                    query.withOrganizer((String)filters.get(name));
                    continue;
                }
                if ("subject".equals(name)) {
                    query.withSubject((String)filters.get(name));
                    continue;
                }
                if (!"title".equals(name)) continue;
                query.withTitle((String)filters.get(name));
            }
            if (optSort.isSome()) {
                ArrayList sortCriteria = RestUtils.parseSortQueryParameter((String)((String)optSort.get()));
                block19: for (SortCriterion criterion : sortCriteria) {
                    switch (criterion.getFieldName()) {
                        case "title": {
                            query.sortByTitle(criterion.getOrder());
                            continue block19;
                        }
                        case "contributors": {
                            query.sortByContributors(criterion.getOrder());
                            continue block19;
                        }
                        case "organizers": {
                            query.sortByOrganizers(criterion.getOrder());
                            continue block19;
                        }
                        case "createdDateTime": {
                            query.sortByCreatedDateTime(criterion.getOrder());
                            continue block19;
                        }
                        case "managed_acl": {
                            query.sortByManagedAcl(criterion.getOrder());
                            continue block19;
                        }
                    }
                    logger.info("Unknown filter criteria {}", (Object)criterion.getFieldName());
                    return Response.status((int)400).build();
                }
            }
            if (this.onlySeriesWithWriteAccessSeriesTab.booleanValue()) {
                query.withoutActions();
                query.withAction(Permissions.Action.WRITE);
                query.withAction(Permissions.Action.READ);
            }
            logger.trace("Using Query: " + query.toString());
            SearchResult result = this.searchIndex.getByQuery(query);
            if (logger.isDebugEnabled()) {
                logger.debug("Found {} results in {} ms", (Object)result.getDocumentCount(), (Object)result.getSearchTime());
            }
            ArrayList<JObject> series = new ArrayList<JObject>();
            for (SearchResultItem item : result.getItems()) {
                ArrayList<Field> fields = new ArrayList<Field>();
                Series s = (Series)item.getSource();
                String sId = s.getIdentifier();
                fields.add(Jsons.f((String)"id", (JValue)Jsons.v((String)sId)));
                fields.add(Jsons.f((String)"title", (JValue)Jsons.v((Object)s.getTitle(), (JValue)Jsons.BLANK)));
                fields.add(Jsons.f((String)"organizers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getOrganizers()).map(Jsons.Functions.stringToJValue))));
                fields.add(Jsons.f((String)"contributors", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getContributors()).map(Jsons.Functions.stringToJValue))));
                if (s.getCreator() != null) {
                    fields.add(Jsons.f((String)"createdBy", (JValue)Jsons.v((String)s.getCreator())));
                }
                if (s.getCreatedDateTime() != null) {
                    fields.add(Jsons.f((String)"creation_date", (JValue)Jsons.v((Object)DateTimeSupport.toUTC((long)s.getCreatedDateTime().getTime()), (JValue)Jsons.BLANK)));
                }
                if (s.getLanguage() != null) {
                    fields.add(Jsons.f((String)"language", (JValue)Jsons.v((String)s.getLanguage())));
                }
                if (s.getLicense() != null) {
                    fields.add(Jsons.f((String)"license", (JValue)Jsons.v((String)s.getLicense())));
                }
                if (s.getRightsHolder() != null) {
                    fields.add(Jsons.f((String)"rightsHolder", (JValue)Jsons.v((String)s.getRightsHolder())));
                }
                if (StringUtils.isNotBlank((CharSequence)s.getManagedAcl())) {
                    fields.add(Jsons.f((String)"managedAcl", (JValue)Jsons.v((String)s.getManagedAcl())));
                }
                series.add(Jsons.obj(fields));
            }
            logger.debug("Request done");
            return RestUtils.okJsonList(series, (int)offset, (int)limit, (long)result.getHitCount());
        }
        catch (Exception e) {
            logger.warn("Could not perform search query", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Map<String, String> getUserSeriesByAccess(boolean writeAccess) {
        SeriesListQuery query = new SeriesListQuery();
        if (writeAccess) {
            query.withoutPermissions();
            query.withReadPermission(true);
            query.withWritePermission(true);
        }
        try {
            return this.listProvidersService.getList("SERIES", (ResourceListQuery)query, true);
        }
        catch (ListProviderException e) {
            logger.warn("Could not perform search query.", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}/properties")
    @RestQuery(name="getSeriesProperties", description="Returns the series properties", returnDescription="Returns the series properties as JSON", pathParameters={@RestParameter(name="id", description="ID of series", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The access control list."), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response getSeriesPropertiesAsJson(@PathParam(value="id") String seriesId) throws UnauthorizedException, NotFoundException {
        if (StringUtils.isBlank((CharSequence)seriesId)) {
            logger.warn("Series id parameter is blank '{}'.", (Object)seriesId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Map properties = this.seriesService.getSeriesProperties(seriesId);
            JSONArray jsonProperties = new JSONArray();
            for (String name : properties.keySet()) {
                JSONObject property = new JSONObject();
                property.put((Object)name, properties.get(name));
                jsonProperties.add((Object)property);
            }
            return Response.ok((Object)jsonProperties.toString()).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not perform search query: {}", (Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{seriesId}/property/{propertyName}.json")
    @RestQuery(name="getSeriesProperty", description="Returns a series property value", returnDescription="Returns the series property value", pathParameters={@RestParameter(name="seriesId", description="ID of series", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="propertyName", description="Name of series property", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The access control list."), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response getSeriesProperty(@PathParam(value="seriesId") String seriesId, @PathParam(value="propertyName") String propertyName) throws UnauthorizedException, NotFoundException {
        if (StringUtils.isBlank((CharSequence)seriesId)) {
            logger.warn("Series id parameter is blank '{}'.", (Object)seriesId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            logger.warn("Series property name parameter is blank '{}'.", (Object)propertyName);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            String propertyValue = this.seriesService.getSeriesProperty(seriesId, propertyName);
            return Response.ok((Object)propertyValue).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not perform search query", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/{seriesId}/property")
    @RestQuery(name="updateSeriesProperty", description="Updates a series property", returnDescription="No content.", restParameters={@RestParameter(name="name", isRequired=true, description="The property's name", type=RestParameter.Type.TEXT), @RestParameter(name="value", isRequired=true, description="The property's value", type=RestParameter.Type.TEXT)}, pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=404, description="No series with this identifier was found."), @RestResponse(responseCode=204, description="The access control list has been updated."), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action"), @RestResponse(responseCode=400, description="The required path or form params were missing in the request.")})
    public Response updateSeriesProperty(@PathParam(value="seriesId") String seriesId, @FormParam(value="name") String name, @FormParam(value="value") String value) throws UnauthorizedException {
        if (StringUtils.isBlank((CharSequence)seriesId)) {
            logger.warn("Series id parameter is blank '{}'.", (Object)seriesId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            logger.warn("Name parameter is blank '{}'.", (Object)name);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            logger.warn("Series id parameter is blank '{}'.", (Object)value);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.seriesService.updateSeriesProperty(seriesId, name, value);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (SeriesException e) {
            logger.warn("Could not update series property for series {} property {}:{}", new Object[]{seriesId, name, value, e});
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{seriesId}/property/{propertyName}")
    @RestQuery(name="deleteSeriesProperty", description="Deletes a series property", returnDescription="No Content", pathParameters={@RestParameter(name="seriesId", description="ID of series", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="propertyName", description="Name of series property", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=204, description="The series property has been deleted."), @RestResponse(responseCode=404, description="The series or property has not been found."), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response deleteSeriesProperty(@PathParam(value="seriesId") String seriesId, @PathParam(value="propertyName") String propertyName) throws UnauthorizedException, NotFoundException {
        if (StringUtils.isBlank((CharSequence)seriesId)) {
            logger.warn("Series id parameter is blank '{}'.", (Object)seriesId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            logger.warn("Series property name parameter is blank '{}'.", (Object)propertyName);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.seriesService.deleteSeriesProperty(seriesId, propertyName);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not delete series '{}' property '{}' query", new Object[]{seriesId, propertyName, e});
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response getSimpleThemeJsonResponse(IndexTheme theme) {
        return RestUtils.okJson((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)Long.toString(theme.getIdentifier()), (JValue)Jsons.v((String)theme.getName()))}));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{seriesId}/theme.json")
    @RestQuery(name="getSeriesTheme", description="Returns the series theme id and name as JSON", returnDescription="Returns the series theme name and id as JSON", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The series theme id and name as JSON."), @RestResponse(responseCode=404, description="The series or theme has not been found")})
    public Response getSeriesTheme(@PathParam(value="seriesId") String seriesId) {
        Long themeId;
        try {
            Optional series = this.searchIndex.getSeries(seriesId, this.securityService.getOrganization().getId(), this.securityService.getUser());
            if (series.isEmpty()) {
                return RestUtils.notFound((String)"Cannot find a series with id {}", (Object[])new Object[]{seriesId});
            }
            themeId = ((Series)series.get()).getTheme();
        }
        catch (SearchIndexException e) {
            logger.error("Unable to get series {}", (Object)seriesId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
        if (themeId == null) {
            return RestUtils.okJson((JValue)Jsons.obj());
        }
        try {
            Opt<IndexTheme> themeOpt = this.getTheme(themeId);
            if (themeOpt.isNone()) {
                return RestUtils.notFound((String)"Cannot find a theme with id {}", (Object[])new Object[]{themeId});
            }
            return this.getSimpleThemeJsonResponse((IndexTheme)themeOpt.get());
        }
        catch (SearchIndexException e) {
            logger.error("Unable to get theme {}", (Object)themeId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{seriesId}/theme")
    @RestQuery(name="updateSeriesTheme", description="Update the series theme id", returnDescription="Returns the id and name of the theme.", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="themeId", isRequired=true, type=RestParameter.Type.INTEGER, description="The id of the theme for this series")}, responses={@RestResponse(responseCode=200, description="The series theme has been updated and the theme id and name are returned as JSON."), @RestResponse(responseCode=404, description="The series or theme has not been found"), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response updateSeriesTheme(@PathParam(value="seriesId") String seriesID, @FormParam(value="themeId") long themeId) throws UnauthorizedException, NotFoundException {
        try {
            Opt<IndexTheme> themeOpt = this.getTheme(themeId);
            if (themeOpt.isNone()) {
                return RestUtils.notFound((String)"Cannot find a theme with id {}", (Object[])new Object[]{themeId});
            }
            this.seriesService.updateSeriesProperty(seriesID, THEME_KEY, Long.toString(themeId));
            return this.getSimpleThemeJsonResponse((IndexTheme)themeOpt.get());
        }
        catch (SeriesException e) {
            logger.error("Unable to update series theme {}", (Object)themeId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
        catch (SearchIndexException e) {
            logger.error("Unable to get theme {}", (Object)themeId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="{seriesId}/theme")
    @RestQuery(name="deleteSeriesTheme", description="Removes the theme from the series", returnDescription="Returns no content", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=204, description="The series theme has been removed"), @RestResponse(responseCode=404, description="The series has not been found"), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response deleteSeriesTheme(@PathParam(value="seriesId") String seriesID) throws UnauthorizedException, NotFoundException {
        try {
            this.seriesService.deleteSeriesProperty(seriesID, THEME_KEY);
            return Response.noContent().build();
        }
        catch (SeriesException e) {
            logger.error("Unable to remove theme from series {}", (Object)seriesID, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{seriesId}/tobira/pages")
    @RestQuery(name="getSeriesHostPages", description="Returns the pages of a connected Tobira instance that contain the given series", returnDescription="The Tobira pages that contain the given series", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The Tobira pages containing the given series"), @RestResponse(responseCode=404, description="Tobira doesn't know about the given series"), @RestResponse(responseCode=503, description="Tobira is not configured (correctly)")})
    public Response getSeriesHostPages(@PathParam(value="seriesId") String seriesId) {
        TobiraService tobira = this.getTobira();
        if (!tobira.ready()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Tobira is not configured (correctly)").build();
        }
        try {
            JSONObject seriesData = tobira.getHostPages(seriesId);
            if (seriesData == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            seriesData.put((Object)"baseURL", (Object)tobira.getOrigin());
            return Response.ok((Object)seriesData.toJSONString()).build();
        }
        catch (TobiraException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="{seriesId}/tobira/path")
    @RestQuery(name="updateSeriesTobiraPath", description="Updates the path of the given series in a connected Tobira instance", returnDescription="Status code", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series id", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="pathComponents", isRequired=true, description="List of realms with name and path segment on path to series.", type=RestParameter.Type.TEXT), @RestParameter(name="currentPath", isRequired=false, description="Path where the series is currently mounted.", type=RestParameter.Type.STRING), @RestParameter(name="targetPath", isRequired=true, description="Path where the series will be mounted.", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The path of the series has successfully been updated in Tobira."), @RestResponse(responseCode=404, description="Tobira doesn't know about the given series"), @RestResponse(responseCode=503, description="Tobira is not configured (correctly)")})
    public Response updateSeriesTobiraPath(@PathParam(value="seriesId") String seriesId, @FormParam(value="pathComponents") String pathComponents, @FormParam(value="currentPath") String currentPath, @FormParam(value="targetPath") String targetPath) throws IOException, InterruptedException {
        if (targetPath == null) {
            throw new WebApplicationException("target path is missing", Response.Status.BAD_REQUEST);
        }
        TobiraService tobira = this.getTobira();
        if (!tobira.ready()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Tobira is not configured (correctly)").build();
        }
        try {
            List paths = (List)new JSONParser().parse(pathComponents);
            JSONObject mountParams = new JSONObject();
            mountParams.put((Object)"seriesId", (Object)seriesId);
            mountParams.put((Object)"targetPath", (Object)targetPath);
            tobira.createRealmLineage(paths);
            tobira.addSeriesMountPoint((Map<String, Object>)mountParams);
            if (currentPath != null && !currentPath.trim().isEmpty()) {
                JSONObject unmountParams = new JSONObject();
                unmountParams.put((Object)"seriesId", (Object)seriesId);
                unmountParams.put((Object)"currentPath", (Object)currentPath);
                tobira.removeSeriesMountPoint((Map<String, Object>)unmountParams);
            }
            return RestUtil.R.ok();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Internal server error: " + e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="{seriesId}/tobira/{currentPath}")
    @RestQuery(name="removeSeriesTobiraPath", description="Removes the path of the given series in a connected Tobira instance", returnDescription="Status code", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series id", type=RestParameter.Type.STRING), @RestParameter(name="currentPath", isRequired=true, description="URL encoded path where the series is currently mounted.", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The path of the series has successfully been removed in Tobira."), @RestResponse(responseCode=404, description="Tobira doesn't know about the given series"), @RestResponse(responseCode=503, description="Tobira is not configured (correctly)")})
    public Response removeSeriesTobiraPath(@PathParam(value="seriesId") String seriesId, @PathParam(value="currentPath") String currentPath) throws IOException, InterruptedException {
        TobiraService tobira = this.getTobira();
        if (!tobira.ready()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Tobira is not configured (correctly)").build();
        }
        try {
            if (currentPath != null && !currentPath.trim().isEmpty()) {
                JSONObject unmountParams = new JSONObject();
                unmountParams.put((Object)"seriesId", (Object)seriesId);
                unmountParams.put((Object)"currentPath", (Object)currentPath);
                tobira.removeSeriesMountPoint((Map<String, Object>)unmountParams);
            }
            return RestUtil.R.ok();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Internal server error: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/{seriesId}/access")
    @RestQuery(name="applyAclToSeries", description="Immediate application of an ACL to a series", returnDescription="Status code", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series ID", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="acl", isRequired=true, description="The ACL to apply", type=RestParameter.Type.STRING), @RestParameter(name="override", isRequired=false, defaultValue="false", description="If true the series ACL will take precedence over any existing episode ACL", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(responseCode=200, description="The ACL has been successfully applied"), @RestResponse(responseCode=400, description="Unable to parse the given ACL"), @RestResponse(responseCode=404, description="The series has not been found"), @RestResponse(responseCode=500, description="Internal error"), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response applyAclToSeries(@PathParam(value="seriesId") String seriesId, @FormParam(value="acl") String acl, @DefaultValue(value="false") @FormParam(value="override") boolean override) throws SearchIndexException {
        AccessControlList accessControlList;
        try {
            accessControlList = AccessControlParser.parseAcl((String)acl);
        }
        catch (Exception e) {
            logger.warn("Unable to parse ACL '{}'", (Object)acl);
            return RestUtil.R.badRequest();
        }
        if (!accessControlList.isValid()) {
            logger.debug("POST api/series/{}/access: Invalid series ACL detected", (Object)seriesId);
            return RestUtil.R.badRequest();
        }
        Optional series = this.searchIndex.getSeries(seriesId, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (series.isEmpty()) {
            return RestUtils.notFound((String)"Cannot find a series with id {}", (Object[])new Object[]{seriesId});
        }
        if (this.hasProcessingEvents(seriesId)) {
            logger.warn("Can not update the ACL from series {}. Events being part of the series are currently processed.", (Object)seriesId);
            return RestUtil.R.conflict();
        }
        try {
            this.seriesService.updateAccessControl(seriesId, accessControlList, override);
            return RestUtil.R.ok();
        }
        catch (NotFoundException e) {
            logger.warn("Unable to find series '{}' to apply the ACL.", (Object)seriesId);
            return RestUtil.R.notFound();
        }
        catch (UnauthorizedException e) {
            return RestUtil.R.forbidden();
        }
        catch (SeriesException e) {
            logger.error("Error applying acl to series {}", (Object)seriesId);
            return RestUtil.R.serverError();
        }
    }

    private boolean hasProcessingEvents(String seriesId) {
        SearchResult events;
        EventSearchQuery query = new EventSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
        long elementsCount = 0L;
        query.withSeriesId(seriesId);
        try {
            query.withWorkflowState(WorkflowInstance.WorkflowState.RUNNING.toString());
            events = this.searchIndex.getByQuery(query);
            elementsCount = events.getHitCount();
            query.withWorkflowState(WorkflowInstance.WorkflowState.INSTANTIATED.toString());
            events = this.searchIndex.getByQuery(query);
        }
        catch (SearchIndexException e) {
            logger.warn("Could not perform search query", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return (elementsCount += events.getHitCount()) > 0L;
    }

    @GET
    @Path(value="{seriesId}/hasEvents.json")
    @Produces(value={"application/json"})
    @RestQuery(name="hasEvents", description="Check if given series has events", returnDescription="true if series has events, otherwise false", pathParameters={@RestParameter(name="seriesId", isRequired=true, description="The series identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=400, description="The required form params were missing in the request."), @RestResponse(responseCode=404, description="If the series has not been found."), @RestResponse(responseCode=200, description="The access information ")})
    public Response getSeriesEvents(@PathParam(value="seriesId") String seriesId) throws Exception {
        if (StringUtils.isBlank((CharSequence)seriesId)) {
            return RestUtil.R.badRequest((String)"Path parameter series ID is missing");
        }
        long elementsCount = 0L;
        try {
            EventSearchQuery query = new EventSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
            query.withSeriesId(seriesId);
            SearchResult result = this.searchIndex.getByQuery(query);
            elementsCount = result.getHitCount();
        }
        catch (SearchIndexException e) {
            logger.warn("Could not perform search query", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        JSONObject jsonReturnObj = new JSONObject();
        jsonReturnObj.put((Object)"hasEvents", (Object)(elementsCount > 0L ? 1 : 0));
        return Response.ok((Object)jsonReturnObj.toString()).build();
    }

    private Opt<IndexTheme> getTheme(long id) throws SearchIndexException {
        SearchResult result = this.searchIndex.getByQuery(new ThemeSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser()).withIdentifier(id));
        if (result.getPageSize() == 0L) {
            logger.debug("Didn't find theme with id {}", (Object)id);
            return Opt.none();
        }
        return Opt.some((Object)((IndexTheme)result.getItems()[0].getSource()));
    }

    @GET
    @Path(value="configuration.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getseriesconfiguration", description="Get the series configuration", returnDescription="List of configuration keys", responses={@RestResponse(responseCode=400, description="The required form params were missing in the request."), @RestResponse(responseCode=404, description="If the series has not been found."), @RestResponse(responseCode=200, description="The access information ")})
    public Response getSeriesOptions() {
        JSONObject jsonReturnObj = new JSONObject();
        jsonReturnObj.put((Object)"deleteSeriesWithEventsAllowed", (Object)this.deleteSeriesWithEventsAllowed);
        return Response.ok((Object)jsonReturnObj.toString()).build();
    }

    public Boolean getOnlySeriesWithWriteAccessSeriesTab() {
        return this.onlySeriesWithWriteAccessSeriesTab;
    }

    public Boolean getOnlySeriesWithWriteAccessEventsFilter() {
        return this.onlySeriesWithWriteAccessEventsFilter;
    }
}

