/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.adminui.util.TextFilter;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.SmartIterator;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/capture-agents")
@RestService(name="captureAgents", title="Capture agents fa\u00e7ade service", abstractText="Provides operations for the capture agents", notes={"This service offers the default capture agents CRUD Operations for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={CaptureAgentsEndpoint.class}, property={"service.description=Admin UI - Capture agents facade Endpoint", "opencast.service.type=org.opencastproject.adminui.endpoint.UsersEndpoint", "opencast.service.path=/admin-ng/capture-agents"})
@JaxrsResource
public class CaptureAgentsEndpoint {
    private static final String TRANSLATION_KEY_PREFIX = "CAPTURE_AGENT.DEVICE.";
    private static final Logger logger = LoggerFactory.getLogger(CaptureAgentsEndpoint.class);
    private CaptureAgentStateService service;
    private SecurityService securityService;

    @Reference
    public void setCaptureAgentService(CaptureAgentStateService service) {
        this.service = service;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="agents.json")
    @RestQuery(name="getAgents", description="Return all of the known capture agents on the system", restParameters={@RestParameter(name="filter", isRequired=false, description="The filter used for the query. They should be formated like that: 'filter1:value1,filter2:value2'", type=RestParameter.Type.STRING), @RestParameter(defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, name="limit", type=RestParameter.Type.STRING), @RestParameter(defaultValue="0", description="The page number.", isRequired=false, name="offset", type=RestParameter.Type.STRING), @RestParameter(defaultValue="false", description="Define if the inputs should or not returned with the capture agent.", isRequired=false, name="inputs", type=RestParameter.Type.BOOLEAN), @RestParameter(name="sort", isRequired=false, description="The sort order. May include any of the following: STATUS, NAME OR LAST_UPDATED.  Add '_DESC' to reverse the sort order (e.g. STATUS_DESC).", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="An XML representation of the agent capabilities", responseCode=200)}, returnDescription="")
    public Response getAgents(@QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset, @QueryParam(value="inputs") boolean inputs, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort) {
        Option filterName = Option.none();
        Option filterStatus = Option.none();
        Option filterLastUpdated = Option.none();
        Option filterText = Option.none();
        Option optSort = Option.option((Object)StringUtils.trimToNull((String)sort));
        Map filters = RestUtils.parseFilter((String)filter);
        for (Object name : filters.keySet()) {
            if ("Name".equals(name)) {
                filterName = Option.some((Object)((String)filters.get(name)));
            }
            if ("Status".equals(name)) {
                filterStatus = Option.some((Object)((String)filters.get(name)));
            }
            if ("LastUpdated".equals(name)) {
                try {
                    filterLastUpdated = Option.some((Object)Long.parseLong((String)filters.get(name)));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info("Unable to parse long {}", filters.get(name));
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            if (!"textFilter".equals(name) || !StringUtils.isNotBlank((CharSequence)((CharSequence)filters.get(name)))) continue;
            filterText = Option.some((Object)((String)filters.get(name)));
        }
        List<Agent> filteredAgents = new ArrayList();
        for (Map.Entry entry : this.service.getKnownAgents().entrySet()) {
            Agent agent = (Agent)entry.getValue();
            if (filterName.isSome() && !((String)filterName.get()).equals(agent.getName()) || filterStatus.isSome() && !((String)filterStatus.get()).equals(agent.getState()) || filterLastUpdated.isSome() && filterLastUpdated.get() != agent.getLastHeardFrom() || filterText.isSome() && !TextFilter.match((String)filterText.get(), agent.getName(), agent.getState())) continue;
            filteredAgents.add(agent);
        }
        int total = filteredAgents.size();
        if (optSort.isSome()) {
            final ArrayList arrayList = RestUtils.parseSortQueryParameter((String)((String)optSort.get()));
            Collections.sort(filteredAgents, new Comparator<Agent>(){

                @Override
                public int compare(Agent agent1, Agent agent2) {
                    Iterator iterator = arrayList.iterator();
                    if (iterator.hasNext()) {
                        SortCriterion criterion = (SortCriterion)iterator.next();
                        SortCriterion.Order order = criterion.getOrder();
                        switch (criterion.getFieldName()) {
                            case "status": {
                                if (order.equals((Object)SortCriterion.Order.Descending)) {
                                    return agent2.getState().compareTo(agent1.getState());
                                }
                                return agent1.getState().compareTo(agent2.getState());
                            }
                            case "name": {
                                if (order.equals((Object)SortCriterion.Order.Descending)) {
                                    return agent2.getName().compareTo(agent1.getName());
                                }
                                return agent1.getName().compareTo(agent2.getName());
                            }
                            case "updated": {
                                if (order.equals((Object)SortCriterion.Order.Descending)) {
                                    return agent2.getLastHeardFrom().compareTo(agent1.getLastHeardFrom());
                                }
                                return agent1.getLastHeardFrom().compareTo(agent2.getLastHeardFrom());
                            }
                        }
                        logger.info("Unknown sort type: {}", (Object)criterion.getFieldName());
                        return 0;
                    }
                    return 0;
                }
            });
        }
        filteredAgents = new SmartIterator(limit, offset).applyLimitAndOffset(filteredAgents);
        ArrayList<JValue> arrayList = new ArrayList<JValue>();
        for (Agent agent : filteredAgents) {
            arrayList.add(this.generateJsonAgent(agent, inputs, false));
        }
        return RestUtils.okJsonList(arrayList, (int)offset, (int)limit, (long)total);
    }

    @DELETE
    @Path(value="{name}")
    @Produces(value={"application/json"})
    @RestQuery(name="removeAgent", description="Remove record of a given capture agent", pathParameters={@RestParameter(name="name", description="The name of a given capture agent", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="{agentName} removed", responseCode=200), @RestResponse(description="The agent {agentname} does not exist", responseCode=404)}, returnDescription="")
    public Response removeAgent(@PathParam(value="name") String agentName) throws NotFoundException, UnauthorizedException {
        if (this.service == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
        }
        SecurityUtil.checkAgentAccess((SecurityService)this.securityService, (String)agentName);
        this.service.removeAgent(agentName);
        logger.debug("The agent {} was successfully removed", (Object)agentName);
        return Response.status((int)200).build();
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    @RestQuery(name="getAgent", description="Return the capture agent including its configuration and capabilities", pathParameters={@RestParameter(description="Name of the capture agent", isRequired=true, name="name", type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="A JSON representation of the capture agent", responseCode=200), @RestResponse(description="The agent {name} does not exist in the system", responseCode=404)}, returnDescription="")
    public Response getAgent(@PathParam(value="name") String agentName) throws NotFoundException {
        if (this.service != null) {
            Agent agent = this.service.getAgent(agentName);
            if (agent != null) {
                return RestUtils.okJson((JValue)this.generateJsonAgent(agent, true, true));
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
    }

    private JValue generateJsonAgent(Agent agent, boolean withInputs, boolean details) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"Status", (JValue)Jsons.v((Object)("AGENTS.STATUS." + agent.getState().toUpperCase()), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"Name", (JValue)Jsons.v((String)agent.getName())));
        fields.add(Jsons.f((String)"Update", (JValue)Jsons.v((Object)DateTimeSupport.toUTC((long)agent.getLastHeardFrom()), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"URL", (JValue)Jsons.v((Object)agent.getUrl(), (JValue)Jsons.BLANK)));
        if (withInputs) {
            String devices = (String)agent.getCapabilities().get("capture.device.names");
            fields.add(Jsons.f((String)"inputs", (JValue)(StringUtils.isEmpty((CharSequence)devices) ? Jsons.arr() : this.generateJsonDevice(devices.split(",")))));
        }
        if (details) {
            fields.add(Jsons.f((String)"configuration", (JValue)this.generateJsonProperties(agent.getConfiguration())));
            fields.add(Jsons.f((String)"capabilities", (JValue)this.generateJsonProperties(agent.getCapabilities())));
        }
        return Jsons.obj(fields);
    }

    private JValue generateJsonProperties(Properties properties) {
        ArrayList<JObject> fields = new ArrayList<JObject>();
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                fields.add(Jsons.obj((Field[])new Field[]{Jsons.f((String)"key", (JValue)Jsons.v((String)key)), Jsons.f((String)"value", (JValue)Jsons.v((String)properties.getProperty(key)))}));
            }
        }
        return Jsons.arr(fields);
    }

    private JValue generateJsonDevice(String[] devices) {
        ArrayList<JObject> jsonDevices = new ArrayList<JObject>();
        for (String device : devices) {
            jsonDevices.add(Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((String)device)), Jsons.f((String)"value", (JValue)Jsons.v((String)(TRANSLATION_KEY_PREFIX + device.toUpperCase())))}));
        }
        return Jsons.arr(jsonDevices);
    }
}

