/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.usersettings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opencastproject.adminui.usersettings.UserSetting;
import org.opencastproject.util.Jsons;

public class UserSettings {
    private int total = 0;
    private int limit = 0;
    private int offset = 0;
    private Map<String, Collection<UserSetting>> userSettings = new HashMap<String, Collection<UserSetting>>();

    public UserSettings() {
    }

    public UserSettings(Map<String, Collection<UserSetting>> userSettings) {
        this.userSettings = userSettings;
    }

    public Map<String, Collection<UserSetting>> getUserSettingsMap() {
        return this.userSettings;
    }

    public Collection<UserSetting> getUserSettingsCollection() {
        ArrayList<UserSetting> userSettingCollection = new ArrayList<UserSetting>();
        for (Collection<UserSetting> collection : this.userSettings.values()) {
            userSettingCollection.addAll(collection);
        }
        return userSettingCollection;
    }

    public void setUserSettings(Map<String, Collection<UserSetting>> userSettings) {
        this.userSettings = userSettings;
    }

    public void addUserSetting(UserSetting userSetting) {
        Collection<UserSetting> collection = this.userSettings.get(userSetting.getKey());
        if (collection == null) {
            collection = new ArrayList<UserSetting>();
        }
        collection.add(userSetting);
        this.userSettings.put(userSetting.getKey(), collection);
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Jsons.Obj toJson() {
        ArrayList<Jsons.Obj> settingsArr = new ArrayList<Jsons.Obj>();
        for (UserSetting userSetting : this.getUserSettingsCollection()) {
            settingsArr.add(userSetting.toJson());
        }
        return Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"offset", (Number)this.offset), Jsons.p((String)"limit", (Number)this.limit), Jsons.p((String)"total", (Number)this.total), Jsons.p((String)"results", (Jsons.Val)Jsons.arr(settingsArr))});
    }
}

