/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JString;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.impl.jpa.JpaGroup;
import org.opencastproject.userdirectory.ConflictException;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="groups", title="Group service", abstractText="Provides operations for groups", notes={"This service offers the default groups CRUD operations for the admin interface.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={GroupsEndpoint.class}, property={"service.description=Admin UI - Groups Endpoint", "opencast.service.type=org.opencastproject.adminui.GroupsEndpoint", "opencast.service.path=/admin-ng/groups"})
public class GroupsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(GroupsEndpoint.class);
    private ElasticsearchIndex searchIndex;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private IndexService indexService;
    private JpaGroupRoleProvider jpaGroupRoleProvider;

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setSearchIndex(ElasticsearchIndex searchIndex) {
        this.searchIndex = searchIndex;
    }

    @Reference
    public void setGroupRoleProvider(JpaGroupRoleProvider jpaGroupRoleProvider) {
        this.jpaGroupRoleProvider = jpaGroupRoleProvider;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        logger.info("Activate the Admin ui - Groups facade endpoint");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="groups.json")
    @RestQuery(name="allgroupsasjson", description="Returns a list of groups", returnDescription="List of groups for the current user's organization as JSON.", restParameters={@RestParameter(name="filter", isRequired=false, type=RestParameter.Type.STRING, description="Filter used for the query, formatted like: 'filter1:value1,filter2:value2'"), @RestParameter(name="sort", isRequired=false, type=RestParameter.Type.STRING, description="The sort order. May include any of the following: NAME, DESCRIPTION, ROLE. Add '_DESC' to reverse the sort order (e.g. NAME_DESC)."), @RestParameter(name="limit", isRequired=false, type=RestParameter.Type.INTEGER, defaultValue="100", description="The maximum number of items to return per page."), @RestParameter(name="offset", isRequired=false, type=RestParameter.Type.INTEGER, defaultValue="0", description="The page number.")}, responses={@RestResponse(responseCode=200, description="The groups.")})
    public Response getGroups(@QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit) throws IOException {
        Optional<Integer> optLimit = Optional.ofNullable(limit);
        Optional<Integer> optOffset = Optional.ofNullable(offset);
        Map filters = RestUtils.parseFilter((String)filter);
        Optional<String> optNameFilter = Optional.ofNullable((String)filters.get("Name"));
        Optional<String> optTextFilter = Optional.ofNullable((String)filters.get("textFilter"));
        Set sortCriteria = RestUtils.parseSortQueryParameter((String)sort);
        List results = this.jpaGroupRoleProvider.getGroups(optLimit, optOffset, optNameFilter, optTextFilter, sortCriteria);
        List userNames = results.stream().flatMap(item -> item.getMembers().stream()).collect(Collectors.toList());
        HashMap users = new HashMap(userNames.size());
        this.userDirectoryService.loadUsers(userNames).forEachRemaining(user -> users.put(user.getUsername(), user));
        ArrayList<JObject> groupsJSON = new ArrayList<JObject>();
        for (JpaGroup group : results) {
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.add(Jsons.f((String)"id", (JValue)Jsons.v((String)group.getGroupId())));
            fields.add(Jsons.f((String)"name", (JValue)Jsons.v((Object)group.getName(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)group.getDescription(), (JValue)Jsons.BLANK)));
            fields.add(Jsons.f((String)"role", (JValue)Jsons.v((String)group.getRole())));
            fields.add(Jsons.f((String)"users", (JValue)this.membersToJSON(group.getMembers().stream().map(users::get).filter(Objects::nonNull).iterator())));
            groupsJSON.add(Jsons.obj(fields));
        }
        long dbTotal = this.jpaGroupRoleProvider.countTotalGroups(optNameFilter, optTextFilter);
        long resultsTotal = optOffset.orElse(0) + results.size();
        long total = !optLimit.isPresent() || results.size() < optLimit.get() ? resultsTotal : Math.max(dbTotal, resultsTotal);
        return RestUtils.okJsonList(groupsJSON, optOffset, optLimit, (long)total);
    }

    @DELETE
    @Path(value="{id}")
    @RestQuery(name="removegrouop", description="Remove a group", returnDescription="Returns no content", pathParameters={@RestParameter(name="id", description="The group identifier", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Group deleted"), @RestResponse(responseCode=403, description="Not enough permissions to delete the group with admin role."), @RestResponse(responseCode=404, description="Group not found."), @RestResponse(responseCode=500, description="An internal server error occured.")})
    public Response removeGroup(@PathParam(value="id") String groupId) throws NotFoundException {
        try {
            this.jpaGroupRoleProvider.removeGroup(groupId);
            return Response.noContent().build();
        }
        catch (NotFoundException e) {
            return Response.status((int)404).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            logger.error("Unable to delete group {}", (Object)groupId, (Object)e);
            throw new WebApplicationException((Throwable)e, 500);
        }
    }

    @POST
    @Path(value="")
    @RestQuery(name="createGroup", description="Add a group", returnDescription="Returns Created (201) if the group has been created", restParameters={@RestParameter(name="name", description="The group name", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="description", description="The group description", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="roles", description="Comma seperated list of roles", isRequired=false, type=RestParameter.Type.TEXT), @RestParameter(name="users", description="Comma seperated list of members", isRequired=false, type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=201, description="Group created"), @RestResponse(responseCode=400, description="Name too long"), @RestResponse(responseCode=403, description="Not enough permissions to create a group with admin role."), @RestResponse(responseCode=409, description="An group with this name already exists.")})
    public Response createGroup(@FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="roles") String roles, @FormParam(value="users") String users) {
        try {
            this.jpaGroupRoleProvider.createGroup(name, description, roles, users);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to create group with name {}: {}", (Object)name, (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)403).build();
        }
        catch (ConflictException e) {
            return Response.status((int)409).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="{id}")
    @RestQuery(name="updateGroup", description="Update a group", returnDescription="Return the status codes", pathParameters={@RestParameter(name="id", description="The group identifier", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="name", description="The group name", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="description", description="The group description", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="roles", description="Comma seperated list of roles", isRequired=false, type=RestParameter.Type.TEXT), @RestParameter(name="users", description="Comma seperated list of members", isRequired=false, type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=200, description="Group updated"), @RestResponse(responseCode=403, description="Not enough permissions to update the group with admin role."), @RestResponse(responseCode=404, description="Group not found"), @RestResponse(responseCode=400, description="Name too long")})
    public Response updateGroup(@PathParam(value="id") String groupId, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="roles") String roles, @FormParam(value="users") String users) throws NotFoundException {
        try {
            this.jpaGroupRoleProvider.updateGroup(groupId, name, description, roles, users);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to update group with id {}: {}", (Object)groupId, (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (UnauthorizedException ex) {
            return Response.status((int)403).build();
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @RestQuery(name="getGroup", description="Get a single group", returnDescription="Return the status codes", pathParameters={@RestParameter(name="id", description="The group identifier", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Group found and returned as JSON"), @RestResponse(responseCode=404, description="Group not found")})
    public Response getGroup(@PathParam(value="id") String groupId) throws NotFoundException {
        JpaGroup group = this.jpaGroupRoleProvider.getGroup(groupId);
        if (group == null) {
            throw new NotFoundException("Group " + groupId + " does not exist.");
        }
        ArrayList<JString> rolesJSON = new ArrayList<JString>();
        for (String role : group.getRoleNames()) {
            rolesJSON.add(Jsons.v((String)role));
        }
        Iterator users = this.userDirectoryService.loadUsers((Collection)group.getMembers());
        return RestUtils.okJson((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((String)group.getGroupId())), Jsons.f((String)"name", (JValue)Jsons.v((Object)group.getName(), (JValue)Jsons.BLANK)), Jsons.f((String)"description", (JValue)Jsons.v((Object)group.getDescription(), (JValue)Jsons.BLANK)), Jsons.f((String)"role", (JValue)Jsons.v((Object)group.getRole(), (JValue)Jsons.BLANK)), Jsons.f((String)"roles", (JValue)Jsons.arr(rolesJSON)), Jsons.f((String)"users", (JValue)this.membersToJSON(users))}));
    }

    private JValue membersToJSON(Iterator<User> members) {
        ArrayList<JObject> membersJSON = new ArrayList<JObject>();
        while (members.hasNext()) {
            User user = members.next();
            String name = user.getUsername();
            if (StringUtils.isNotBlank((CharSequence)user.getName())) {
                name = user.getName();
            }
            membersJSON.add(Jsons.obj((Field[])new Field[]{Jsons.f((String)"username", (JValue)Jsons.v((String)user.getUsername())), Jsons.f((String)"name", (JValue)Jsons.v((String)name))}));
        }
        return Jsons.arr(membersJSON);
    }
}

