/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry.jp;

import java.io.File;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.preset.JPHelp;
import org.openbase.jps.tools.FileHandler;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.storage.registry.jp.JPInitializeDB;
import org.openbase.jul.storage.registry.jp.JPResetDB;
import org.slf4j.Logger;

public abstract class AbstractJPDatabaseDirectory
extends AbstractJPDirectory {
    public static FileHandler.ExistenceHandling existenceHandling = FileHandler.ExistenceHandling.Must;
    public static FileHandler.AutoMode autoMode = FileHandler.AutoMode.Off;

    public AbstractJPDatabaseDirectory(String[] commandIdentifier) {
        super(commandIdentifier, existenceHandling, autoMode);
    }

    public void validate() throws JPValidationException {
        boolean reinitDetected = false;
        try {
            if (((Boolean)((JPInitializeDB)JPService.getProperty(JPInitializeDB.class)).getValue()).booleanValue()) {
                this.setAutoCreateMode(FileHandler.AutoMode.On);
                this.setExistenceHandling(FileHandler.ExistenceHandling.Must);
                reinitDetected = true;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        try {
            if (((Boolean)((JPResetDB)JPService.getProperty(JPResetDB.class)).getValue()).booleanValue()) {
                this.setAutoCreateMode(FileHandler.AutoMode.On);
                this.setExistenceHandling(FileHandler.ExistenceHandling.MustBeNew);
                reinitDetected = true;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        if (!((File)this.getValue()).exists() && !reinitDetected) {
            throw new JPValidationException("Could not detect Database[" + ((File)this.getValue()).getAbsolutePath() + "]! You can use the argument " + JPInitializeDB.COMMAND_IDENTIFIERS[0] + " to initialize a new db enviroment. Use " + JPHelp.COMMAND_IDENTIFIERS[0] + " to get more options.");
        }
        super.validate();
    }
}

