/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotSupportedException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.storage.registry.AbstractRegistry;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.ProtoBufRegistry;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.plugin.RemoteRegistryPlugin;

public class RemoteRegistry<KEY, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends AbstractRegistry<KEY, IdentifiableMessage<KEY, M, MB>, Map<KEY, IdentifiableMessage<KEY, M, MB>>, ProtoBufRegistry<KEY, M, MB>, RemoteRegistryPlugin<KEY, IdentifiableMessage<KEY, M, MB>>>
implements ProtoBufRegistry<KEY, M, MB> {
    public RemoteRegistry() throws InstantiationException {
        this(new HashMap());
    }

    public RemoteRegistry(Map<KEY, IdentifiableMessage<KEY, M, MB>> internalMap) throws InstantiationException {
        super(internalMap);
    }

    public synchronized void notifyRegistryUpdate(Collection<M> values) throws CouldNotPerformException {
        HashMap<Object, IdentifiableMessage> newRegistryMap = new HashMap<Object, IdentifiableMessage>();
        for (GeneratedMessage value : values) {
            IdentifiableMessage data = new IdentifiableMessage(value);
            newRegistryMap.put(data.getId(), data);
        }
        this.replaceInternalMap(newRegistryMap);
    }

    public KEY getId(M entry) throws CouldNotPerformException {
        Object key = entry.getField(entry.getDescriptorForType().findFieldByName("id"));
        if (!this.contains((M)key)) {
            throw new CouldNotPerformException("Entry for given Key[" + key + "] is not available!");
        }
        return (KEY)key;
    }

    @Override
    public M getMessage(KEY key) throws CouldNotPerformException {
        return (M)((IdentifiableMessage)this.get(key)).getMessage();
    }

    @Override
    public MB getBuilder(KEY key) throws CouldNotPerformException {
        return (MB)((GeneratedMessage.Builder)this.getMessage(key).toBuilder());
    }

    @Override
    public M register(M entry) throws CouldNotPerformException {
        throw new NotSupportedException("register", (Object)this, (Object)"Operation not permitted!");
    }

    @Override
    public M update(M entry) throws CouldNotPerformException {
        throw new NotSupportedException("update", (Object)this, (Object)"Operation not permitted!");
    }

    @Override
    public M remove(M entry) throws CouldNotPerformException {
        throw new NotSupportedException("remove", (Object)this, (Object)"Operation not permitted!");
    }

    @Override
    public boolean contains(M entry) throws CouldNotPerformException {
        KEY key;
        try {
            key = this.getId(entry);
        }
        catch (CouldNotPerformException ex) {
            return false;
        }
        return super.contains(key);
    }

    @Override
    public void loadRegistry() throws CouldNotPerformException {
        throw new NotSupportedException("loadRegistry", (Object)this, (Object)"Operation not permitted!");
    }

    @Override
    public void saveRegistry() throws CouldNotPerformException {
        throw new NotSupportedException("saveRegistry", (Object)this, (Object)"Operation not permitted!");
    }

    @Override
    public List<M> getMessages() throws CouldNotPerformException {
        ArrayList<GeneratedMessage> messageList = new ArrayList<GeneratedMessage>();
        for (IdentifiableMessage messageContainer : this.getEntries()) {
            messageList.add(messageContainer.getMessage());
        }
        return messageList;
    }

    @Override
    public Integer getDBVersion() throws NotAvailableException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void registerConsistencyHandler(ConsistencyHandler<KEY, IdentifiableMessage<KEY, M, MB>, Map<KEY, IdentifiableMessage<KEY, M, MB>>, ProtoBufRegistry<KEY, M, MB>> consistencyHandler) throws CouldNotPerformException {
        throw new NotSupportedException("registerConsistencyHandler", (Object)"method", (Object)this);
    }

    @Override
    public void registerDependency(Registry registry) throws CouldNotPerformException {
        throw new NotSupportedException("registerDependency", (Object)"method", (Object)this);
    }

    @Override
    public boolean tryLockRegistry() throws RejectedException {
        throw new RejectedException("RemoteRegistry not lockable!");
    }

    @Override
    public void unlockRegistry() {
    }
}

