/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import java.util.List;
import java.util.Map;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.iface.Writable;
import org.openbase.jul.pattern.Observable;

public interface Registry<KEY, ENTRY extends Identifiable<KEY>>
extends Writable,
Observable<Map<KEY, ENTRY>> {
    public String getName();

    public ENTRY register(ENTRY var1) throws CouldNotPerformException;

    public ENTRY update(ENTRY var1) throws CouldNotPerformException;

    public ENTRY remove(KEY var1) throws CouldNotPerformException;

    public ENTRY remove(ENTRY var1) throws CouldNotPerformException;

    public ENTRY get(KEY var1) throws CouldNotPerformException;

    default public ENTRY get(ENTRY entry) throws CouldNotPerformException {
        return (ENTRY)this.get((ENTRY)entry.getId());
    }

    public List<ENTRY> getEntries() throws CouldNotPerformException;

    public boolean contains(ENTRY var1) throws CouldNotPerformException;

    public boolean contains(KEY var1) throws CouldNotPerformException;

    public void clear() throws CouldNotPerformException;

    public int size();

    public boolean isReadOnly();

    public boolean isConsistent();

    public boolean isSandbox();

    public boolean tryLockRegistry() throws RejectedException;

    public void unlockRegistry();
}

