/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import com.google.protobuf.GeneratedMessage;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.iface.Configurable;
import org.openbase.jul.iface.Enableable;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.storage.registry.RegistryImpl;
import org.openbase.jul.storage.registry.RegistrySynchronizer;
import org.openbase.jul.storage.registry.RemoteRegistry;

public abstract class EnableableEntryRegistrySynchronizer<KEY, ENTRY extends Configurable<KEY, CONFIG_M> & Enableable, CONFIG_M extends GeneratedMessage, CONFIG_MB extends GeneratedMessage.Builder<CONFIG_MB>>
extends RegistrySynchronizer<KEY, ENTRY, CONFIG_M, CONFIG_MB> {
    public EnableableEntryRegistrySynchronizer(RegistryImpl<KEY, ENTRY> registry, RemoteRegistry<KEY, CONFIG_M, CONFIG_MB> remoteRegistry, Factory<ENTRY, CONFIG_M> factory) throws InstantiationException {
        super(registry, remoteRegistry, factory);
    }

    @Override
    public ENTRY update(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.update(config);
        if (this.enablingCondition(config)) {
            ((Enableable)entry).enable();
        } else {
            ((Enableable)entry).disable();
        }
        return entry;
    }

    @Override
    public ENTRY register(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.register(config);
        if (this.enablingCondition(config)) {
            ((Enableable)entry).enable();
        }
        return entry;
    }

    @Override
    public ENTRY remove(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.remove(config);
        ((Enableable)entry).disable();
        return entry;
    }

    public abstract boolean enablingCondition(CONFIG_M var1);
}

