/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import java.util.HashMap;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.pattern.Controller;
import org.openbase.jul.storage.registry.RegistryImpl;
import org.slf4j.Logger;

public class ControllerRegistry<KEY, ENTRY extends Controller & Identifiable<KEY>>
extends RegistryImpl<KEY, ENTRY> {
    public ControllerRegistry() throws InstantiationException {
        super(new HashMap());
    }

    public ControllerRegistry(HashMap<KEY, ENTRY> entryMap) throws InstantiationException {
        super(entryMap);
    }

    @Override
    public void clear() throws CouldNotPerformException {
        MultiException.ExceptionStack exceptionStack = null;
        for (Controller controller : this.getEntries()) {
            try {
                controller.deactivate();
            }
            catch (InterruptedException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                exceptionStack = MultiException.push((Object)this, (Exception)ex, exceptionStack);
            }
        }
        MultiException.checkAndThrow((String)"Could not deactivate all devices!", exceptionStack);
        super.clear();
    }
}

