/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import com.google.protobuf.GeneratedMessage;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Configurable;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.storage.registry.RegistryImpl;
import org.openbase.jul.storage.registry.RegistrySynchronizer;
import org.openbase.jul.storage.registry.RemoteRegistry;

public abstract class ActivatableEntryRegistrySynchronizer<KEY, ENTRY extends Configurable<KEY, CONFIG_M> & Activatable, CONFIG_M extends GeneratedMessage, CONFIG_MB extends GeneratedMessage.Builder<CONFIG_MB>>
extends RegistrySynchronizer<KEY, ENTRY, CONFIG_M, CONFIG_MB> {
    public ActivatableEntryRegistrySynchronizer(RegistryImpl<KEY, ENTRY> registry, RemoteRegistry<KEY, CONFIG_M, CONFIG_MB> remoteRegistry, Factory<ENTRY, CONFIG_M> factory) throws InstantiationException {
        super(registry, remoteRegistry, factory);
    }

    @Override
    public ENTRY update(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.update(config);
        if (this.activationCondition(config)) {
            ((Activatable)entry).activate();
        } else {
            ((Activatable)entry).deactivate();
        }
        return entry;
    }

    @Override
    public ENTRY register(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.register(config);
        if (this.activationCondition(config)) {
            ((Activatable)entry).activate();
        }
        return entry;
    }

    @Override
    public ENTRY remove(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.remove(config);
        ((Activatable)entry).deactivate();
        return entry;
    }

    public abstract boolean activationCondition(CONFIG_M var1);
}

