/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.schedule;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchDog
implements Activatable,
Shutdownable {
    private final Object EXECUTION_LOCK = new Object();
    private final Object activationLock;
    private static final long DELAY = 5000L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Activatable service;
    private final String serviceName;
    private Minder minder;
    private ServiceState serviceState = ServiceState.UNKNWON;
    private final ObservableImpl<ServiceState> serviceStateObserable;

    public WatchDog(Activatable task, final String serviceName) throws InstantiationException {
        try {
            this.service = task;
            this.serviceName = serviceName;
            this.serviceStateObserable = new ObservableImpl();
            this.activationLock = new SyncObject(serviceName + "WatchDogLock");
            if (task == null) {
                throw new NotAvailableException("task");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        WatchDog.this.deactivate();
                    }
                    catch (InterruptedException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not shutdown " + serviceName + "!", (Throwable)ex), (Logger)WatchDog.this.logger);
                    }
                }
            });
            this.setServiceState(ServiceState.CONSTRUCTED);
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws InterruptedException {
        this.logger.trace("Try to activate service: " + this.serviceName);
        Object object = this.EXECUTION_LOCK;
        synchronized (object) {
            this.logger.trace("Init activation of service: " + this.serviceName);
            if (this.minder != null) {
                this.logger.debug("Skip activation, Service[" + this.serviceName + "] already running!");
                return;
            }
            this.minder = new Minder(this.serviceName + "WatchDog");
            this.logger.trace("Start activation of service: " + this.serviceName);
            this.minder.start();
        }
        try {
            this.waitForActivation();
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not wait for service activation!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws InterruptedException {
        this.logger.debug("Try to deactivate service: " + this.serviceName);
        Object object = this.EXECUTION_LOCK;
        synchronized (object) {
            this.logger.debug("Init deactivation of service: " + this.serviceName);
            if (this.minder == null) {
                this.logger.debug("Skip deactivation, Service[" + this.serviceName + "] not running!");
                return;
            }
            this.logger.debug("Init service interruption...");
            this.minder.interrupt();
            this.logger.debug("Wait for service interruption...");
            this.minder.join();
            this.minder = null;
            this.logger.debug("Service interrupted!");
            this.skipActivation();
        }
    }

    public boolean isActive() {
        return this.minder != null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForActivation() throws InterruptedException {
        Object object = this.activationLock;
        synchronized (object) {
            if (this.serviceState == ServiceState.RUNNING) {
                return;
            }
            this.addObserver(new Observer<ServiceState>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void update(Observable<ServiceState> source, ServiceState data) throws Exception {
                    if (data == ServiceState.RUNNING) {
                        Object object = WatchDog.this.activationLock;
                        synchronized (object) {
                            WatchDog.this.activationLock.notifyAll();
                        }
                    }
                }
            });
            this.activationLock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipActivation() {
        Object object = this.activationLock;
        synchronized (object) {
            this.activationLock.notifyAll();
        }
    }

    public Activatable getService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServiceState(ServiceState serviceState) {
        try {
            Object object = this.activationLock;
            synchronized (object) {
                if (this.serviceState == serviceState) {
                    return;
                }
                this.serviceState = serviceState;
            }
            this.logger.debug(this + " is now " + serviceState.name().toLowerCase() + ".");
            this.serviceStateObserable.notifyObservers((Object)serviceState);
        }
        catch (MultiException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify state change to all instances!", (Throwable)ex), (Logger)this.logger);
        }
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public void addObserver(Observer<ServiceState> observer) {
        this.serviceStateObserable.addObserver(observer);
    }

    public void removeObserver(Observer<ServiceState> observer) {
        this.serviceStateObserable.removeObserver(observer);
    }

    public void shutdown() {
        try {
            this.serviceStateObserable.shutdown();
            this.deactivate();
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((String)(this + "was interruped during shutdown!"), (Throwable)ex, (Logger)this.logger);
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.serviceName + "]";
    }

    private class Minder
    extends Thread {
        private Minder(String name) {
            super(name);
            WatchDog.this.setServiceState(ServiceState.INITIALIZING);
        }

        @Override
        public void run() {
            try {
                try {
                    while (!this.isInterrupted()) {
                        if (!WatchDog.this.service.isActive()) {
                            WatchDog.this.setServiceState(ServiceState.INITIALIZING);
                            try {
                                WatchDog.this.logger.debug("Service activate: " + WatchDog.this.service.hashCode() + " : " + WatchDog.this.serviceName);
                                WatchDog.this.service.activate();
                                WatchDog.this.setServiceState(ServiceState.RUNNING);
                            }
                            catch (NullPointerException | CouldNotPerformException ex) {
                                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not start Service[" + WatchDog.this.serviceName + " " + WatchDog.this.service.hashCode() + "]!", ex), (Logger)WatchDog.this.logger);
                                WatchDog.this.setServiceState(ServiceState.FAILED);
                                WatchDog.this.logger.info("Try again in 5 seconds...");
                            }
                        }
                        this.waitWithinDelay();
                    }
                }
                catch (InterruptedException ex) {
                    WatchDog.this.logger.debug("Minder shutdown initiated of Service[" + WatchDog.this.serviceName + "]...");
                }
                while (WatchDog.this.service.isActive()) {
                    WatchDog.this.setServiceState(ServiceState.TERMINATING);
                    try {
                        try {
                            WatchDog.this.logger.debug("Minder deactivation initiated of Service[" + WatchDog.this.serviceName + "]...");
                            WatchDog.this.service.deactivate();
                            WatchDog.this.setServiceState(ServiceState.FINISHED);
                        }
                        catch (IllegalStateException | CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not shutdown Service[" + WatchDog.this.serviceName + "]! Try again in " + 5L + " seconds...", ex), (Logger)WatchDog.this.logger);
                            this.waitWithinDelay();
                        }
                    }
                    catch (InterruptedException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not terminate Service[" + WatchDog.this.serviceName + "] because termination was externaly interrupted.", (Throwable)ex), (Logger)WatchDog.this.logger, (LogLevel)LogLevel.WARN);
                        WatchDog.this.setServiceState(ServiceState.INTERRUPTED);
                        break;
                    }
                }
            }
            catch (Throwable tr) {
                ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException("Fatal watchdog execution error! Release all locks...", tr), (Logger)WatchDog.this.logger);
                WatchDog.this.skipActivation();
            }
        }

        private void waitWithinDelay() throws InterruptedException {
            Thread.sleep(5000L);
        }
    }

    public static enum ServiceState {
        UNKNWON,
        CONSTRUCTED,
        INITIALIZING,
        RUNNING,
        TERMINATING,
        FINISHED,
        FAILED,
        INTERRUPTED;

    }
}

