/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.schedule;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.schedule.GlobalExecutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Timeout {
    private static final Logger logger = LoggerFactory.getLogger(Timeout.class);
    private final Object lock = new Object();
    private Future timerTask;
    private long waitTime;
    private boolean expired;

    public Timeout(long waitTime) {
        this.waitTime = waitTime;
    }

    public long getTimeToWait() {
        return this.waitTime;
    }

    public void restart(long waitTime) {
        this.waitTime = waitTime;
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        logger.debug("Reset timer.");
        Object object = this.lock;
        synchronized (object) {
            this.cancel();
            this.start();
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.timerTask != null && !this.timerTask.isDone();
        }
    }

    public void start() {
        this.internal_start(this.waitTime);
    }

    public void start(long waitTime) {
        this.waitTime = waitTime;
        this.internal_start(waitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internal_start(final long waitTime) {
        Object object = this.lock;
        synchronized (object) {
            if (this.timerTask != null && !this.timerTask.isCancelled() && !this.timerTask.isDone()) {
                logger.debug("Reject start, not interrupted or expired.");
                return;
            }
            this.expired = false;
            this.timerTask = GlobalExecutionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws InterruptedException {
                    logger.debug("Wait for timeout TimeOut interrupted.");
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException ex) {
                        logger.debug("TimeOut interrupted.");
                        throw ex;
                    }
                    try {
                        logger.debug("Expire...");
                        Timeout.this.expired = true;
                        Timeout.this.expired();
                    }
                    catch (Exception ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Error during timeout handling!", (Throwable)ex), (Logger)logger, (LogLevel)LogLevel.WARN);
                    }
                    logger.debug("Worker finished.");
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        logger.debug("try to cancel timer.");
        Object object = this.lock;
        synchronized (object) {
            if (this.timerTask != null) {
                logger.debug("cancel timer.");
                this.timerTask.cancel(true);
                this.timerTask = null;
            } else {
                logger.debug("timer was canceled but never started!");
            }
        }
    }

    public abstract void expired() throws InterruptedException;

    public String toString() {
        return this.getClass().getSimpleName() + "[wait:" + this.waitTime + "]";
    }
}

