/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.iface.Processable;
import org.openbase.jul.iface.Shutdownable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExecutionService
implements Shutdownable {
    public static final long DEFAULT_SHUTDOWN_TIME = 5L;
    protected final Logger logger = LoggerFactory.getLogger(GlobalExecutionService.class);
    private static GlobalExecutionService instance;
    private final ExecutorService executionService = Executors.newCachedThreadPool();

    private GlobalExecutionService() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (instance != null) {
                    instance.shutdown();
                }
            }
        });
    }

    public static synchronized GlobalExecutionService getInstance() {
        if (instance == null) {
            instance = new GlobalExecutionService();
        }
        return instance;
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return GlobalExecutionService.getInstance().executionService.submit(task);
    }

    public static Future<?> submit(Runnable task) {
        return GlobalExecutionService.getInstance().executionService.submit(task);
    }

    public static void execute(Runnable runnable) {
        GlobalExecutionService.getInstance().executionService.execute(runnable);
    }

    public static void applyErrorHandling(Future future, Processable<Exception, Void> errorProcessor, long timeout, TimeUnit timeUnit) throws CouldNotPerformException {
        GlobalExecutionService.submit(() -> {
            try {
                future.get(timeout, timeUnit);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                errorProcessor.process((Object)ex);
            }
            return null;
        });
    }

    public void shutdown() {
        this.shutdown(5L, TimeUnit.SECONDS);
    }

    public void shutdown(long shutdownTimeout, TimeUnit timeUnit) {
        this.logger.info("Shutdown global executor service...");
        List<Runnable> droppedTasks = this.executionService.shutdownNow();
        if (!droppedTasks.isEmpty()) {
            this.logger.info("Global executor shutdown forced: " + droppedTasks.size() + " tasks will be skipped...");
        }
        try {
            if (!this.executionService.awaitTermination(shutdownTimeout, timeUnit)) {
                this.logger.error("Executor did not terminate before shutdown Timeout[" + shutdownTimeout + " " + timeUnit.name().toLowerCase() + "] expired!");
                this.forceShutdown();
            }
        }
        catch (InterruptedException ex) {
            this.forceShutdown();
            Thread.currentThread().interrupt();
        }
    }

    public void forceShutdown() {
        for (int i = 0; i < 10; ++i) {
            this.executionService.shutdownNow();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <I> Future<Void> allOf(Processable<I, Future<Void>> actionProcessor, Collection<I> inputList) {
        return GlobalExecutionService.allOf(actionProcessor, input -> null, inputList);
    }

    public static <I, O, R> Future<R> allOf(final Processable<I, Future<O>> actionProcessor, final Processable<Collection<Future<O>>, R> resultProcessor, final Collection<I> inputList) {
        return GlobalExecutionService.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                MultiException.ExceptionStack exceptionStack = null;
                ArrayList<Object> futureList = new ArrayList<Object>();
                for (Object e : inputList) {
                    try {
                        futureList.add(actionProcessor.process(e));
                    }
                    catch (CouldNotPerformException ex) {
                        exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), exceptionStack);
                    }
                }
                try {
                    for (Future future2 : futureList) {
                        try {
                            future2.get();
                        }
                        catch (ExecutionException ex) {
                            exceptionStack = MultiException.push((Object)this, (Exception)ex, (MultiException.ExceptionStack)exceptionStack);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    futureList.stream().forEach(future -> future.cancel(true));
                    throw ex;
                }
                MultiException.checkAndThrow((String)"Could not apply all actions!", (MultiException.ExceptionStack)exceptionStack);
                return resultProcessor.process(futureList);
            }
        });
    }

    public static <T> Future<T> allOf(final Collection<Future> futureCollection, final T returnValue) {
        return GlobalExecutionService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                MultiException.ExceptionStack exceptionStack = null;
                try {
                    for (Future future2 : futureCollection) {
                        try {
                            future2.get();
                        }
                        catch (ExecutionException ex) {
                            exceptionStack = MultiException.push((Object)this, (Exception)ex, exceptionStack);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    futureCollection.stream().forEach(future -> future.cancel(true));
                    throw ex;
                }
                MultiException.checkAndThrow((String)"Could not apply all actions!", exceptionStack);
                return returnValue;
            }
        });
    }
}

