/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf.processing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.processing.FileProcessor;

public class ProtoBufFileProcessor<DT, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
implements FileProcessor<DT> {
    private static final String UTF_8 = "UTF-8";
    private final JsonParser parser;
    private final Gson gson;
    private final JsonFormat jsonFormat;
    private final TypeToMessageTransformer<DT, M, MB> transformer;

    public ProtoBufFileProcessor(TypeToMessageTransformer<DT, M, MB> transformer) {
        this.transformer = transformer;
        this.parser = new JsonParser();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.jsonFormat = new JsonFormat();
    }

    public DT deserialize(File file, DT data) throws CouldNotPerformException {
        try {
            this.jsonFormat.merge((InputStream)new FileInputStream(file), Charset.forName(UTF_8), this.transformer.transform(data).newBuilderForType());
            return data;
        }
        catch (IOException ex) {
            throw new CouldNotPerformException("Could not deserialize " + file + " inot " + data + "!", (Throwable)ex);
        }
    }

    public File serialize(DT data, File file) throws CouldNotPerformException {
        try {
            String jsonString = this.jsonFormat.printToString(this.transformer.transform(data));
            JsonElement el = this.parser.parse(jsonString);
            jsonString = this.gson.toJson(el);
            FileUtils.writeStringToFile((File)file, (String)jsonString, (String)UTF_8);
            return file;
        }
        catch (JsonIOException | JsonSyntaxException | IOException ex) {
            throw new CouldNotPerformException("Could not serialize " + this.transformer + " into " + file + "!", ex);
        }
    }

    public DT deserialize(File file) throws CouldNotPerformException {
        GeneratedMessage.Builder builder = (GeneratedMessage.Builder)this.transformer.newBuilderForType();
        try {
            this.jsonFormat.merge((InputStream)new FileInputStream(file), Charset.forName(UTF_8), (Message.Builder)builder);
            return this.transformer.transform((GeneratedMessage)builder.build());
        }
        catch (IOException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not deserialize " + file + " into " + builder + "!", ex);
        }
    }

    public static interface TypeToMessageTransformer<T, M extends GeneratedMessage, MB extends Message.Builder> {
        public GeneratedMessage transform(T var1);

        public T transform(M var1) throws CouldNotTransformException;

        public MB newBuilderForType() throws CouldNotPerformException;
    }
}

