/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf.processing;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.openbase.jul.exception.CouldNotPerformException;

public class ProtoBufFieldProcessor {
    public static Descriptors.FieldDescriptor getFieldDescriptor(Message builder, int fieldNumber) {
        return builder.getDescriptorForType().findFieldByNumber(fieldNumber);
    }

    public static Descriptors.FieldDescriptor getFieldDescriptor(Message.Builder builder, int fieldNumber) {
        return builder.getDescriptorForType().findFieldByNumber(fieldNumber);
    }

    public static Descriptors.FieldDescriptor getFieldDescriptor(GeneratedMessage message, int fieldNumber) {
        return message.getDescriptorForType().findFieldByNumber(fieldNumber);
    }

    public static Descriptors.FieldDescriptor[] getFieldDescriptors(Class<? extends GeneratedMessage> messageClass, int ... fieldNumbers) throws CouldNotPerformException {
        try {
            Descriptors.FieldDescriptor[] fieldDescriptors = new Descriptors.FieldDescriptor[fieldNumbers.length];
            GeneratedMessage defaultMessage = (GeneratedMessage)messageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
            for (int i = 0; i < fieldNumbers.length; ++i) {
                fieldDescriptors[i] = ProtoBufFieldProcessor.getFieldDescriptor(defaultMessage, fieldNumbers[i]);
            }
            return fieldDescriptors;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new CouldNotPerformException("Could not detect field descriptors!", (Throwable)ex);
        }
    }

    public static Descriptors.FieldDescriptor getFieldDescriptor(Class<? extends GeneratedMessage> messageClass, int fieldNumber) throws CouldNotPerformException {
        try {
            return ProtoBufFieldProcessor.getFieldDescriptor((GeneratedMessage)messageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]), fieldNumber);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new CouldNotPerformException("Could not detect field descriptor!", (Throwable)ex);
        }
    }

    public static Descriptors.FieldDescriptor getFieldDescriptor(Message.Builder builder, String fieldName) {
        return builder.getDescriptorForType().findFieldByName(fieldName);
    }

    public static String getId(Message msg) throws CouldNotPerformException {
        return ProtoBufFieldProcessor.getId(msg.toBuilder());
    }

    public static String getId(Message.Builder msg) throws CouldNotPerformException {
        try {
            return (String)msg.getField(ProtoBufFieldProcessor.getFieldDescriptor(msg, "id"));
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not get id of [" + msg + "]", (Throwable)ex);
        }
    }

    public static String getDescription(Message.Builder msg) throws CouldNotPerformException {
        try {
            return (String)msg.getField(ProtoBufFieldProcessor.getFieldDescriptor(msg, "description"));
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not get description of [" + msg + "]", (Throwable)ex);
        }
    }

    public static String getLabel(Message.Builder msg) throws CouldNotPerformException {
        try {
            return (String)msg.getField(ProtoBufFieldProcessor.getFieldDescriptor(msg, "label"));
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not get label of [" + msg + "]", (Throwable)ex);
        }
    }

    public static void initRequiredFieldsWithDefault(Message.Builder builder) {
        List missingFieldList = builder.findInitializationErrors();
        missingFieldList.stream().forEach(initError -> ProtoBufFieldProcessor.initFieldWithDefault(builder, initError));
    }

    public static Message.Builder initFieldWithDefault(Message.Builder builder, String fieldPath) {
        Descriptors.FieldDescriptor fieldDescriptor;
        Message.Builder tmpBuilder = builder;
        String[] fields = fieldPath.split("\\.");
        for (int i = 0; i < fields.length - 1; ++i) {
            if (fields[i].endsWith("]")) {
                String fieldName = fields[i].split("\\[")[0];
                int number = Integer.parseInt(fields[i].split("\\[")[1].split("\\]")[0]);
                fieldDescriptor = ProtoBufFieldProcessor.getFieldDescriptor(tmpBuilder, fieldName);
                Message.Builder subBuilder = ((Message)tmpBuilder.getRepeatedField(fieldDescriptor, number)).toBuilder();
                String subPath = fields[i + 1];
                for (int j = i + 2; j < fields.length; ++j) {
                    subPath = subPath + "." + fields[j];
                }
                tmpBuilder.setRepeatedField(fieldDescriptor, number, (Object)ProtoBufFieldProcessor.initFieldWithDefault(subBuilder, subPath).buildPartial());
                return builder;
            }
            fieldDescriptor = ProtoBufFieldProcessor.getFieldDescriptor(tmpBuilder, fields[i]);
            tmpBuilder = tmpBuilder.getFieldBuilder(fieldDescriptor);
        }
        fieldDescriptor = ProtoBufFieldProcessor.getFieldDescriptor(tmpBuilder, fields[fields.length - 1]);
        Object field = tmpBuilder.getField(fieldDescriptor);
        tmpBuilder.setField(fieldDescriptor, field);
        return builder;
    }

    public static void clearRequiredFields(Message.Builder builder) {
        builder.findInitializationErrors().stream().forEach(initError -> ProtoBufFieldProcessor.clearRequiredField(builder, initError));
    }

    public static Message.Builder clearRequiredField(Message.Builder builder, String fieldPath) {
        Descriptors.FieldDescriptor fieldDescriptor;
        Message.Builder tmpBuilder = builder;
        String[] fields = fieldPath.split("\\.");
        boolean alreadyRemoved = false;
        for (int i = 0; i < fields.length - 2; ++i) {
            if (fields[i].endsWith("]")) {
                String fieldName = fields[i].split("\\[")[0];
                int number = Integer.parseInt(fields[i].split("\\[")[1].split("\\]")[0]);
                fieldDescriptor = ProtoBufFieldProcessor.getFieldDescriptor(tmpBuilder, fieldName);
                Message.Builder subBuilder = ((Message)tmpBuilder.getRepeatedField(fieldDescriptor, number)).toBuilder();
                String subPath = fields[i + 1];
                for (int j = i + 2; j < fields.length; ++j) {
                    subPath = subPath + "." + fields[j];
                }
                tmpBuilder.setRepeatedField(fieldDescriptor, number, (Object)ProtoBufFieldProcessor.clearRequiredField(subBuilder, subPath).buildPartial());
                return builder;
            }
            fieldDescriptor = ProtoBufFieldProcessor.getFieldDescriptor(tmpBuilder, fields[i]);
            if (!tmpBuilder.hasField(fieldDescriptor)) {
                alreadyRemoved = true;
                continue;
            }
            tmpBuilder = tmpBuilder.getFieldBuilder(fieldDescriptor);
        }
        if (!alreadyRemoved) {
            fieldDescriptor = ProtoBufFieldProcessor.getFieldDescriptor(tmpBuilder, fields[fields.length - 2]);
            tmpBuilder.clearField(fieldDescriptor);
        }
        return builder;
    }

    public static boolean checkIfSomeButNotAllRequiredFieldsAreSet(Message.Builder builder) {
        if (builder.isInitialized()) {
            return false;
        }
        for (Descriptors.FieldDescriptor field : builder.getDescriptorForType().getFields()) {
            if (!field.isRepeated() && !builder.hasField(field) || field.isRepeated() && field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) continue;
            if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                if (field.isRepeated()) {
                    for (int i = 0; i < builder.getRepeatedFieldCount(field); ++i) {
                        if (!ProtoBufFieldProcessor.checkIfSomeButNotAllRequiredFieldsAreSet(((Message)builder.getRepeatedField(field, i)).toBuilder())) continue;
                        return true;
                    }
                    continue;
                }
                if (!ProtoBufFieldProcessor.checkIfSomeButNotAllRequiredFieldsAreSet(builder.getFieldBuilder(field))) continue;
                return true;
            }
            if (!field.isRequired()) continue;
            return true;
        }
        return false;
    }
}

