/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf.container.transformer;

import com.google.protobuf.GeneratedMessage;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.extension.protobuf.IdGenerator;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.container.transformer.MessageTransformer;

public class IdentifiableMessageTransformer<KEY, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends MessageTransformer<IdentifiableMessage<KEY, M, MB>, M, MB> {
    private final IdGenerator<KEY, M> idGenerator;

    public IdentifiableMessageTransformer(Class<M> messageClass, IdGenerator<KEY, M> idGenerator) {
        super(messageClass);
        this.idGenerator = idGenerator;
    }

    @Override
    public IdentifiableMessage<KEY, M, MB> transform(M message) throws CouldNotTransformException {
        try {
            return new IdentifiableMessage(message, this.idGenerator);
        }
        catch (InstantiationException ex) {
            throw new CouldNotTransformException("Given message is invalid!", (Throwable)ex);
        }
    }
}

