/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf.container;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.BuilderSyncSetup;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.container.ProtoBufMessageMap;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoBufMessageMapImpl<KEY extends Comparable<KEY>, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>, SIB extends GeneratedMessage.Builder<SIB>>
extends HashMap<KEY, IdentifiableMessage<KEY, M, MB>>
implements ProtoBufMessageMap<KEY, M, MB> {
    protected final Logger logger = LoggerFactory.getLogger(ProtoBufMessageMapImpl.class);
    private boolean shudownDetected = false;
    private final BuilderSyncSetup<SIB> builderSetup;
    private final Observer<IdentifiableMessage<KEY, M, MB>> observer;
    private final ObservableImpl<IdentifiableMessage<KEY, M, MB>> observable;
    private final Descriptors.FieldDescriptor fieldDescriptor;

    public ProtoBufMessageMapImpl(BuilderSyncSetup<SIB> builderSetup, Descriptors.FieldDescriptor fieldDescriptor) {
        this.builderSetup = builderSetup;
        this.fieldDescriptor = fieldDescriptor;
        this.observable = new ObservableImpl();
        this.observer = new Observer<IdentifiableMessage<KEY, M, MB>>(){

            public void update(Observable<IdentifiableMessage<KEY, M, MB>> source, IdentifiableMessage<KEY, M, MB> data) throws Exception {
                ProtoBufMessageMapImpl.this.syncBuilder();
                ProtoBufMessageMapImpl.this.observable.notifyObservers(source, data);
            }
        };
    }

    public BuilderSyncSetup<SIB> getBuilderSetup() {
        return this.builderSetup;
    }

    public Descriptors.FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    @Override
    public IdentifiableMessage<KEY, M, MB> put(KEY key, IdentifiableMessage<KEY, M, MB> value) {
        if (value == null) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not add value!", (Throwable)new NotAvailableException("value")), (Logger)this.logger);
            return value;
        }
        IdentifiableMessage<KEY, M, MB> oldValue = super.put(key, value);
        if (oldValue != null) {
            oldValue.removeObserver(this.observer);
        }
        value.addObserver(this.observer);
        this.syncBuilder();
        return oldValue;
    }

    @Override
    public IdentifiableMessage<KEY, M, MB> put(IdentifiableMessage<KEY, M, MB> value) throws CouldNotPerformException {
        return this.put((KEY)((Comparable)value.getId()), value);
    }

    @Override
    public IdentifiableMessage<KEY, M, MB> remove(Object key) {
        IdentifiableMessage removedValue = (IdentifiableMessage)super.remove(key);
        if (removedValue != null) {
            removedValue.removeObserver(this.observer);
            this.syncBuilder();
        }
        return removedValue;
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends IdentifiableMessage<KEY, M, MB>> valueMap) {
        for (Map.Entry<KEY, IdentifiableMessage<KEY, M, MB>> entry : valueMap.entrySet()) {
            if (entry.getValue() == null) continue;
            IdentifiableMessage<KEY, M, MB> oldValue = super.put(entry.getKey(), entry.getValue());
            if (oldValue != null) {
                oldValue.removeObserver(this.observer);
            }
            entry.getValue().addObserver(this.observer);
        }
        this.syncBuilder();
    }

    @Override
    public void clear() {
        for (IdentifiableMessage value : this.values()) {
            value.removeObserver(this.observer);
        }
        super.clear();
        this.syncBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBuilder() {
        if (this.shudownDetected) {
            return;
        }
        BuilderSyncSetup<SIB> builderSyncSetup = this.builderSetup;
        synchronized (builderSyncSetup) {
            try {
                this.builderSetup.lockWrite(this);
                SIB builder = this.builderSetup.getBuilder();
                builder.clearField(this.fieldDescriptor);
                for (IdentifiableMessage value : this.values()) {
                    builder.addRepeatedField(this.fieldDescriptor, value.getMessage());
                }
            }
            finally {
                this.builderSetup.unlockWrite(false);
            }
        }
    }

    public void addObserver(Observer<IdentifiableMessage<KEY, M, MB>> observer) {
        this.observable.addObserver(observer);
    }

    public void removeObserver(Observer<IdentifiableMessage<KEY, M, MB>> observer) {
        this.observable.removeObserver(observer);
    }

    @Override
    public M getMessage(KEY key) throws CouldNotPerformException {
        return this.get(key).getMessage();
    }

    @Override
    public IdentifiableMessage<KEY, M, MB> get(KEY key) throws CouldNotPerformException {
        if (key == null) {
            throw new NotAvailableException("key");
        }
        if (!this.containsKey(key)) {
            throw new NotAvailableException("Value for key[" + key + "]");
        }
        return (IdentifiableMessage)super.get(key);
    }

    @Override
    public IdentifiableMessage<KEY, M, MB> get(IdentifiableMessage<KEY, M, MB> value) throws CouldNotPerformException {
        return this.get((KEY)((Comparable)value.getId()));
    }

    @Override
    public List<M> getMessages() throws CouldNotPerformException {
        ArrayList messageList = new ArrayList();
        this.values().stream().forEach((? super T messageContainer) -> messageList.add(messageContainer.getMessage()));
        return messageList;
    }

    public void shutdown() {
        this.observable.shutdown();
        this.shudownDetected = true;
    }
}

