/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.Map;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.jul.processing.VariableProvider;

public class ProtobufVariableProvider
implements VariableProvider {
    public static final String NAME_SUFIX = "VariableProvider";
    private final GeneratedMessage message;

    public ProtobufVariableProvider(GeneratedMessage message) {
        this.message = message;
    }

    public String getName() {
        return this.message.getDescriptorForType().getName() + NAME_SUFIX;
    }

    public String getValue(String variable) throws NotAvailableException {
        for (Map.Entry fieldEntry : this.message.getAllFields().entrySet()) {
            String key = StringProcessor.transformToUpperCase((String)((Descriptors.FieldDescriptor)fieldEntry.getKey()).getName());
            if (!key.equals(variable) && !(StringProcessor.transformToUpperCase((String)this.message.getClass().getSimpleName()) + "/" + key).equals(variable) || fieldEntry.getValue().toString().isEmpty()) continue;
            return fieldEntry.getValue().toString();
        }
        throw new NotAvailableException("Value for Variable[" + variable + "]");
    }
}

