/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import com.google.protobuf.GeneratedMessage;
import java.util.List;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.IdentifiableMessageMap;
import org.openbase.jul.iface.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufListDiff<KEY, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>> {
    protected final Logger logger = LoggerFactory.getLogger(ProtobufListDiff.class);
    private IdentifiableMessageMap<KEY, M, MB> newMessages = new IdentifiableMessageMap();
    private IdentifiableMessageMap<KEY, M, MB> updatedMessages = new IdentifiableMessageMap();
    private IdentifiableMessageMap<KEY, M, MB> removedMessages = new IdentifiableMessageMap();
    private IdentifiableMessageMap<KEY, M, MB> originMessages = new IdentifiableMessageMap();

    public ProtobufListDiff(List<M> originMessages) {
        this();
        this.originMessages.putAll(new IdentifiableMessageMap(originMessages));
    }

    public ProtobufListDiff(IdentifiableMessageMap<KEY, M, MB> originMessages) {
        this();
        this.originMessages.putAll(originMessages);
    }

    public ProtobufListDiff() {
    }

    public void diff(List<M> modifieredList) {
        this.diff(new IdentifiableMessageMap(modifieredList));
    }

    public void diff(List<M> originalList, List<M> modifieredList) {
        this.diff(new IdentifiableMessageMap(originalList), new IdentifiableMessageMap(modifieredList));
    }

    public void diff(IdentifiableMessageMap<KEY, M, MB> modifieredMap) {
        this.diff(this.originMessages, modifieredMap);
    }

    public void diff(IdentifiableMessageMap<KEY, M, MB> originalMap, IdentifiableMessageMap<KEY, M, MB> modifieredMap) {
        this.newMessages.clear();
        this.updatedMessages.clear();
        this.removedMessages.clear();
        IdentifiableMessageMap modifieredListCopy = new IdentifiableMessageMap(modifieredMap);
        originalMap.keySet().stream().forEach(id -> {
            try {
                if (modifieredMap.containsKey(id)) {
                    if (!((IdentifiableMessage)originalMap.get(id)).getMessage().equals(((IdentifiableMessage)modifieredMap.get(id)).getMessage())) {
                        this.updatedMessages.put((Identifiable)modifieredMap.get(id));
                    }
                    modifieredListCopy.remove(id);
                } else {
                    this.removedMessages.put((Identifiable)originalMap.get(id));
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Ignoring invalid Message[" + id + "]", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        });
        this.newMessages.putAll(modifieredListCopy);
        this.originMessages = modifieredMap;
    }

    public IdentifiableMessageMap<KEY, M, MB> getNewMessageMap() {
        return this.newMessages;
    }

    public IdentifiableMessageMap<KEY, M, MB> getUpdatedMessageMap() {
        return this.updatedMessages;
    }

    public IdentifiableMessageMap<KEY, M, MB> getRemovedMessageMap() {
        return this.removedMessages;
    }

    public int getChangeCounter() {
        return this.newMessages.size() + this.updatedMessages.size() + this.removedMessages.size();
    }

    public void replaceOriginMap(IdentifiableMessageMap<KEY, M, MB> originMap) {
        this.originMessages.clear();
        this.originMessages.putAll(originMap);
    }

    public IdentifiableMessageMap<KEY, M, MB> getOriginMessages() {
        return this.originMessages;
    }
}

