/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import java.util.HashMap;
import java.util.Map;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.iface.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifiableValueMap<KEY, VALUE extends Identifiable<KEY>>
extends HashMap<KEY, VALUE> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public IdentifiableValueMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentifiableValueMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentifiableValueMap() {
    }

    public IdentifiableValueMap(Map<? extends KEY, ? extends VALUE> m) {
        super(m);
    }

    public void put(VALUE value) throws CouldNotPerformException {
        try {
            this.put(value.getId(), value);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not put value to list!", (Throwable)ex);
        }
    }

    public VALUE removeValue(Identifiable<KEY> value) throws CouldNotPerformException {
        return (VALUE)((Identifiable)super.remove(value.getId()));
    }
}

