/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import com.google.protobuf.GeneratedMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.IdentifiableValueMap;
import org.slf4j.Logger;

public class IdentifiableMessageMap<KEY, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends IdentifiableValueMap<KEY, IdentifiableMessage<KEY, M, MB>> {
    public IdentifiableMessageMap(List<M> messageList) {
        if (messageList == null) {
            return;
        }
        for (GeneratedMessage message : messageList) {
            try {
                this.put(new IdentifiableMessage(message));
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not add Message[" + message + "] to message map!", (Throwable)ex), (Logger)this.logger);
            }
        }
    }

    public IdentifiableMessageMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentifiableMessageMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentifiableMessageMap() {
    }

    public IdentifiableMessageMap(Map<? extends KEY, ? extends IdentifiableMessage<KEY, M, MB>> m) {
        super(m);
    }

    public Set<M> getMessages() {
        HashSet messages = new HashSet();
        for (IdentifiableMessage identifiableMessage : this.values()) {
            messages.add(identifiableMessage.getMessage());
        }
        return messages;
    }

    public M removeMessage(M message) throws CouldNotPerformException {
        return ((IdentifiableMessage)super.removeValue(new IdentifiableMessage(message))).getMessage();
    }
}

