/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import com.google.protobuf.GeneratedMessage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPDebugMode;
import org.openbase.jps.preset.JPTestMode;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.iface.Changeable;
import org.openbase.jul.schedule.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderSyncSetup<MB extends GeneratedMessage.Builder<MB>> {
    public static final long LOCK_TIMEOUT = 10000L;
    protected final Logger logger = LoggerFactory.getLogger(BuilderSyncSetup.class);
    private final Changeable holder;
    private final MB builder;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Timeout readLockTimeout;
    private final Timeout writeLockTimeout;
    private Object readLockConsumer;
    private Object writeLockConsumer;

    public BuilderSyncSetup(MB builder, ReentrantReadWriteLock.ReadLock readLock, ReentrantReadWriteLock.WriteLock writeLock, Changeable holder) {
        this.builder = builder;
        this.readLock = readLock;
        this.writeLock = writeLock;
        this.holder = holder;
        this.readLockTimeout = new Timeout(10000L, (GeneratedMessage.Builder)builder){
            final /* synthetic */ GeneratedMessage.Builder val$builder;
            {
                this.val$builder = builder;
                super(x0);
            }

            public void expired() {
                try {
                    if (((Boolean)((JPDebugMode)JPService.getProperty(JPDebugMode.class)).getValue()).booleanValue()) {
                        return;
                    }
                }
                catch (JPServiceException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)BuilderSyncSetup.this.logger);
                }
                ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException("Fatal implementation error!", (Throwable)new TimeoutException("ReadLock of " + this.val$builder.buildPartial().getClass().getSimpleName() + " was locked for more than " + 10L + " sec! Last access by Consumer[" + BuilderSyncSetup.this.readLockConsumer + "]!")), (Logger)BuilderSyncSetup.this.logger);
                BuilderSyncSetup.this.unlockRead("TimeoutHandler");
            }
        };
        this.writeLockTimeout = new Timeout(10000L, (GeneratedMessage.Builder)builder){
            final /* synthetic */ GeneratedMessage.Builder val$builder;
            {
                this.val$builder = builder;
                super(x0);
            }

            public void expired() {
                try {
                    if (((Boolean)((JPTestMode)JPService.getProperty(JPTestMode.class)).getValue()).booleanValue()) {
                        return;
                    }
                }
                catch (JPServiceException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)BuilderSyncSetup.this.logger);
                }
                ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException("Fatal implementation error!", (Throwable)new TimeoutException("WriteLock of " + this.val$builder.buildPartial().getClass().getSimpleName() + " was locked for more than " + 10L + " sec by Consumer[" + BuilderSyncSetup.this.writeLockConsumer + "]!")), (Logger)BuilderSyncSetup.this.logger);
                BuilderSyncSetup.this.unlockWrite();
            }
        };
    }

    public MB getBuilder() {
        return this.builder;
    }

    public void lockRead(Object consumer) {
        this.logger.debug("order lockRead by " + consumer);
        this.readLock.lock();
        this.readLockConsumer = consumer;
        this.readLockTimeout.restart();
        this.logger.debug("lockRead by " + consumer);
    }

    public boolean tryLockRead(Object consumer) {
        boolean success = this.readLock.tryLock();
        if (success) {
            this.readLockConsumer = consumer;
            this.readLockTimeout.restart();
        }
        return success;
    }

    public boolean tryLockRead(long time, TimeUnit unit, Object consumer) throws InterruptedException {
        boolean success = this.readLock.tryLock(time, unit);
        if (success) {
            this.readLockConsumer = consumer;
            this.readLockTimeout.restart();
        }
        return success;
    }

    public void unlockRead(Object consumer) {
        this.logger.debug("order unlockRead by " + consumer);
        if (this.readLockConsumer == consumer) {
            this.readLockConsumer = "Unknown";
        }
        this.readLockTimeout.cancel();
        this.readLock.unlock();
        this.logger.debug("unlockRead by " + consumer);
    }

    public void lockWrite(Object consumer) {
        this.logger.debug("order lockWrite by " + consumer);
        this.writeLock.lock();
        this.writeLockConsumer = consumer;
        this.writeLockTimeout.start();
        this.logger.debug("lockWrite by " + consumer);
    }

    public boolean tryLockWrite(Object consumer) {
        boolean success = this.writeLock.tryLock();
        if (success) {
            this.writeLockConsumer = consumer;
            this.writeLockTimeout.start();
        }
        return success;
    }

    public boolean tryLockWrite(long time, TimeUnit unit, Object consumer) throws InterruptedException {
        boolean success = this.writeLock.tryLock(time, unit);
        if (success) {
            this.writeLockConsumer = consumer;
            this.writeLockTimeout.restart();
        }
        return success;
    }

    public void unlockWrite() {
        this.unlockWrite(true);
    }

    public void unlockWrite(boolean notifyChange) {
        this.logger.debug("order write unlock");
        this.writeLockTimeout.cancel();
        this.writeLock.unlock();
        this.writeLockConsumer = "Unknown";
        this.logger.debug("write unlocked");
        if (notifyChange) {
            try {
                try {
                    this.holder.notifyChange();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw ex;
                }
            }
            catch (InterruptedException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform builder holder about data update!", ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        }
    }
}

