/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.lang.reflect.Method;
import java.util.List;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.processing.StringProcessor;

public class BuilderProcessor {
    public static List<GeneratedMessage.Builder> extractRepeatedFieldBuilderList(int repeatedFieldNumber, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        return BuilderProcessor.extractRepeatedFieldBuilderList(builder.getDescriptorForType().findFieldByNumber(repeatedFieldNumber), builder);
    }

    public static List<GeneratedMessage.Builder> extractRepeatedFieldBuilderList(Descriptors.FieldDescriptor repeatedFieldDescriptor, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        if (repeatedFieldDescriptor == null) {
            throw new NotAvailableException("repeatedFieldDescriptor");
        }
        return BuilderProcessor.extractRepeatedFieldBuilderList(repeatedFieldDescriptor.getName(), builder);
    }

    public static List<GeneratedMessage.Builder> extractRepeatedFieldBuilderList(String repeatedFieldName, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        try {
            Method method;
            Class<?> builderClass = builder.getClass();
            try {
                method = builderClass.getMethod("get" + StringProcessor.transformUpperCaseToCamelCase((String)repeatedFieldName) + "BuilderList", new Class[0]);
            }
            catch (Exception ex) {
                throw new CouldNotPerformException("Missing RepeatedField[" + repeatedFieldName + "] in protobuf Type[" + builder.getClass().getName() + "]! ", (Throwable)ex);
            }
            try {
                return (List)method.invoke((Object)builder, new Object[0]);
            }
            catch (Exception ex) {
                throw new CouldNotPerformException("Could not extract builder list!", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could extract builder collection out of Builder[" + builder.getClass().getName() + "]!", (Throwable)ex);
        }
    }

    public static GeneratedMessage.Builder addMessageToRepeatedField(int repeatedFieldNumber, GeneratedMessage.Builder messageBuilder, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        return BuilderProcessor.addMessageToRepeatedField(builder.getDescriptorForType().findFieldByNumber(repeatedFieldNumber), messageBuilder, builder);
    }

    public static GeneratedMessage.Builder addMessageToRepeatedField(Descriptors.FieldDescriptor repeatedFieldDescriptor, GeneratedMessage.Builder messageBuilder, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        if (repeatedFieldDescriptor == null) {
            throw new NotAvailableException("repeatedFieldDescriptor");
        }
        return BuilderProcessor.addMessageToRepeatedField(repeatedFieldDescriptor.getName(), messageBuilder, builder);
    }

    public static GeneratedMessage.Builder addMessageToRepeatedField(String repeatedFieldName, GeneratedMessage.Builder messageBuilder, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        try {
            Method method;
            Class<?> builderClass = builder.getClass();
            try {
                method = builderClass.getMethod("add" + StringProcessor.transformUpperCaseToCamelCase((String)repeatedFieldName), messageBuilder.getClass());
            }
            catch (Exception ex) {
                throw new CouldNotPerformException("Missing RepeatedField[" + repeatedFieldName + "] in protobuf Type[" + builder.getClass().getName() + "]! ", (Throwable)ex);
            }
            try {
                method.invoke((Object)builder, messageBuilder);
            }
            catch (Exception ex) {
                throw new CouldNotPerformException("Could not add message builder to repeated field!", (Throwable)ex);
            }
            return builder;
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could add message Builder[" + messageBuilder.getClass().getName() + "] to repeated Field[" + repeatedFieldName + "] of Builder[" + builder.getClass().getName() + "]!", (Throwable)ex);
        }
    }

    public static GeneratedMessage.Builder addDefaultInstanceToRepeatedField(int repeatedFieldNumber, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        return BuilderProcessor.addDefaultInstanceToRepeatedField(builder.getDescriptorForType().findFieldByNumber(repeatedFieldNumber), builder);
    }

    public static GeneratedMessage.Builder addDefaultInstanceToRepeatedField(Descriptors.FieldDescriptor repeatedFieldDescriptor, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        if (repeatedFieldDescriptor == null) {
            throw new NotAvailableException("repeatedFieldDescriptor");
        }
        return BuilderProcessor.addDefaultInstanceToRepeatedField(repeatedFieldDescriptor.getName(), builder);
    }

    public static GeneratedMessage.Builder addDefaultInstanceToRepeatedField(String repeatedFieldName, GeneratedMessage.Builder builder) throws CouldNotPerformException {
        try {
            Method method;
            Class<?> builderClass = builder.getClass();
            try {
                method = builderClass.getMethod("add" + StringProcessor.transformUpperCaseToCamelCase((String)repeatedFieldName) + "Builder", new Class[0]);
            }
            catch (Exception ex) {
                throw new CouldNotPerformException("Missing RepeatedField[" + repeatedFieldName + "] in protobuf Type[" + builder.getClass().getName() + "]! ", (Throwable)ex);
            }
            try {
                return (GeneratedMessage.Builder)method.invoke((Object)builder, new Object[0]);
            }
            catch (Exception ex) {
                throw new CouldNotPerformException("Could not add default message builder to repeated field!", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could add default instance to repeated Field[" + repeatedFieldName + "] of Builder[" + builder.getClass().getName() + "]!", (Throwable)ex);
        }
    }
}

