/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.util;

import com.google.protobuf.GeneratedMessage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.processing.StringProcessor;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class UnitConfigProcessor {
    public static final Package UNIT_PACKAGE = UnitConfigType.UnitConfig.class.getPackage();
    private static final List<UnitTemplateType.UnitTemplate.UnitType> DAL_UNIT_TYPE_LIST = new ArrayList<UnitTemplateType.UnitTemplate.UnitType>();

    public static boolean isHostUnit(UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException {
        UnitConfigProcessor.verifyUnitConfig((UnitConfigType.UnitConfigOrBuilder)unitConfig, unitConfig.getType());
        return UnitConfigProcessor.isHostUnit(unitConfig.getType());
    }

    public static boolean isHostUnit(UnitTemplateType.UnitTemplate.UnitType unitType) {
        switch (unitType) {
            case APP: 
            case DEVICE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDalUnit(UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException {
        UnitConfigProcessor.verifyUnitConfig((UnitConfigType.UnitConfigOrBuilder)unitConfig, unitConfig.getType());
        return UnitConfigProcessor.isDalUnit(unitConfig.getType());
    }

    public static boolean isDalUnit(UnitTemplateType.UnitTemplate.UnitType unitType) {
        return !UnitConfigProcessor.isBaseUnit(unitType);
    }

    public static boolean isBaseUnit(UnitConfigType.UnitConfigOrBuilder unitConfig) throws CouldNotPerformException {
        UnitConfigProcessor.verifyUnitConfig(unitConfig, unitConfig.getType());
        return UnitConfigProcessor.isBaseUnit(unitConfig.getType());
    }

    public static boolean isBaseUnit(UnitTemplateType.UnitTemplate.UnitType unitType) {
        switch (unitType) {
            case APP: 
            case DEVICE: 
            case AGENT: 
            case AUTHORIZATION_GROUP: 
            case CONNECTION: 
            case LOCATION: 
            case SCENE: 
            case UNIT_GROUP: 
            case USER: {
                return true;
            }
        }
        return false;
    }

    public static boolean isVirtualUnit(UnitConfigType.UnitConfigOrBuilder unitConfig) throws CouldNotPerformException {
        if (UnitConfigProcessor.isBaseUnit(unitConfig)) {
            return false;
        }
        return unitConfig.getUnitHostId().equals(unitConfig.getId());
    }

    public static void verifyUnitType(UnitConfigType.UnitConfigOrBuilder unitConfig, UnitTemplateType.UnitTemplate.UnitType unitType) throws VerificationFailedException {
        if (!unitConfig.hasType()) {
            throw new VerificationFailedException("UnitType not available!");
        }
        if (unitConfig.getType() != unitType) {
            throw new VerificationFailedException("UnitType verification failed. Expected[" + unitType + "] but was[" + unitConfig.getType() + "]!");
        }
    }

    public static void verifyUnitConfig(UnitConfigType.UnitConfigOrBuilder unitConfig, UnitTemplateType.UnitTemplate.UnitType unitType) throws VerificationFailedException {
        UnitConfigProcessor.verifyUnitType(unitConfig, unitType);
        if (UnitConfigProcessor.isBaseUnit(unitType)) {
            try {
                if (!((Boolean)unitConfig.getClass().getMethod("has" + StringProcessor.transformUpperCaseToCamelCase((String)unitType.name()) + "Config", new Class[0]).invoke((Object)unitConfig, new Object[0])).booleanValue()) {
                    throw new VerificationFailedException("UnitType config missing of given UnitConfig!");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException ex) {
                throw new VerificationFailedException("Given unit config is not compatible with current programm version!", (Throwable)ex);
            }
        }
    }

    public static void verifyUnit(UnitConfigType.UnitConfig unitConfig) throws VerificationFailedException {
        UnitConfigProcessor.verifyUnitConfig((UnitConfigType.UnitConfigOrBuilder)unitConfig, unitConfig.getType());
        UnitConfigProcessor.verifyUnitType((UnitConfigType.UnitConfigOrBuilder)unitConfig, unitConfig.getType());
    }

    public static synchronized List<UnitTemplateType.UnitTemplate.UnitType> getDalUnitTypes() {
        if (DAL_UNIT_TYPE_LIST.isEmpty()) {
            for (UnitTemplateType.UnitTemplate.UnitType unitType : UnitTemplateType.UnitTemplate.UnitType.values()) {
                if (!UnitConfigProcessor.isDalUnit(unitType)) continue;
                DAL_UNIT_TYPE_LIST.add(unitType);
            }
        }
        return DAL_UNIT_TYPE_LIST;
    }

    public static String getUnitDataClassName(UnitTemplateType.UnitTemplate.UnitType unitType) {
        return StringProcessor.transformUpperCaseToCamelCase((String)unitType.name()) + "Data";
    }

    public static Class<? extends GeneratedMessage> getUnitDataClass(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        String unitDataClassSimpleName = UnitConfigProcessor.getUnitDataClassName(unitType);
        String unitDataClassName = UNIT_PACKAGE.getName() + "." + (UnitConfigProcessor.isBaseUnit(unitType) ? unitType.name().toLowerCase().replaceAll("_", "") : "dal") + "." + unitDataClassSimpleName + "Type$" + unitDataClassSimpleName;
        try {
            return Class.forName(unitDataClassName);
        }
        catch (ClassCastException | ClassNotFoundException | NullPointerException ex) {
            throw new NotAvailableException("UnitDataClass", unitDataClassName, (Throwable)new CouldNotPerformException("Could not detect class!", (Throwable)ex));
        }
    }

    public static Class<? extends GeneratedMessage> getUnitDataClass(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException {
        return UnitConfigProcessor.getUnitDataClass(unitConfig.getType());
    }
}

