/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.Map;
import org.openbase.bco.registry.lib.com.RemoteRegistrySynchronizer;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.processing.ProtoBufFieldProcessor;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.pattern.AbstractFilter;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedRemoteRegistry<KEY, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends RemoteRegistry<KEY, M, MB>
implements Activatable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedRemoteRegistry.class);
    private final Descriptors.FieldDescriptor[] fieldDescriptors;
    private final RSBRemoteService<M> remoteService;
    private Observable<M> observable;
    private final RemoteRegistrySynchronizer<M> remoteRegistrySynchronizer;
    private boolean active;
    private AbstractFilter filter;
    private Observer filterObserver;

    public SynchronizedRemoteRegistry(RSBRemoteService remoteService, int ... protobufFieldNumbers) throws InstantiationException {
        try {
            this.observable = null;
            this.fieldDescriptors = ProtoBufFieldProcessor.getFieldDescriptors((Class)remoteService.getDataClass(), (int[])protobufFieldNumbers);
            this.remoteService = remoteService;
            this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer(this, this.fieldDescriptors);
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public SynchronizedRemoteRegistry(RSBRemoteService remoteService, AbstractFilter<M> filter, int ... protobufFieldNumbers) throws InstantiationException {
        try {
            this.fieldDescriptors = ProtoBufFieldProcessor.getFieldDescriptors((Class)remoteService.getDataClass(), (int[])protobufFieldNumbers);
            this.remoteService = remoteService;
            this.filter = filter;
            this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer<M>(this, this.fieldDescriptors, filter);
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public SynchronizedRemoteRegistry(Observable observable, RSBRemoteService remoteService, int ... protobufFieldNumbers) throws InstantiationException {
        try {
            this.observable = observable;
            this.fieldDescriptors = ProtoBufFieldProcessor.getFieldDescriptors((Class)remoteService.getDataClass(), (int[])protobufFieldNumbers);
            this.remoteService = remoteService;
            this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer(this, this.fieldDescriptors);
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public SynchronizedRemoteRegistry(Observable observable, RSBRemoteService remoteService, AbstractFilter<M> filter, int ... protobufFieldNumbers) throws InstantiationException {
        try {
            this.observable = observable;
            this.fieldDescriptors = ProtoBufFieldProcessor.getFieldDescriptors((Class)remoteService.getDataClass(), (int[])protobufFieldNumbers);
            this.remoteService = remoteService;
            this.filter = filter;
            this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer<M>(this, this.fieldDescriptors, filter);
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public SynchronizedRemoteRegistry(Observable observable, RSBRemoteService<M> remoteService, Descriptors.FieldDescriptor ... fieldDescriptors) throws InstantiationException {
        this.observable = observable;
        this.fieldDescriptors = fieldDescriptors;
        this.remoteService = remoteService;
        this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer(this, fieldDescriptors);
    }

    public SynchronizedRemoteRegistry(Observable observable, RSBRemoteService<M> remoteService, Map<KEY, IdentifiableMessage<KEY, M, MB>> internalMap, Descriptors.FieldDescriptor ... fieldDescriptors) throws InstantiationException {
        super(internalMap);
        this.observable = observable;
        this.fieldDescriptors = fieldDescriptors;
        this.remoteService = remoteService;
        this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer(this, fieldDescriptors);
    }

    public Descriptors.FieldDescriptor[] getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public RSBRemoteService<M> getRemoteService() {
        return this.remoteService;
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        if (this.active) {
            this.logger.warn("Already activated");
            return;
        }
        if (this.observable != null) {
            this.observable.addObserver(this.remoteRegistrySynchronizer);
            if (this.observable.isValueAvailable()) {
                try {
                    this.remoteRegistrySynchronizer.update((Observable<GeneratedMessage>)null, (GeneratedMessage)this.observable.getValue());
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((String)("Initial synchronization of " + (Object)((Object)this) + " failed!"), (Throwable)ex, (Logger)LOGGER);
                }
            }
        } else {
            this.remoteService.addDataObserver(this.remoteRegistrySynchronizer);
            if (this.remoteService.isDataAvailable()) {
                try {
                    this.remoteRegistrySynchronizer.update((Observable<GeneratedMessage>)null, this.remoteService.getData());
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((String)("Initial synchronization of " + (Object)((Object)this) + " failed!"), (Throwable)ex, (Logger)LOGGER);
                }
            }
        }
        this.filterObserver = (source, data) -> {
            if (this.remoteService.isDataAvailable()) {
                this.remoteRegistrySynchronizer.update((Observable<GeneratedMessage>)null, this.remoteService.getData());
            }
        };
        if (this.filter != null) {
            this.filter.addObserver(this.filterObserver);
        }
        this.active = true;
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        if (this.observable != null) {
            this.observable.removeObserver(this.remoteRegistrySynchronizer);
        } else {
            this.remoteService.removeDataObserver(this.remoteRegistrySynchronizer);
        }
        if (this.filter != null) {
            this.filter.removeObserver(this.filterObserver);
        }
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getName() {
        if (this.fieldDescriptors == null || this.fieldDescriptors.length == 0) {
            return ((Object)((Object)this)).getClass().getSimpleName() + "[" + (this.remoteService != null ? this.remoteService.toString() : "?") + "]";
        }
        String fieldDescritorNames = "[";
        fieldDescritorNames = fieldDescritorNames + this.fieldDescriptors[0].getName();
        for (int i = 1; i < this.fieldDescriptors.length; ++i) {
            fieldDescritorNames = fieldDescritorNames + ", " + this.fieldDescriptors[i].getName();
        }
        fieldDescritorNames = fieldDescritorNames + "]";
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.remoteService.toString() + "]" + fieldDescritorNames;
    }

    public AbstractFilter getFilter() {
        return this.filter;
    }
}

