/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.util;

import java.util.ArrayList;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.storage.registry.ProtoBufRegistry;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.device.DeviceClassType;

public class DeviceConfigUtils {
    public static boolean checkDuplicatedUnitType(UnitConfigType.UnitConfigOrBuilder deviceUnitConfig, ProtoBufRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> dalUnitRegistry) throws CouldNotPerformException {
        ArrayList<UnitTemplateType.UnitTemplate.UnitType> unitTypeList = new ArrayList<UnitTemplateType.UnitTemplate.UnitType>();
        for (String unitId : deviceUnitConfig.getDeviceConfig().getUnitIdList()) {
            if (!dalUnitRegistry.contains((Object)unitId)) continue;
            UnitConfigType.UnitConfig dalUnitConfig = (UnitConfigType.UnitConfig)dalUnitRegistry.getMessage((Object)unitId);
            if (unitTypeList.contains(dalUnitConfig.getType())) {
                return true;
            }
            unitTypeList.add(dalUnitConfig.getType());
        }
        return false;
    }

    public static boolean setupUnitLabelByDeviceConfig(UnitConfigType.UnitConfig.Builder unitConfig, UnitConfigType.UnitConfigOrBuilder deviceConfig, DeviceClassType.DeviceClassOrBuilder deviceClass, ProtoBufRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> dalUnitRegistry) throws CouldNotPerformException {
        return DeviceConfigUtils.setupUnitLabelByDeviceConfig(unitConfig, deviceConfig, deviceClass, DeviceConfigUtils.checkDuplicatedUnitType(deviceConfig, dalUnitRegistry));
    }

    public static boolean setupUnitLabelByDeviceConfig(UnitConfigType.UnitConfig.Builder unitConfig, UnitConfigType.UnitConfigOrBuilder deviceUnitConfig, DeviceClassType.DeviceClassOrBuilder deviceClass, boolean deviceConfigHasDuplicatedUnitType) throws CouldNotPerformException {
        try {
            if (!unitConfig.hasLabel() || unitConfig.getLabel().isEmpty() || unitConfig.getBoundToUnitHost()) {
                if (deviceConfigHasDuplicatedUnitType) {
                    if (unitConfig.hasLabel() && !unitConfig.getLabel().isEmpty()) {
                        return false;
                    }
                    if (!unitConfig.hasUnitTemplateConfigId()) {
                        throw new NotAvailableException("unitconfig.unittemplateconfigid");
                    }
                    for (UnitTemplateConfigType.UnitTemplateConfig unitTemplateConfig : deviceClass.getUnitTemplateConfigList()) {
                        if (!unitTemplateConfig.getId().equals(unitConfig.getUnitTemplateConfigId())) continue;
                        if (unitTemplateConfig.getLabel().isEmpty()) {
                            throw new NotAvailableException("unitTemplateConfig.label");
                        }
                        unitConfig.setLabel(deviceUnitConfig.getLabel() + "_" + unitTemplateConfig.getLabel());
                        return true;
                    }
                    throw new CouldNotPerformException("DeviceClass[" + deviceClass.getId() + "] does not contain UnitTemplateConfig[" + unitConfig.getUnitTemplateConfigId() + "]!");
                }
                if (!deviceUnitConfig.hasLabel()) {
                    throw new NotAvailableException("deviceconfig.label");
                }
                if (!unitConfig.getLabel().equals(deviceUnitConfig.getLabel())) {
                    unitConfig.setLabel(deviceUnitConfig.getLabel());
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not setup UnitConfig[" + unitConfig.getId() + "] by DeviceConfig[" + deviceUnitConfig + "]!", (Throwable)ex);
        }
    }
}

